using System;
using System.ComponentModel;
using System.IO;
using System.Windows.Forms;
using ioko.ComponentModel.LicenseProvider;
using MCMSUtils;

namespace CMSConvLogWinApp
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	[LicenseProvider(typeof(PlusPackLicenseProvider))]
	public class frmMain : Form
	{
		private OpenFileDialog openFileDialogSource;
		private Button button1;
		private TextBox tbSourceFiles;
		private Button button2;
		private FolderBrowserDialog folderBrowserDialogDestination;
		private TextBox tbOutputDirectory;
		private Button button3;
		private Button button4;
		private GroupBox groupBox1;
		private GroupBox groupBox2;
		private ProgressBar progressBar1;
		private StatusBar statusBar1;
		private MainMenu mainMenu1;
		private MenuItem menuItem1;
		private MenuItem menuItem3;
		private MenuItem menuItem6;
		private MenuItem menuItemExit;
		private MenuItem menuItemChooseLogFiles;
		private MenuItem menuItemChooseOutputDirectory;
		private MenuItem menuItemToolsConvert;
		private Label lbSourceDirectory;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private Container components = null;

		#region Licensing Test
		private static bool ValidateLicense(Form form)
		{
			try
			{
				PlusPackLicense license = (PlusPackLicense)LicenseManager.Validate(typeof(frmMain),form);

				switch(license.Validity)
				{
					case MSIBLicenseValidator.LicenseState.Full:
						return true;

					case MSIBLicenseValidator.LicenseState.Trial_Active:
						TimeSpan span = license.ExpiryDate.Date.Subtract(DateTime.Now);
						int daysRemaining = span.Days + 1;
						if (daysRemaining <= 7)
							MessageBox.Show(String.Format("Warning: Your trial license of MSIB Plus Pack will run out in {0} days. This component will function normally for the remainder of today.",
								daysRemaining));
						return true;

					case MSIBLicenseValidator.LicenseState.Invalid:
					case MSIBLicenseValidator.LicenseState.None:
						break;

					case MSIBLicenseValidator.LicenseState.Trial_Expired:
						MessageBox.Show("Your trial MSIB Plus Pack trial license has expired. To continue using this component please purchase the relevant license(s).");
						return false;
				}		
			} 
			catch {}

			MessageBox.Show("You need a valid MSIB Plus Pack license. Please purchase the relevant license(s).");
			return false;
		}
		#endregion

		public frmMain()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(frmMain));
			this.openFileDialogSource = new System.Windows.Forms.OpenFileDialog();
			this.folderBrowserDialogDestination = new System.Windows.Forms.FolderBrowserDialog();
			this.button1 = new System.Windows.Forms.Button();
			this.tbSourceFiles = new System.Windows.Forms.TextBox();
			this.button2 = new System.Windows.Forms.Button();
			this.tbOutputDirectory = new System.Windows.Forms.TextBox();
			this.button3 = new System.Windows.Forms.Button();
			this.button4 = new System.Windows.Forms.Button();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.lbSourceDirectory = new System.Windows.Forms.Label();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.progressBar1 = new System.Windows.Forms.ProgressBar();
			this.statusBar1 = new System.Windows.Forms.StatusBar();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItemChooseLogFiles = new System.Windows.Forms.MenuItem();
			this.menuItemChooseOutputDirectory = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.menuItemExit = new System.Windows.Forms.MenuItem();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.menuItemToolsConvert = new System.Windows.Forms.MenuItem();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.SuspendLayout();
			// 
			// openFileDialogSource
			// 
			this.openFileDialogSource.DefaultExt = "log";
			this.openFileDialogSource.Filter = "IIS Log Files|*.log";
			this.openFileDialogSource.InitialDirectory = "\\windows\\system32\\logfiles";
			this.openFileDialogSource.Multiselect = true;
			this.openFileDialogSource.Title = "Pick an ISS log file to convert";
			// 
			// folderBrowserDialogDestination
			// 
			this.folderBrowserDialogDestination.Description = "Select the directory to place the converted logs";
			this.folderBrowserDialogDestination.SelectedPath = "\\WINDOWS\\system32\\Logfiles";
			// 
			// button1
			// 
			this.button1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.button1.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.button1.Location = new System.Drawing.Point(528, 48);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(24, 24);
			this.button1.TabIndex = 3;
			this.button1.Text = "...";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// tbSourceFiles
			// 
			this.tbSourceFiles.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tbSourceFiles.Location = new System.Drawing.Point(8, 48);
			this.tbSourceFiles.Name = "tbSourceFiles";
			this.tbSourceFiles.ReadOnly = true;
			this.tbSourceFiles.Size = new System.Drawing.Size(512, 20);
			this.tbSourceFiles.TabIndex = 4;
			this.tbSourceFiles.Text = "";
			// 
			// button2
			// 
			this.button2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.button2.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.button2.Location = new System.Drawing.Point(528, 24);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(24, 24);
			this.button2.TabIndex = 5;
			this.button2.Text = "...";
			this.button2.Click += new System.EventHandler(this.button2_Click);
			// 
			// tbOutputDirectory
			// 
			this.tbOutputDirectory.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tbOutputDirectory.Location = new System.Drawing.Point(8, 24);
			this.tbOutputDirectory.Name = "tbOutputDirectory";
			this.tbOutputDirectory.ReadOnly = true;
			this.tbOutputDirectory.Size = new System.Drawing.Size(512, 20);
			this.tbOutputDirectory.TabIndex = 6;
			this.tbOutputDirectory.Text = "";
			// 
			// button3
			// 
			this.button3.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.button3.Location = new System.Drawing.Point(392, 176);
			this.button3.Name = "button3";
			this.button3.Size = new System.Drawing.Size(88, 24);
			this.button3.TabIndex = 7;
			this.button3.Text = "&Convert";
			this.button3.Click += new System.EventHandler(this.button3_Click);
			// 
			// button4
			// 
			this.button4.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.button4.Location = new System.Drawing.Point(488, 176);
			this.button4.Name = "button4";
			this.button4.Size = new System.Drawing.Size(88, 24);
			this.button4.TabIndex = 8;
			this.button4.Text = "&Exit";
			this.button4.Click += new System.EventHandler(this.button4_Click);
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.lbSourceDirectory);
			this.groupBox1.Controls.Add(this.button1);
			this.groupBox1.Controls.Add(this.tbSourceFiles);
			this.groupBox1.Location = new System.Drawing.Point(8, 8);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(568, 80);
			this.groupBox1.TabIndex = 9;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Log Files";
			// 
			// lbSourceDirectory
			// 
			this.lbSourceDirectory.Location = new System.Drawing.Point(8, 24);
			this.lbSourceDirectory.Name = "lbSourceDirectory";
			this.lbSourceDirectory.Size = new System.Drawing.Size(504, 16);
			this.lbSourceDirectory.TabIndex = 5;
			this.lbSourceDirectory.Text = "(Directory)";
			// 
			// groupBox2
			// 
			this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox2.Controls.Add(this.button2);
			this.groupBox2.Controls.Add(this.tbOutputDirectory);
			this.groupBox2.Location = new System.Drawing.Point(8, 96);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(568, 56);
			this.groupBox2.TabIndex = 10;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Output Directory";
			// 
			// progressBar1
			// 
			this.progressBar1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.progressBar1.Location = new System.Drawing.Point(8, 176);
			this.progressBar1.Name = "progressBar1";
			this.progressBar1.Size = new System.Drawing.Size(360, 23);
			this.progressBar1.TabIndex = 11;
			this.progressBar1.Click += new System.EventHandler(this.progressBar1_Click_1);
			// 
			// statusBar1
			// 
			this.statusBar1.Location = new System.Drawing.Point(0, 205);
			this.statusBar1.Name = "statusBar1";
			this.statusBar1.Size = new System.Drawing.Size(586, 22);
			this.statusBar1.TabIndex = 12;
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItem1,
																					  this.menuItem6});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItemChooseLogFiles,
																					  this.menuItemChooseOutputDirectory,
																					  this.menuItem3,
																					  this.menuItemExit});
			this.menuItem1.Text = "&File";
			// 
			// menuItemChooseLogFiles
			// 
			this.menuItemChooseLogFiles.Index = 0;
			this.menuItemChooseLogFiles.Text = "Select &Log Files...";
			this.menuItemChooseLogFiles.Click += new System.EventHandler(this.menuItemChooseLogFiles_Click);
			// 
			// menuItemChooseOutputDirectory
			// 
			this.menuItemChooseOutputDirectory.Index = 1;
			this.menuItemChooseOutputDirectory.Text = "Select &Output Directory...";
			this.menuItemChooseOutputDirectory.Click += new System.EventHandler(this.menuItemChooseOutputDirectory_Click);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 2;
			this.menuItem3.Text = "-";
			// 
			// menuItemExit
			// 
			this.menuItemExit.Index = 3;
			this.menuItemExit.Text = "&Exit";
			this.menuItemExit.Click += new System.EventHandler(this.menuItemExit_Click);
			// 
			// menuItem6
			// 
			this.menuItem6.Index = 1;
			this.menuItem6.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItemToolsConvert});
			this.menuItem6.Text = "&Tools";
			// 
			// menuItemToolsConvert
			// 
			this.menuItemToolsConvert.Index = 0;
			this.menuItemToolsConvert.Text = "&Convert";
			this.menuItemToolsConvert.Click += new System.EventHandler(this.menuItemToolsConvert_Click);
			// 
			// frmMain
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(586, 227);
			this.Controls.Add(this.statusBar1);
			this.Controls.Add(this.progressBar1);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.button4);
			this.Controls.Add(this.button3);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Menu = this.mainMenu1;
			this.MinimumSize = new System.Drawing.Size(592, 272);
			this.Name = "frmMain";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "MSIB Plug Pack Log File Convertor";
			this.Load += new System.EventHandler(this.Form1_Load);
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Form form = new frmMain();
			if (ValidateLicense(form))
				Application.Run(form);
		}

		private void button1_Click(object sender, EventArgs e)
		{
			DialogResult rResult = this.openFileDialogSource.ShowDialog();

			if(rResult != DialogResult.Cancel)
			{
				string[] files = openFileDialogSource.FileNames;

				// Open each file and display the image in PictureBox1.
				// Call Application.DoEvents to force a repaint after each
				// file is read.  
      
				string strDisplayNames = "";

				foreach (string file in files )
				{
					FileInfo fileInfo = new FileInfo(file);
					strDisplayNames += fileInfo.Name + "; ";
					this.lbSourceDirectory.Text = fileInfo.DirectoryName;
				}
			
				this.tbSourceFiles.Text = strDisplayNames;
			}
		}

		private void Form1_Load(object sender, EventArgs e)
		{
			
			ModifyRegistry myRegistry = new ModifyRegistry();
			string strSourceDirectory = myRegistry.Read("SourceDirectory");
			string strOutputDirectory = myRegistry.Read("OutputDirectory");
			this.lbSourceDirectory.Text = strSourceDirectory;
			this.tbOutputDirectory.Text = strOutputDirectory;
			//this.folderBrowserDialogDestination.RootFolder = strOutputDirectory;
			this.folderBrowserDialogDestination.SelectedPath = strOutputDirectory;
			this.tbSourceFiles.Text = myRegistry.Read("Files");
		}

		private void progressBar1_Click(object sender, EventArgs e)
		{
		
		}

		private void button2_Click(object sender, EventArgs e)
		{
				this.folderBrowserDialogDestination.ShowDialog();
				this.tbOutputDirectory.Text = this.folderBrowserDialogDestination.SelectedPath;
		}

		private void lbSourceDirectory_Click(object sender, EventArgs e)
		{
		
		}

		private void button4_Click(object sender, EventArgs e)
		{
			ModifyRegistry myRegistry = new ModifyRegistry();
			myRegistry.Write("SourceDirectory",this.lbSourceDirectory.Text);
			myRegistry.Write("OutputDirectory",this.tbOutputDirectory.Text);
			myRegistry.Write("Files",this.tbSourceFiles.Text);
	//			string[] files = openFileDialogSource.FileNames;
	//
	//			// Open each file and display the image in PictureBox1.
	//			// Call Application.DoEvents to force a repaint after each
	//			// file is read.  
	//      
	//			
	//			int nCount=0;
	//			foreach (string file in files )
	//			{
	//				
	//				myRegistry.Write("filename" + nCount.ToString(),file);
	//				nCount++;
	//			}
	//			myRegistry.Write("filecount",nCount);
			Application.Exit();
		}

		private void button3_Click(object sender, EventArgs e)
		{
			this.statusBar1.Text = "Converting";
			this.statusBar1.Refresh();
			convlog myConvertor = new convlog();
			
			string[] myFiles = this.tbSourceFiles.Text.Split(';');
			
			
			this.progressBar1.Maximum = (myFiles.GetLength(0)>0?myFiles.GetLength(0)-1:0);
			this.progressBar1.Minimum = 0;
			this.progressBar1.Step = 1;

			int nCount = 0;

			
			Console.WriteLine("started conversion at " + DateTime.Now.Minute.ToString() + ":" + DateTime.Now.Second.ToString() + "." + DateTime.Now.Millisecond.ToString());
			foreach (string file in myFiles )
			{
				if(file.Trim() != "")
				{
					this.progressBar1.Increment(1);
					nCount += ((myConvertor.ConvertFile(this.lbSourceDirectory.Text + @"\" + (file.Trim()),this.tbOutputDirectory.Text + @"\"))==0?1:0);
					
				}
			}
			Console.WriteLine("Completed conversion at " + DateTime.Now.Minute.ToString() + ":" + DateTime.Now.Second.ToString() + "." + DateTime.Now.Millisecond.ToString());
			this.statusBar1.Text = "Finished";
			this.statusBar1.Refresh();
			MessageBox.Show(this,nCount.ToString() + " Files Converted and placed in\n " + this.tbOutputDirectory.Text,"Conversion Complete");
			this.progressBar1.Value = 0;
			this.statusBar1.Text = "";
			this.statusBar1.Refresh();
			//myConvertor.ConvertFile(a,b);
			
		}

		private void progressBar1_Click_1(object sender, EventArgs e)
		{
		
		}

		private void menuItem10_Click(object sender, EventArgs e)
		{
		
		}

		private void menuItemExit_Click(object sender, EventArgs e)
		{
			this.button4_Click(null,null);
		}

		private void menuItemChooseLogFiles_Click(object sender, EventArgs e)
		{
			this.button1_Click(null,null);
		}

		private void menuItemChooseOutputDirectory_Click(object sender, EventArgs e)
		{
			this.button2_Click(null,null);
		}

		private void menuItemToolsConvert_Click(object sender, EventArgs e)
		{
			this.button3_Click(null,null);
		}
	}
}
