<?xml version="1.0" encoding="UTF-8" ?>
<xslt:stylesheet version="1.0" xmlns:xslt="http://www.w3.org/1999/XSL/Transform">
<xslt:output method="html" version="4.0" omit-xml-declaration="yes"/>
<xslt:template match="/">	
<table width="100%" cellspacing="0" cellpadding="0" border="0"><tr><td><b>
	<xslt:apply-templates select="channels/channel"/><!-- this takes us to 1st channel node -->
<br/></b></td></tr></table>
</xslt:template>

<xslt:template match="channel">
	<xslt:variable name="channelSpacer" select="'&#160;&#160;'"/>
	<span name="topLevel" id="topLevel">
		<!-- deal with formatting -->	
		<xslt:if test="@level>0">
		 <xslt:for-each select="ancestor::*">
		   <xslt:value-of select="$channelSpacer"/>
		 </xslt:for-each> 
		</xslt:if>
		<!-- now write treeview entry for channel -->
	
		<!-- we need first span to be open by default -->
		<xslt:choose>
		<xslt:when test="@level=0">
		  <img name="img{@guid}" src="/mySite/images/collapse.gif" onclick="Expand('{@guid}')"/>
		 <xslt:choose>
			<xslt:when test="count(child::departmentPost)>0">
				<xslt:variable name="escapedPHContentDepartment">
					<xslt:call-template name="escape-apos">
						<xslt:with-param name="string"><xslt:value-of select="departmentPost/selectedPlaceholder"/></xslt:with-param>	
					</xslt:call-template>
				</xslt:variable>
				<a onclick="javascript:insertGuid('{/departmentPost/@guid}', '{$escape-apos}');" onmouseover="this.style.cursor='hand'; this.style.textDecoration='underline';"
					onmouseout="this.style.cursor='auto'; this.style.textDecoration='none'">
				<xslt:value-of select="@name"/>
				</a>
			</xslt:when>
			<xslt:when test="count(child::departmentPost)=0">
				<xslt:value-of select="@name"/>
			</xslt:when>
		</xslt:choose>
	 <br/>
		  <span name="{@guid}" id="{@guid}" style="display:inline">
		    <xslt:apply-templates select="post"/><!-- move to post nodes -->
		    <xslt:apply-templates select="channel"/><!-- more to next level of channels -->
		  </span>  
		</xslt:when>
		<xslt:otherwise>
		  <img name="img{@guid}" src="/mySite/images/expand.gif" onclick="Expand('{@guid}')"/>
		 
		 	 <xslt:choose>
			<xslt:when test="count(child::departmentPost)>0">
				<xslt:variable name="escapedPHContentDepartment">
					<xslt:call-template name="escape-apos">
						<xslt:with-param name="string"><xslt:value-of select="departmentPost/selectedPlaceholder"/></xslt:with-param>	
					</xslt:call-template>
				</xslt:variable>
				<a onclick="javascript:insertGuid('{departmentPost/@guid}', '{$escapedPHContentDepartment}');" onmouseover="this.style.cursor='hand'; this.style.textDecoration='underline';"
					onmouseout="this.style.cursor='auto'; this.style.textDecoration='none'">
				<xslt:value-of select="@name"/>
				</a>
			</xslt:when>
			<xslt:when test="count(child::departmentPost)=0">
				<xslt:value-of select="@name"/>
			</xslt:when>
		</xslt:choose>
		<br/>
		  <span name="{@guid}" id="{@guid}" style="display:none">
		    <xslt:apply-templates select="post"/><!-- move to post nodes -->
		    <xslt:apply-templates select="channel"/><!-- more to next level of channels -->	
		  </span>  	  
		</xslt:otherwise>
		</xslt:choose>
	</span>
</xslt:template>

<xslt:template match="post">
	<xslt:variable name="postingSpacer" select="'&#160;&#160;&#160;'"/>
		<xslt:for-each select="ancestor::*">
		   <xslt:value-of select="$postingSpacer"/>
		</xslt:for-each> 
	<xslt:text>- </xslt:text>
	<xslt:variable name="escapedPHContent">
		<xslt:call-template name="escape-apos">
			<xslt:with-param name="string"><xslt:value-of select="selectedPlaceholder"/></xslt:with-param>	
		</xslt:call-template>
	</xslt:variable>	
	<a onclick="javascript:insertGuid('{@guid}', '{$escapedPHContent}');" onmouseover="this.style.cursor='hand'; this.style.textDecoration='underline';"
	onmouseout="this.style.cursor='auto'; this.style.textDecoration='none';">
	<xslt:value-of select="selectedPlaceholder"/></a><br/>
</xslt:template>

<xslt:template name="escape-apos">
   <xslt:param name="string" />
   <!-- create an $apos variable to make it easier to refer to -->
   <xslt:variable name="apos" select='"&apos;"' />
   <xslt:choose>
      <!-- if the string contains an apostrophe... -->
      <xslt:when test='contains($string, $apos)'>
         <!-- ... give the value before the apostrophe... -->
         <xslt:value-of select="substring-before($string, $apos)" />
         <!-- ... the escaped apostrophe ... -->
         <xslt:text>\&apos;</xslt:text>
         <!-- ... and the result of applying the template to the
                  string after the apostrophe -->
         <xslt:call-template name="escape-apos">
            <xslt:with-param name="string"
                            select="substring-after($string, $apos)" />
         </xslt:call-template>
      </xslt:when>
      <!-- otherwise... -->
      <xslt:otherwise>
         <!-- ... just give the value of the string -->
         <xslt:value-of select="$string" />
      </xslt:otherwise>
   </xslt:choose>
</xslt:template>

</xslt:stylesheet>

  