<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" version="4.0"/>

<xsl:template match="contact">
<table class="{presentationSettings/@presTableClass}" width="100%" border="0" cellpadding="0" cellspacing="0">
<tr><td class="{presentationSettings/@presTitleClass}" colspan="2">
<xsl:value-of select="presentationSettings/@controlTitle"/>
<img src="{presentationSettings/@lineImgPath}" width="100%" height="1" border="0" alt="*"/>
</td>
</tr>
<tr><td colspan="2"></td>
</tr>
<xsl:apply-templates/>
<tr><td colspan="2"></td>
</tr>
</table>
</xsl:template>

<xsl:template match="post">
<xsl:for-each select="placeholder">
<xsl:if test="@name[.='Name']">
	<xsl:apply-templates select="//presentationSettings/@Name"/>
</xsl:if>
</xsl:for-each>

<xsl:for-each select="placeholder">
<xsl:if test="@name[.='Phone']">
	<xsl:apply-templates select="//presentationSettings/@Phone"/>
</xsl:if>
</xsl:for-each>

<xsl:for-each select="placeholder">
<xsl:if test="@name[.='Mail']">
<xsl:apply-templates select="//presentationSettings/@Mail"/>
</xsl:if>
</xsl:for-each>

<xsl:for-each select="placeholder">
<xsl:if test="@name[.='Address']">
	<xsl:apply-templates select="//presentationSettings/@Address"/>
</xsl:if>
</xsl:for-each>

<xsl:for-each select="placeholder">
<xsl:if test="@name[.='MoreInfoURL']">
	<xsl:apply-templates select="//presentationSettings/@MoreInfoURL"/>
</xsl:if>
</xsl:for-each>

</xsl:template>


<xsl:template match="@Name">
<xsl:variable name="blnShow" select="."/>
<xsl:if test="$blnShow='True'">
	<tr><td align="center" class="{//presentationSettings/@presDetailsClass}">
		&#160;
	</td>
	<td class="{//presentationSettings/@presDetailsClass}">
	<xsl:value-of select="//placeholder[@name='Name']/value" />
	</td></tr>
</xsl:if>
</xsl:template>

<xsl:template match="@Phone">
<xsl:variable name="blnShow" select="."/>
<xsl:if test="$blnShow='True'">
	<tr><td align="center" class="{//presentationSettings/@presDetailsClass}">
	<img src="{//presentationSettings/@phoneImgPath}" alt="*"/>
	</td>
	<td class="{//presentationSettings/@presDetailsClass}">
	<xsl:value-of select="//placeholder[@name='Phone']/value" />
	</td></tr>
</xsl:if>
</xsl:template>

<xsl:template match="@Mail">
<xsl:variable name="blnShow" select="."/>
<xsl:if test="$blnShow='True'">
	<tr><td align="center" class="{//presentationSettings/@presDetailsClass}">
	<img src="{//presentationSettings/@mailImgPath}" alt="*"/></td>
	<td class="{//presentationSettings/@presDetailsClass}"><a href="mailto:{//placeholder[@name='Mail']/value}">email</a></td></tr>
</xsl:if>
</xsl:template>

<xsl:template match="@Address">
<xsl:variable name="blnShow" select="."/>
<xsl:if test="$blnShow='True'">
	<tr><td align="center" class="{//presentationSettings/@presDetailsClass}">
		&#160;
	</td>
	<td class="{//presentationSettings/@presDetailsClass}">
	<xsl:value-of select="//placeholder[@name='Address']/value"/>
	</td></tr>
</xsl:if>
</xsl:template>

<xsl:template match="@MoreInfoURL">
<xsl:variable name="blnShow" select="."/>
<xsl:if test="$blnShow='True'">
	<tr><td align="center" class="{//presentationSettings/@presDetailsClass}">
		&#160;
	</td>
	<td class="{//presentationSettings/@presDetailsClass}">
	<xsl:value-of select="//presentationSettings/@linkText"/>
	<a href="{//placeholder[@name='MoreInfoURL']/value}">
	<xsl:value-of select="//presentationSettings/@linkSymbol"/>
	</a>
	</td></tr>
</xsl:if>
</xsl:template>

</xsl:stylesheet>







  