using System.Configuration;
using System.Xml;

namespace MSIBPlusPack.CommerceServer.Runtime.Configuration
{
	/// <summary>
	/// Responsible for reading in the configuration of the external configuration and returning
	/// an  ExternalAuthenticationConfiguration class
	/// </summary>
	public class ExternalAuthenticationModuleConfigurationHandler  : IConfigurationSectionHandler
	{
		/// <summary>
		/// This method supports the configuration framework and is called when the configuration is loaded by a client using GetConfig
		/// </summary>
		/// <param name="parent">The configuration settings in a corresponding parent configuration section.</param>
		/// <param name="configContext">An HttpConfigurationContext when Create is called from the ASP.NET configuration system. Otherwise, this parameter is reserved and is a null reference (Nothing in Visual Basic).</param>
		/// <param name="section">The XmlNode that contains the configuration information from the configuration file. Provides direct access to the XML contents of the configuration section.</param>
		/// <returns>An ExternalAuthenticationConfiguration object</returns>
		public object Create(object parent, object configContext, XmlNode section)
		{
			ExternalAuthenticationConfiguration eac = new ExternalAuthenticationConfiguration(section.Attributes["pluginTypeName"].Value, section.Attributes["pluginAssemblyName"].Value);

			if(section.Attributes["ticketStore"] != null && section.Attributes["ticketStoreTicketName"] != null)
			{
				string strTicketStore = section.Attributes["ticketStore"].Value;
				
				string strTicketStoreTicketName = section.Attributes["ticketStoreTicketName"].Value;
				string strTicketStoreTicketExpiryName = null;
				if(section.Attributes["ticketStoreTicketExpiryName"] != null)
					strTicketStoreTicketExpiryName = section.Attributes["ticketStoreTicketExpiryName"].Value;

				TicketStoreType tst = TicketStoreType.None;

				switch(strTicketStore)
				{
					case "CommerceProfile":
						tst = TicketStoreType.CommerceProfile;
						break;
					case "Session":
						tst = TicketStoreType.Session;
						break;
					default:
						break;
				}
				if(tst.Equals(TicketStoreType.None))				
					eac = new ExternalAuthenticationConfiguration(section.Attributes["pluginTypeName"].Value, section.Attributes["pluginAssemblyName"].Value);					
				else
					eac = new ExternalAuthenticationConfiguration(section.Attributes["pluginTypeName"].Value, section.Attributes["pluginAssemblyName"].Value, tst, strTicketStoreTicketName, strTicketStoreTicketExpiryName);

			} 
			else
			{
				eac = new ExternalAuthenticationConfiguration(section.Attributes["pluginTypeName"].Value, section.Attributes["pluginAssemblyName"].Value);
			}

			foreach(XmlNode nodNV in section.SelectNodes("PluginConfigurationItem"))
			{
				XmlAttributeCollection attributes = nodNV.Attributes;
				eac.AddPlugInConfigItem(attributes["name"].Value, attributes["value"].Value);
			}
			return eac;
		}
	}
}
