using System;
using System.Collections.Specialized;

namespace MSIBPlusPack.CommerceServer.Runtime
{
	/// <summary>
	/// Use this class to test that the External Authentication is working correctly. 
	/// </summary>
	public class TestPlugIn : IExternalAuthenticationPlugIn
	{
		/// <summary>
		/// Constructor
		/// </summary>
		public TestPlugIn()
		{
		}

		/// <summary>
		/// Trivial Authentication - this always returns true
		/// </summary>
		/// <param name="username">ignored</param>
		/// <param name="password">ignored</param>
		/// <param name="ticket">ignored</param>
		/// <param name="ticketExpiryDate">Set to 30 minutes from now</param>
		/// <returns>Always returns true</returns>
		public bool AuthenticateUser(string username, string password, ref string ticket, ref DateTime ticketExpiryDate)
		{
			ticketExpiryDate = DateTime.Now.AddMinutes(30);
			return true;
		}

		/// <summary>
		/// Required for IExternalAuthenticationPlugin
		/// </summary>
		/// <param name="plugInConfig">ignored</param>
		public void Init(NameValueCollection plugInConfig)
		{			
		}

		/// <summary>
		/// Required for IExternalAuthenticationPlugin
		/// </summary>
		/// <param name="disposing">ignored</param>
		public void Dispose(bool disposing)
		{
		}
	
		/// <summary>
		///  Just renews the ticket by another 30 mins
		/// </summary>
		/// <param name="ticket">the ticket</param>
		/// <param name="ticketExpirationDate"></param>
		/// <returns></returns>
		public bool RenewTicket(ref string ticket, ref DateTime ticketExpirationDate)
		{
			ticketExpirationDate = DateTime.Now.AddMinutes(30);
			return true;
		}
	
		/// <summary>
		/// 
		/// </summary>
		/// <param name="ticket"></param>
		/// <returns></returns>
		public bool ValidateTicket(ref string ticket)
		{
			// TODO:  Add TestPlugIn.ValidateTicket implementation
			return true;
		}
	}
}
