using System;
using System.IO;
using System.Xml;

using MSIBPlusPack.CommerceServer.Runtime;
using MSIBPlusPack.CommerceServer.Runtime.Configuration;

using System.Reflection;

using System.Collections;

namespace ExternalAuthenticationSample
{
	/// <summary>
	/// Summary description for ExternalAuthenticationSample.
	/// </summary>
	public class ExternalAuthenticationSample :IExternalAuthenticationPlugIn
	{
		string strUserDB;
		Hashtable htTickets;


		public ExternalAuthenticationSample()
		{
		}
		

		private bool CheckPassword(string Username, string Password)
		{
			
			XmlDocument doc = new XmlDocument();
			if(strUserDB != null)
			{
				using(FileStream fsUserDB = new FileStream(strUserDB, FileMode.Open, FileAccess.Read, FileShare.ReadWrite))
				{
					doc.Load(fsUserDB);
				}
			} 
			else
			{
				Assembly a = this.GetType().Assembly;
				doc.Load(a.GetManifestResourceStream(this.GetType(), "UserDB.xml"));
			}

			XmlNode nodUser = doc.SelectSingleNode(String.Format("/users/user[@name='{0}']", Username));
			if(nodUser != null && nodUser.Attributes["password"] != null)
			{
				if(nodUser.Attributes["password"].Value.Equals(Password))
					return true;
			}

			return false;
		}
		
		#region IExternalAuthenticationPlugin Members

		public bool AuthenticateUser(string Username, string Password, ref string Ticket, ref DateTime ticketExpiryDate)
		{
			if(CheckPassword(Username, Password))
			{
				InternalTicket iTicket = new InternalTicket(Username);
				
				Ticket = iTicket.Ticket;
				ticketExpiryDate = iTicket.TicketExpiry;
				htTickets.Add(iTicket.Ticket, iTicket);
				return true;
			}
			
			return false;
		}

		public void Init(System.Collections.Specialized.NameValueCollection plugInConfig)
		{			
			if(plugInConfig["UserDB"] != null)
			{
				strUserDB = plugInConfig["UserDB"];
			}
			

			htTickets = new Hashtable(10);
			

		}

		public void Dispose(bool disposing)
		{
		}

		public bool RenewTicket(ref string ticket, ref DateTime ticketExpirationDate)
		{			
			if(htTickets[ticket] != null)
			{
				InternalTicket iTicket = htTickets[ticket] as InternalTicket;				
				ticketExpirationDate = DateTime.Now.AddMinutes(30);
				htTickets[ticket] = iTicket;
				return true;
			} else
				return false;
		}
	
		public bool ValidateTicket(ref string ticket)
		{
			if(htTickets[ticket] != null)
			{
				InternalTicket iTicket = htTickets[ticket] as InternalTicket;
				if(iTicket.TicketExpiry < DateTime.Now)
					return true;				
			}
			
			return false;
		}
		#endregion
	
		internal class InternalTicket
		{
			private string strTicket;
			private DateTime dtTicketExpiry;
			private string strUser;

			internal InternalTicket(string user)
			{				
				strTicket = Guid.NewGuid().ToString();
				dtTicketExpiry = DateTime.Now.AddMinutes(30);
				strUser = user;
			}

			public string Ticket
			{
				get {return strTicket;}
			}

			public DateTime TicketExpiry
			{
				get { return dtTicketExpiry;}
			}

			public string User
			{
				get {return strUser;}
			}
		}
	}


}
