using System;
using System.Collections;
using System.IO;
using System.Reflection;
using System.Xml;

using MSIBPlusPack.CommerceServer.Runtime;
using MSIBPlusPack.CommerceServer.Runtime.Configuration;



namespace ExternalAuthenticationSample
{
	public class SamplePlugIn : IExternalAuthenticationPlugIn
	{
		string strUserDB;
		Hashtable htTickets;
		
		public SamplePlugIn()
		{
		}

		private bool CheckPassword(string username, string password)
		{			
			XmlDocument doc = new XmlDocument();
			if(strUserDB != null)
			{
				using(FileStream fsUserDB = new FileStream(strUserDB, FileMode.Open, FileAccess.Read, FileShare.ReadWrite))
				{
					doc.Load(fsUserDB);
				}
			} 

			XmlNode nodUser = doc.SelectSingleNode(String.Format("/users/user[@name='{0}']", username));
			if(nodUser != null && nodUser.Attributes["password"] != null)
			{
				if(nodUser.Attributes["password"].Value.Equals(password))
					return true;
			}

			return false;
		}

		#region IExternalAuthenticationPlugIn Members

		public bool AuthenticateUser(string username, string password, ref string ticket, ref DateTime ticketExpirationDate)
		{
			bool bAuthenticated = false;
			if(CheckPassword(username, password))
			{
				InternalTicket iTicket = new InternalTicket(username);
				
				ticket = iTicket.Ticket;
				ticketExpirationDate = iTicket.TicketExpiry;
				htTickets.Add(iTicket.Ticket, iTicket);
				bAuthenticated = true;
			}
			
			return bAuthenticated;
		}

		public void Init(System.Collections.Specialized.NameValueCollection plugInConfig)
		{
			if(plugInConfig["UserDB"] != null)
			{
				strUserDB = plugInConfig["UserDB"];
			}
			
			htTickets = new Hashtable(10);			
		}

		public bool RenewTicket(ref string ticket, ref DateTime ticketExpirationDate)
		{	
			bool bTicketRenewed = false;

			if(htTickets[ticket] != null)
			{
				InternalTicket iTicket = htTickets[ticket] as InternalTicket;				
				ticketExpirationDate = DateTime.Now.AddMinutes(30);
				htTickets[ticket] = iTicket;
				bTicketRenewed = true;
			} 
			return bTicketRenewed;
		}
	
		public bool ValidateTicket(ref string ticket)
		{
			bool bTicketValidated = false;

			if(htTickets[ticket] != null)
			{
				InternalTicket iTicket = htTickets[ticket] as InternalTicket;
				if(iTicket.TicketExpiry < DateTime.Now)
					bTicketValidated = true;				
			}
			
			return bTicketValidated;
		}

		public void Dispose(bool disposing)
		{
		}

		#endregion
		internal class InternalTicket
		{
			private string strTicket;
			private DateTime dtTicketExpiry;
			private string strUser;

			internal InternalTicket(string user)
			{				
				strTicket = Guid.NewGuid().ToString();
				dtTicketExpiry = DateTime.Now.AddMinutes(30);
				strUser = user;
			}

			public string Ticket
			{
				get {return strTicket;}
			}

			public DateTime TicketExpiry
			{
				get { return dtTicketExpiry;}
			}

			public string User
			{
				get {return strUser;}
			}
		}
	}
}
