using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.Design;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Text;

namespace MSIBPlusPack.ContentManagement.Publishing.Placeholders
{
	/// <summary>
	/// Designer for FAQ control
	/// </summary>
	internal class FaqDesigner : ControlDesigner
	{
		/// <summary>
		/// Returns something to the IDE in the event of nothing coming from GetDesignTimeHTML
		/// </summary>
		/// <returns>string</returns>
		protected override string GetEmptyDesignTimeHtml()
		{

			return CreatePlaceHolderDesignTimeHtml("postListPH"); 

		}

		/// <summary>
		/// Brings back a representation of the control in design time
		/// </summary>
		/// <returns>string</returns>
		public override string GetDesignTimeHtml()
		{
			
			FaqControl postListControl = (FaqControl) Component;

			StringBuilder szOutPut = new StringBuilder();

			szOutPut.Append("<table border='0' cellpadding='0' cellspacing='2' bgcolor=\"#AAAAFF\"><tr><td><table border='0' cellpadding='2' cellspacing='1'><tr><td colspan='2'>");

			szOutPut.Append("<b><small>");
			
			szOutPut.Append(postListControl.ID);

			szOutPut.Append("</small></b>");

			szOutPut.Append("</td></tr><tr><td>");

			#region channels
			szOutPut.Append("<small>Channel Filter</small></td><td bgcolor='#FFFFFF'><small>");

			if(postListControl.ChannelFilter.Length > 0)
			{
				szOutPut.Append("<b>Active</b>");
			}
			else
			{
				szOutPut.Append("<i>Inactive</i>");
			}
			#endregion

			szOutPut.Append("</small></td></tr><tr><td>");

		
			#region Template
			szOutPut.Append("<small>Template Filter</small></td><td bgcolor='#FFFFFF'><small>");

			if(postListControl.TemplateFilter.Length > 0)
			{
				szOutPut.Append("<b>Active</b>");
			}
			else
			{
				szOutPut.Append("<i>Inactive</i>");
			}
			#endregion

			#region placeholder
			szOutPut.Append("</small></td></tr><tr><td>");

			szOutPut.Append("<small>Placeholder Filter</small></td><td bgcolor='#FFFFFF'><small>");

			if(postListControl.PlaceholderFilter.Length > 0)
			{
				szOutPut.Append("<b>Active</b>");
			}
			else
			{
				szOutPut.Append("<i>Inactive</i>");
			}
			#endregion

			#region Max Return
			szOutPut.Append("</small></td></tr><tr><td>");

			szOutPut.Append("<small>Max Items</small></td><td bgcolor='#FFFFFF'><small>");

			if(postListControl.MaxReturnCount > 0)
			{
				szOutPut.Append("<b>");
				szOutPut.Append(postListControl.MaxReturnCount.ToString());
				szOutPut.Append("</b>");
				szOutPut.Append( ((postListControl.MaxReturnPerChannel) ? " per channel" : " max"));
			}
			else
			{
				szOutPut.Append("<i>Unlimited</i>");
			}
			#endregion

			szOutPut.Append("</small></td></tr><tr><td colspan='2' bgcolor='#FFFFFF'><small>");

			szOutPut.Append("<a href=\"http:www.msibpluspack.com\" style=\"text-decoration:none\"><i>MSIB FAQ Control</i></a>");

			szOutPut.Append("</small></td></tr><tr><td>");

			szOutPut.Append("</td></tr></table></td></tr></table>");
			
			return szOutPut.ToString();

		}

		/// <summary>
		///		Initialization routine. Captures the component and casts it to our object. 
		/// </summary>
		public FaqControl _postLister;

		public override void Initialize(IComponent component)
		{
			base.Initialize(component);
			_postLister = (FaqControl) component;
		}


	}
}
