using System;
using System.IO;
using System.Text;
using System.Web;
using System.Xml;
using System.Xml.Xsl;
using System.Xml.XPath;

namespace MSIBPlusPack.Utilities
{
	/// <summary>
	/// Summary description for postHelper.
	/// </summary>
	internal class postHelper
	{
		public postHelper()
		{
			//
			// TODO: Add constructor logic here
			//
		}

		#region XSL Transform of result 
		/// <summary>
		/// Transform the supplied XML string using the requested XSL file.
		/// </summary>
		/// <param name="strXML">the XML data in string format</param>
		/// <param name="strXSLFile">string containing URL [Map path is carried out internally within the function] to the Stylesheet</param>
		/// <returns>string containing the transformed result set</returns>
		///<remarks>In the event of an error the function returns Error element</remarks>
		public static string transformXML(string strXML, string strXSLFile)
		{

			StringBuilder sbReturn = new StringBuilder();

			//Get a mapped path to the style sheet
			strXSLFile = HttpContext.Current.Server.MapPath(strXSLFile);

			StringReader sReader = new StringReader(strXML);

			StringWriter sWriter = new StringWriter(sbReturn);

			XmlTextWriter xmlWriter = new XmlTextWriter(sWriter);

			//Load XML into an XPath
			XPathDocument xpthResults = new XPathDocument(sReader);
			
			XslTransform xslTrans = new XslTransform();

			try
			{
			
				//Load our XSL file
				xslTrans.Load(strXSLFile);

				//And transform
				xslTrans.Transform(xpthResults, null, xmlWriter);

			}
			catch(Exception e)
			{
				
				sbReturn.Append("<Error>");
				sbReturn.Append(e.Message);
				sbReturn.Append(" - ");
				sbReturn.Append(e.InnerException);
				sbReturn.Append("</Error>");

			}

			return sbReturn.ToString();

		}
		/// <summary>
		/// Transform the supplied XML string using the requested XSL file.
		/// </summary>
		/// <param name="strXML">the XML data in string format</param>
		/// <param name="xmlXSL">Stylesheet</param>
		/// <returns>string containing the transformed result set</returns>
		///<remarks>In the event of an error the function returns Error element</remarks>
		public static string transformXML(string strXML, XmlTextReader xmlXSL)
		{

			StringBuilder sbReturn = new StringBuilder();

			StringReader sReader = new StringReader(strXML);

			StringWriter sWriter = new StringWriter(sbReturn);

			XmlTextWriter xmlWriter = new XmlTextWriter(sWriter);

			//Load XML into an XPath
			XPathDocument xpthResults = new XPathDocument(sReader);

			XslTransform xslTrans = new XslTransform();

			try
			{
			
				//Load our XSL file
				xslTrans.Load(xmlXSL);

				//And transform
				xslTrans.Transform(xpthResults, null, xmlWriter);

			}
			catch(Exception e)
			{
				
				
				throw(e);

			}

			return sbReturn.ToString();

		}

		/// <summary>
		/// Transform the supplied XML string using the requested XSL file.
		/// </summary>
		/// <param name="xmlNav">the XML data in XmlDocument format</param>
		/// <param name="xmlXSL">XmlReader containing the Stylesheet</param>
		/// <returns>string containing the transformed result set</returns>
		///<remarks>In the event of an error the function returns Error element</remarks>
		public static string transformXML(XmlDocument xmlNav, XmlReader xmlXSL, XsltArgumentList xslArgs)
		{

			StringBuilder sbReturn = new StringBuilder();

			StringWriter sWriter = new StringWriter(sbReturn);

			//And of course it will be in XML
			XmlTextWriter xmlWriter = new XmlTextWriter(sWriter);
			
			XslTransform xslTrans = new XslTransform();


			try
			{
			
				//Load our XSL file
				xslTrans.Load(xmlXSL);

				//And transform
				xslTrans.Transform(xmlNav, xslArgs, xmlWriter);

			}
			catch(Exception e)
			{
				
				
				throw(e);

			}

			return sbReturn.ToString();

		}



		#endregion

		#region Display As HTML
		/// <summary>
		/// Convert HTML and XML to display in a browser
		/// </summary>
		/// <param name="strDisplay"></param>
		/// <returns></returns>
		public static string displayAsHTML(string strDisplay)
		{

			string strReturn = strDisplay;

			strReturn = strReturn.Replace("><", "&gt;*BE**BR**B*&lt;");

			strReturn = strReturn.Replace("<","*B*&lt;");

			strReturn = strReturn.Replace(">", "&gt;*BE*");

			strReturn = strReturn.Replace("*BR*", "<br>");

			strReturn = strReturn.Replace("*BE*", "</b>");

			strReturn = strReturn.Replace("*B*", "<b>");

			return strReturn;

		}
		#endregion

	}
}
