//Array reference for toolbox attributes
//Add reference to the Mcms API
//Add references for Xml assemblies
using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Design;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.Design;
using System.Web.UI.WebControls;
using System.Xml;
using ioko.ComponentModel.LicenseProvider;
using Microsoft.ContentManagement.Publishing;
using Microsoft.ContentManagement.Publishing.Extensions.Placeholders;
using Microsoft.ContentManagement.WebControls;
using Microsoft.ContentManagement.WebControls.Design;

namespace MSIBPlusPack.ContentManagement.Publishing.Placeholders
{
	/// <summary>
	/// <para>Provides an placeholder that renders 'Dublin Core' configurable MetaData at runtime</para>
	/// <para>The Dublin Core Metadata Initiative is an open forum engaged in the development of interoperable online metadata standards that support a broad range of purposes and business models. DCMI's activities include consensus-driven working groups, global workshops, conferences, standards liaison, and educational efforts to promote widespread acceptance of metadata standards and practices.</para>
	/// <para><i>For more information go to http://dublincore.org</i></para>
	/// </summary>
	/// <remarks>
	/// <para>This placeholder has no visible element when used in presentation mode, when it injects the metadata into the head of the document.</para>
	/// <para>Due to the way that the placeholder performs this injection, it is important that only one closing HTML HEAD tag (&lt;/HEAD&gt;) exists in the outgoing HTML stream, otherwise the behaviour of the placeholder is unpredictable and will result in multiple copies of the metadata being written into the output.</para>
	/// <para>The metadata stored is extensible and is controlled by an XML configuration file, the location of which is specified when the placeholder is used within a template. The metadata stored can be </para>
	/// <para><list type="bullet"><listheader>Controls</listheader><item><description>System.Web.UI.WebControls.Textbox</description></item><item><description>System.Web.UI.WebControls.ListBox</description></item></list></para>
	/// <para>However, due to  the method by which the controls are created at run-time it is possible to specify any control from the System.Web assembly, but the behaviour of the placeholder is unpredictable.</para>
	/// <para>This placeholder should be placed in the head of a template file.</para>
	/// </remarks>
	/// <example>
	/// <para>The example below shows the use of the placeholder within a CMS template. It assumes that the correct assembly has been registered within the template.</para>
	/// <code>&lt;%@ Register TagPrefix="cc1" Namespace="MSIBPlusPack.ContentManagement.Publishing.Placeholders" Assembly="Metadata" %&gt;</code>
	/// <code>&lt;cc1:MetadataPlaceHolder id="MetadataPlaceHolder1" runat="server" PlaceholderToBind="NewXmlPlaceholderDefinition1" ConfigFile="http://localhost/woodgrovenet/XML/DublinCoreConfig.xml"&gt;
	/// &lt;AlternatingItemStyle BackColor="AntiqueWhite"&gt;&lt;/AlternatingItemStyle&gt;
	/// &lt;MetadataStyle BorderStyle="Solid" BorderColor="Blue" Width="800px"&gt;&lt;/MetadataStyle&gt;
	/// &lt;HeaderStyle Font-Bold="True"&gt;&lt;/HeaderStyle&gt;
	/// &lt;/cc1:MetadataPlaceHolder&gt;</code>
	/// <para>The lines below are a sample of the standard Dublin Core represented using the configuration file.</para>
	/// <code>
	/// &lt;?xml version="1.0" encoding="utf-8" ?&gt; 
	/// &lt;dcc:elements xmlns:dcc="http://www.ioko365.com/Metadataconfig" name="My Test Data"&gt;
	/// &lt;dcc:element name="dc.Title" mandatory="true" displayName="Title"/&gt;
	/// &lt;dcc:element mandatory="true" name="dc.author" displayName="Author" &gt;Enter the authors full name here	&lt;/dcc:element&gt;
	/// &lt;dcc:element mandatory="false" name="dc.description" displayName="Description"/&gt;	
	/// &lt;dcc:element mandatory="false" name="dc.publisher" displayName="Publisher" defaultValue="Northamptonshire County Council"/&gt;
	/// &lt;dcc:element mandatory="false" name="dc.Resource" displayName="Resource" type="System.Web.UI.WebControls.ListBox"&gt;
	/// &lt;dcc:option name="Video" value="Video"/&gt;
	/// &lt;dcc:option name="Text and images" value="TextAndImages"/&gt;
	/// &lt;dcc:option name="Audio" value="Audio"/&gt;
	/// &lt;dcc:option name="Images" value="Images"/&gt;
	/// &lt;/dcc:element&gt;
	/// &lt;dcc:element name="dc.Format" displayName="Format"/&gt;
	/// &lt;dcc:element name="dc.ResourceID" displayName="ResourceID"/&gt;
	/// &lt;dcc:element name="dc.Source" displayName="Source"/&gt;
	/// &lt;dcc:element name="dc.Relation" displayName="Relation"/&gt;	
	/// &lt;dcc:element name="dc.Coverage" displayName="Coverage"/&gt;
	/// &lt;dcc:element name="dc.Rights" displayName="Rights Management"/&gt;
	/// &lt;/dcc:elements&gt;
	/// </code>
	/// <para>When the Page is rendered, the following will appear within the %lt;HEAD&gt; element of the HTML</para>
	/// <code>
	/// &lt;Meta Name="dc.Title" content="Hello"&gt;&lt;Meta Name="dc.author" content="Rob Pearmain"&gt;&lt;Meta Name="dc.description" content="Test"&gt;&lt;Meta Name="dc.publisher" content="Rob Pearmain 2000"&gt;&lt;Meta Name="dc.Resource" content="Audio"&gt;&lt;Meta Name="dc.Format" content="asdsad"&gt;&lt;Meta Name="dc.ResourceID" content="2"&gt;&lt;Meta Name="dc.Source" content="dsads"&gt;&lt;Meta Name="dc.Relation" content="dsadsa"&gt;&lt;Meta Name="dc.Coverage" content="dsad"&gt;&lt;Meta Name="dc.Rights" content="asdsad"&gt;&lt;/HEAD&gt;
	/// </code>
	/// </example>
	[ToolboxData("<{0}:MetadataPlaceHolder runat=server></{0}:MetadataPlaceHolder>"), ParseChildren(true), SupportedPlaceholderDefinitionType(typeof (XmlPlaceholderDefinition))]
	[LicenseProvider(typeof (PlusPackLicenseProvider))]
	public class MetadataPlaceHolder : BasePlaceholderControl, INamingContainer
	{
		#region Constructors ------------------------------------

		#endregion

		#region Private Fields ------------------------------------

		/// <summary>
		///  Reference to the authoringContainer, assigned when passed in by the CreateAuthoringControls method
		/// </summary>
		private BaseModeContainer authoringContainer;

		/// <summary>
		/// The Namespace URIs and Namespace prefixes for the Metadata configuration and Metadata data storage schemas
		/// </summary>
		private const string strMetadataConfigNamespaceURI = "http://www.ioko365.com/Metadataconfig";
		private const string strMetadataConfigNamespacePrefix = "dcc";
		private const string strMetadataNamespaceURI = "http://www.ioko365.com/Metadata";
		private const string strMetadataNamespacePrefix = "dc";

		/// <summary>
		/// The prefix to use when creating the authoring child controls. These will be created within Page.Controls, rather than the authoring container of this control 
		/// so that the Meta Data entry controls always appear at the bottom of the page. 
		/// </summary>
		private const string strChildControlIDPrefix = "";

		private TableItemStyle tisHeader;
		private TableItemStyle tisAlternating;
		private TableItemStyle tisStandard;
		private TableStyle tsDC;

		//private IEnumerable mDataSource;

		private string mTitle;

		//private string mstrRowName;
		//private Control mctrlRowControl;
		//private string mstrRowDescription;
		private string mstrConfigFile;
		private string mstrControlToBind;
		private bool mblnUseXHTML;

		private string mstrMetaData;

		#endregion

		#region Licensing static fields

		private static PlusPackLicense license = null;
		private static DateTime lastDate;

		#endregion

		#region Licensing Test

		/// <summary>
		/// This member handles mandatory component initialization. It has been sealed.
		/// </summary>
		/// <param name="e">EventArgs parameter</param>
		protected sealed override void OnInit(EventArgs e)
		{
			ValidateLicense();

			base.OnInit(e);
		}

		private void ValidateLicense()
		{
			try
			{
				bool updateLicense = false;

				if (license == null)
					updateLicense = true;
				else if (lastDate != DateTime.Today)
					updateLicense = true;

				if (updateLicense)
				{
					license = (PlusPackLicense) LicenseManager.Validate(typeof (MetadataPlaceHolder), this);
					lastDate = DateTime.Today;
				}

				switch (license.Validity)
				{
					case MSIBLicenseValidator.LicenseState.Full:
						return;

					case MSIBLicenseValidator.LicenseState.Trial_Active:
						if (updateLicense)
						{
							TimeSpan span = license.ExpiryDate.Date.Subtract(lastDate);
							int daysRemaining = span.Days + 1;
							if (daysRemaining <= 7)
								throw new Exception(String.Format("Warning: Your trial license of MSIB Plus Pack will run out in {0} days. This component will function normally for the remainder of today.", daysRemaining));
						}
						return;

					case MSIBLicenseValidator.LicenseState.Invalid:
					case MSIBLicenseValidator.LicenseState.None:
						break;

					case MSIBLicenseValidator.LicenseState.Trial_Expired:
						throw new Exception("Your trial MSIB Plus Pack trial license has expired. To continue using this component please purchase the relevant license(s).");
				}
			}
			catch
			{
			}

			throw new Exception("You need a valid MSIB Plus Pack license. Please purchase the relevant license(s).");
		}

		#endregion

		#region Public Properties ------------------------------------

		/// <summary>
		/// <para>This property specifies the XML configuration file containing control configuration details.
		/// It must conform to the 'strMetadataConfigNamespaceURI' schema</para>
		/// <para>The location of this file must be fully qualified. The component will fail if it is relative</para>
		/// <example><para>The following is correct:</para><code>http://localhost/Woodgrovenet/xml/myconfig.xml</code>
		/// <para>The following will fail:</para><code>/xml/myconfig.xml</code></example>
		/// </summary>
		[Editor(typeof (UrlEditor), typeof (UITypeEditor))]
		[Browsable(true), Bindable(true), Category("Data"), Description("ConfigurationFile")]
		public string ConfigFile
		{
			get { return mstrConfigFile; }
			set { mstrConfigFile = value; }
		}

		/// <summary>
		/// <para>Set to true to ensure that the &lt;meta&gt; tags are well-formed xml.</para>
		/// </summary>
		[Browsable(true), Bindable(true), Category("Data")]
		[DefaultValue(false)]
		[Description("Set to true to ensure that the <meta> tags are well-formed xml.")]
		public bool UseXHTML
		{
			get { return mblnUseXHTML; }
			set { mblnUseXHTML = value; }
		}

		/// <summary>
		/// <para>Specifies the name of a System.Web.UI.WebControls.Literal that the metadata should be written out to. This control should be located in the &lt;head&gt; of the document. If the Literal cannot be found or does not exist, the metadata will be written out using a Filter, which has a performance implication on the website</para>
		/// </summary>
		[Browsable(true), Bindable(true), Category("Data")]
		[Description("Specifies the name of a System.Web.UI.WebControls.Literal that the metadata should be written out to. This control should be located in the <head> of the document. If the Literal cannot be found or does not exist, the metadata will be written out using a Filter, which has a performance implication on the website")]
		public string ControlToBind
		{
			get { return mstrControlToBind; }

			set { mstrControlToBind = value; }
		}


		/// <summary>
		/// This is the title of the Metadata Placeholder as displayed to the user in CMS Edit Mode
		/// </summary>
		public string Title
		{
			get { return this.mTitle; }
			set { this.mTitle = value; }
		}

		#region Obsolete Code

/*
		/// <summary>
		/// The XPath expression to use to start indexing when the iokoAplawsListBox control is used. 
		/// </summary>
		[Browsable(true), Bindable(true), Category("Data"), Description("XPath to starting Aplaws nodes. Default if /categoryList/aplaws:L1/.")]
		public string StartAplawsXPath
		{
			get
			{
				string startAplawsXPath = (string)ViewState["StartAplawsXPath"];
				return startAplawsXPath;
			}
			set
			{
				ViewState["StartAplawsXPath"] = value;
			}
		}
		
		/// <summary>
		/// The Aplaws Configuration File to use when an iokoAplawsListBox control is used. 
		/// </summary>
		[Editor(typeof(System.Web.UI.Design.UrlEditor), typeof(System.Drawing.Design.UITypeEditor))]
		[Browsable(true), Bindable(true), Category("Data"), Description("Aplaws Configuration File")]
		public string AplawsConfigFile
		{
			get
			{
				string configFile = (string)ViewState["AplawsConfigFile"];
				return configFile;
			}
			set
			{
				ViewState["AplawsConfigFile"] = value;
			}
		}

		/// <summary>
		/// The XPath expression to use to start indexing when the iokoGCLListBox control is used. 
		/// </summary>
		[Browsable(true), Bindable(true), Category("Data"), Description("XPath to starting gcl:category nodes. Default if /gcl:categories/gcl:category.")]
		public string StartGCLXPath
		{
			get
			{
				string startGCLXPath = (string)ViewState["StartGCLXPath"];
				return startGCLXPath;
			}
			set
			{
				ViewState["StartGCLXPath"] = value;
			}
		}
		
		/// <summary>
		/// Whether to include synonyms when entering keywords from GCL that have valid synonyms when the iokoGCLListBoxis used
		/// </summary>
		[Browsable(true), Bindable(true), Category("Data"), Description("Include synonyms for GCL input types")]
		public bool IncludeGCLSynonyms
		{
			get
			{
				bool includeGCLSynonyms = (bool)ViewState["IncludeGCLSynonyms"];
				return includeGCLSynonyms;
			}
			set
			{
				ViewState["IncludeGCLSynonyms"] = value;
			}
		}
		
		/// <summary>
		/// The GCL Configuration File to use when an iokoGCLListBox control is used. 
		/// </summary>
		[Editor(typeof(System.Web.UI.Design.UrlEditor), typeof(System.Drawing.Design.UITypeEditor))]
		[Browsable(true), Bindable(true), Category("Data"), Description("Government Category List Configuration File")]
		public string GCLConfigFile
		{
			get
			{
				string configFile = (string)ViewState["GCLConfigFile"];
				return configFile;
			}
			set
			{
				ViewState["GCLConfigFile"] = value;
			}
		}
*/

		/*public string RowName
		{
			get
			{
				return this.mstrRowName;
			}
			set
			{
				this.mstrRowName = value;
			}
		}

		public string RowDescription
		{
			get
			{
				return this.mstrRowDescription;
			}
			set
			{
				this.mstrRowDescription = value;
			}
		}

		public Control RowControl
		{
			get
			{
				return this.mctrlRowControl;
			}
			set
			{
				this.mctrlRowControl = value;
			}
		}*/

		#endregion

		/// <summary>
		/// A <b>TableStyle</b> object that contains the default style properties of the Placeholder control in edit mode.
		/// </summary>
		[Category("Style"), Description("The style to be applied to alternate items."), DesignerSerializationVisibility(DesignerSerializationVisibility.Content), NotifyParentProperty(true), PersistenceMode(PersistenceMode.InnerProperty)]
		public virtual TableStyle MetadataStyle
		{
			get
			{
				if (this.tsDC == null)
				{
					tsDC = new TableStyle();
					tsDC.BorderStyle = BorderStyle.Solid;
					tsDC.Width = 800;
					tsDC.BorderColor = Color.Blue;

					if (IsTrackingViewState)
						((IStateManager) tsDC).TrackViewState();
				}
				return tsDC;
			}
		}

		/// <summary>
		/// A <b>TableItemStyle</b> object that contains the style properties of each alternating row of the Placeholder control in edit mode.
		/// </summary>
		[Category("Style"), Description("The style to be applied to alternate items."), DesignerSerializationVisibility(DesignerSerializationVisibility.Content), NotifyParentProperty(true), PersistenceMode(PersistenceMode.InnerProperty)]
		public virtual TableItemStyle AlternatingItemStyle
		{
			get
			{
				if (this.tisAlternating == null)
				{
					tisAlternating = new TableItemStyle();
					tisAlternating.BackColor = Color.AntiqueWhite;
					if (IsTrackingViewState)
						((IStateManager) tisAlternating).TrackViewState();
				}
				return tisAlternating;
			}
		}

		/// <summary>
		/// A <b>TableItemStyle</b> object that contains the style properties of each item row of the Placeholder control in edit mode.
		/// </summary>
		[Category("Style"), Description("The style to be applied to alternate items."), DesignerSerializationVisibility(DesignerSerializationVisibility.Content), NotifyParentProperty(true), PersistenceMode(PersistenceMode.InnerProperty)]
		public virtual TableItemStyle ItemStyle
		{
			get
			{
				if (this.tisStandard == null)
				{
					tisStandard = new TableItemStyle();
					if (IsTrackingViewState)
						((IStateManager) tisStandard).TrackViewState();
				}
				return tisStandard;
			}
		}

		/// <summary>
		/// A <b>TableItemStyle</b> object that contains the style properties of Header section of the Placeholder control in edit mode.
		/// </summary>
		[Category("Style"), Description("The style to be applied to alternate items."), DesignerSerializationVisibility(DesignerSerializationVisibility.Content), NotifyParentProperty(true), PersistenceMode(PersistenceMode.InnerProperty)]
		public virtual TableItemStyle HeaderStyle
		{
			get
			{
				if (this.tisHeader == null)
				{
					tisHeader = new TableItemStyle();
					tisHeader.Font.Bold = true;
					if (IsTrackingViewState)
						((IStateManager) tisHeader).TrackViewState();
				}
				return tisHeader;
			}
		}

		#region obsolete

		/*[TemplateContainer(typeof(MetadataPlaceHolderHeaderContainer))]
		public ITemplate HeaderTemplate
		{
			get
			{
				return this.mHeaderTemplate;
			}
			set
			{
				this.mHeaderTemplate = value;
//				if(value != null)
//					PopulateAuthoringTemplateControls();
			}
		}

		[TemplateContainer(typeof(MetadataPlaceHolderRowContainer))]
		public ITemplate RowTemplate
		{
			get
			{ 
				return this.mRowTemplate;
			}
			set
			{
				this.mRowTemplate = value;
			}
		}

		[TemplateContainer(typeof(MetadataPlaceHolderFooterContainer))]
		public ITemplate FooterTemplate
		{
			get
			{ 
				return this.mFooterTemplate;
			}
			set
			{
				this.mFooterTemplate = value;
			}
		}*/

		#endregion obsolete

		#endregion 

		#region Public Methods

		//	/// <summary>
		//	/// This method is deprecated. 
		//	/// </summary>
		//	/// <param name="sender"></param>
		//	/// <param name="e"></param>
		//	/// <returns></returns>
		//		public static bool ValidateMetadata(Object sender, ChangingEventArgs e)
		//		{
		//			Microsoft.ContentManagement.Publishing.CmsHttpContext cmsHttpContext = (CmsHttpContext)e.Context;
		//			bool bCancelSubmit = true;
		//			string strErrorMessages = "";
		//			foreach(Placeholder phPosting in cmsHttpContext.Posting.Placeholders)
		//			{
		//				if(phPosting.GetType().Equals(typeof(Microsoft.ContentManagement.Publishing.Extensions.Placeholders.XmlPlaceholder)))
		//				{
		//					XmlPlaceholder xphPosting = (XmlPlaceholder)phPosting;
		//
		//
		//					XmlDocument xmlMetadata = new XmlDocument();
		//					if(xphPosting.XmlAsString.IndexOf(strMetadataNamespaceURI) > 0) {
		//						xmlMetadata.LoadXml(xphPosting.XmlAsString);
		//						XmlNamespaceManager xnmMetadata = new XmlNamespaceManager(xmlMetadata.NameTable);
		//						xnmMetadata.AddNamespace("dc", strMetadataNamespaceURI);
		//						
		//						XmlNodeList xnlElements = xmlMetadata.SelectNodes("/dc:elements/dc:element", xnmMetadata);
		//						foreach(XmlElement xeElement in xnlElements)
		//						{
		//							
		//							if(xeElement.SelectSingleNode("@nillable").Value.Equals("false") && xeElement.InnerText.Equals(""))
		//							{
		//								strErrorMessages += "<br>Required Metadata field " + xeElement.SelectSingleNode("@name") + " has not been completed.";
		//								bCancelSubmit = false;
		//								
		//								
		//							}
		//						}
		//					}
		//
		//				}
		//				
		//				
		//			}
		//
		//			if(bCancelSubmit)
		//			{
		//				strErrorMessages = "Required Metadata metadata fields have been omitted. Please complete before submitting this page for approval. <br>" + strErrorMessages;
		//				//throw new PublishingEventCancellationException(strErrorMessages);
		//				
		//			}
		//			return bCancelSubmit;
		//			
		//			
		//		}

		#endregion Public Methods

		#region Protected Methods ------------------------------------

		/// <summary>
		///		Add child controls for authoring
		/// </summary>
		/// <remarks>Reads in the configuration file and create a table containing the labels, inputs and descriptions for each required control. </remarks>
		/// <param name="authorContainer">The contrainer control when in authoring mode</param>
		protected override void CreateAuthoringChildControls(BaseModeContainer authorContainer)
		{
			Table tblTemplate = new Table();
			EnsureChildControls();
			try
			{
				XmlDocument xmlConfig = GetConfigXml();
				XmlNamespaceManager xnmConfig = new XmlNamespaceManager(xmlConfig.NameTable);
				xnmConfig.AddNamespace(strMetadataConfigNamespacePrefix, strMetadataConfigNamespaceURI);
				Table tblMetadata = new Table();
				TableRow trHeader = new TableRow();
				TableCell tcHeader = new TableCell();
				if (tisHeader != null)
					trHeader.MergeStyle(tisHeader);
				tcHeader.ColumnSpan = 3;
				XmlNode xnTitle = xmlConfig.SelectSingleNode("/" + strMetadataConfigNamespacePrefix + ":elements/@title", xnmConfig);
				if (null == xnTitle)
					tcHeader.Text = "Dublin Core Metadata";
				else
					tcHeader.Text = xnTitle.Value;
				trHeader.Cells.Add(tcHeader);
				tblMetadata.Rows.Add(trHeader);
				XmlNodeList xnlElements = xmlConfig.SelectNodes("/" + strMetadataConfigNamespacePrefix + ":elements/" + strMetadataConfigNamespacePrefix + ":element", xnmConfig);
				this.authoringContainer = authorContainer;
				Control ctrlForm = new Control();
				//bool bGotForm = false;
				bool bIsAlternate = false;

				int iIndex = 0;
				foreach (XmlNode nodElement in xnlElements)
				{
					TableRow trElement = new TableRow();
					TableCell tcElementName = new TableCell();
					TableCell tcElementEdit = new TableCell();
					TableCell tcElementHelp = new TableCell();
					Control ctrlEdit = null;

					try
					{
						Label lblElement = new Label();
						if (nodElement.Attributes.GetNamedItem("displayName") != null)
							lblElement.Text = nodElement.Attributes.GetNamedItem("displayName").Value;
						else
							lblElement.Text = nodElement.Attributes["name"].Value;
						string strElementID = this.Context.Server.UrlEncode(nodElement.Attributes.GetNamedItem("name").Value);
						string strInputType = "";
						if (nodElement.Attributes.GetNamedItem("type") != null)
							strInputType = nodElement.Attributes.GetNamedItem("type").Value;

						int iSize = 0;
						XmlNode node = nodElement.Attributes.GetNamedItem("size");
						if (null != node) iSize = Int32.Parse(nodElement.Attributes.GetNamedItem("size").Value);

						string strDefaultValue = "";
						if (nodElement.Attributes.GetNamedItem("defaultValue") != null)
							strDefaultValue = nodElement.Attributes.GetNamedItem("defaultValue").Value;
						Label lblHelp = new Label();
						lblHelp.Text = nodElement.InnerText;

						//this.RowName = lblElement.Text;

						/*
						if(strInputType.Equals("com.ioko.WebControls.iokoGCLListBox"))
						{
							com.ioko.WebControls.iokoGCLListBox gclList = new com.ioko.WebControls.iokoGCLListBox();
							//System.Collections.Specialized.NameValueCollection nvAppSettings = (System.Collections.Specialized.NameValueCollection) System.Configuration.ConfigurationSettings.GetConfig("appSettings");
							gclList.ConfigFile =this.GCLConfigFile;
							gclList.ShowSynonyms = this.IncludeGCLSynonyms;
							gclList.StartGCLXPath = this.StartGCLXPath;
							if (0 != iSize) gclList.Rows = iSize;

							gclList.LoadGCL();
							ctrlEdit = gclList;
						} 
						else if(strInputType.Equals("com.ioko.WebControls.iokoAplawsListBox"))
						{
							com.ioko.WebControls.iokoAplawsListBox aplawsList = new com.ioko.WebControls.iokoAplawsListBox();
							//System.Collections.Specialized.NameValueCollection nvAppSettings = (System.Collections.Specialized.NameValueCollection) System.Configuration.ConfigurationSettings.GetConfig("appSettings");
							aplawsList.ConfigFile =this.AplawsConfigFile;
							aplawsList.StartAplawsXPath = this.StartAplawsXPath;
							if (0 != iSize) aplawsList.Rows = iSize;

							aplawsList.LoadAplaws();
							ctrlEdit = aplawsList;
						} 
						else if(strInputType.Equals("System.Web.UI.WebControls.ListBox"))
						*/
						if (strInputType.Equals("System.Web.UI.WebControls.ListBox"))
						{
							ListBox lbElement = new ListBox();
							lbElement.SelectionMode = ListSelectionMode.Single;
							lbElement.Rows = 1;
							if (0 != iSize) lbElement.Rows = iSize;

							XmlNodeList xnlOptions = nodElement.SelectNodes("./" + strMetadataConfigNamespacePrefix + ":option", xnmConfig);
							foreach (XmlNode xnOption in xnlOptions)
							{
								ListItem liOption = new ListItem(xnOption.Attributes.GetNamedItem("name").Value, xnOption.Attributes.GetNamedItem("value").Value);
								if (strDefaultValue.Equals(xnOption.Attributes.GetNamedItem("value").Value))
									liOption.Selected = true;

								lbElement.Items.Add(liOption);
							}
							ctrlEdit = lbElement;
						}
						else
						{
							ctrlEdit = new TextBox();
						}
						/*
						else
						{
							// For general controls, use the reflection library to load based on the type attribute in the gcl config file. 
							// Currently searches the System.Web.UI.WebControls and com.ioko.WebControls.GDSC assemblies
							try 
							{
								ctrlEdit = (Control)System.Reflection.Assembly.GetAssembly(typeof(System.Web.UI.WebControls.TextBox)).CreateInstance(strInputType);
								if(ctrlEdit == null)
								{
									ctrlEdit = (Control)System.Reflection.Assembly.GetAssembly(typeof(com.ioko.WebControls.GDSC.iokoGDSCAddress)).CreateInstance(strInputType);
								}
							} 
							catch(ArgumentException ae)
							{
								ctrlEdit = null;
							} 
						}

						// If the control is now null, something probably went wrong with the reflection method - just plonk a textbox on the page instead...
						if(ctrlEdit == null)
						{
							ctrlEdit = new TextBox();
						}
						*/

						if (ctrlEdit is TextBox && strDefaultValue.Length > 0)
						{
							TextBox txtEdit = (TextBox) ctrlEdit;
							txtEdit.Text = strDefaultValue;
						}

						if (ctrlEdit is TextBox && nodElement.Attributes.GetNamedItem("defaultProperty") != null)
						{
							string strDefaultProperty = nodElement.Attributes.GetNamedItem("defaultProperty").Value;
							if (strDefaultProperty.Equals("DisplayName") && !CmsHttpContext.Current.Posting.State.Equals(PostingState.New))
							{
								TextBox txtEdit = (TextBox) ctrlEdit;
								txtEdit.Text = CmsHttpContext.Current.Posting.DisplayName;

							}
						}
						// Add text if the field is required
						if (nodElement.Attributes.GetNamedItem("mandatory") != null && nodElement.Attributes["mandatory"].Value.Equals("true"))
						{
							lblElement.Text += "(Required)";
						}


						// set the ID of the element
						ctrlEdit.ID = strElementID;

						// if the control implements the IGDSCCmsControl interface, retrieve the typename and append it to the help field
						/*
						if(ctrlEdit is IGDSCCmsControl)
						{
							IGDSCCmsControl IGDSC = ctrlEdit as IGDSCCmsControl;
							lblHelp.Text += "[" + IGDSC.GDSCTypeName + "]";
						}
						*/


						if (this.tisStandard != null)
						{
							if (this.tisAlternating != null && bIsAlternate)
							{
								trElement.MergeStyle(tisAlternating);
							}
							else
							{
								trElement.MergeStyle(tisStandard);
							}
						}

						tcElementName.Controls.Add(lblElement);
						tcElementEdit.Controls.Add(ctrlEdit);
						tcElementHelp.Controls.Add(lblHelp);
						trElement.Cells.Add(tcElementName);
						trElement.Cells.Add(tcElementEdit);
						trElement.Cells.Add(tcElementHelp);
						tblMetadata.Rows.Add(trElement);

						//this.RowDescription = lblHelp.Text;
						//this.RowControl = ctrlEdit;

						iIndex++;
						bIsAlternate = !bIsAlternate;
					}
					catch (NullReferenceException nre)
					{
						this.Page.Trace.Warn("CreateAuthoringChildControls", "Null Reference Exception:" + nre.Message);
					}


				}

				if (this.tsDC != null)
					tblMetadata.MergeStyle(tsDC);
				DataBind();
				authorContainer.Controls.Add(tblMetadata);
			}
			catch (Exception e)
			{
				this.Page.Response.Write(e.Message);
			}
		}


		/// <summary>
		///		We don't have any child controls in presentation mode - this is all handled through the LoadPlaceholderContentForPresentation method
		/// </summary>
		/// <param name="presentationContainer">This is unused for this control</param>
		protected override void CreatePresentationChildControls(BaseModeContainer presentationContainer)
		{
		}


		/// <summary>
		///		Load the Placeholder contents for authoring.
		/// </summary>
		/// <param name="e">Any arguments that have been raised on the page.</param>
		///<remarks>Loads in the XML from the content repository and loads its value into the relevant control that was created in the CreateAuthoringChildControls</remarks>
		protected override void LoadPlaceholderContentForAuthoring(PlaceholderControlEventArgs e)
		{
			// Need to ensure that the child controls exist, so we can load their values in successfully.
			EnsureChildControls();
			try
			{
				// The placeholder that this is bound to
				XmlPlaceholder pXml = (XmlPlaceholder) this.BoundPlaceholder;
				// Only load in the values if this isn't a new posting
				if (!e.Posting.State.Equals(PostingState.New))
				{
					// Load in the XML from the content repository into an XML Document. Add the required namespace to the document for use in the SelectNodes methods
					XmlDocument xmlMetadata = new XmlDocument();
					XmlNamespaceManager xnmMetadata = new XmlNamespaceManager(xmlMetadata.NameTable);
					xnmMetadata.AddNamespace(strMetadataNamespacePrefix, strMetadataNamespaceURI);

					xmlMetadata.LoadXml(pXml.XmlAsString);

					// Select all of the Metadata elements that have been retrieved from the repository and enumerate through them to load them into the controls that were created
					// in the CreateAuthoringChildControls method
					XmlNodeList xnlDCElements = xmlMetadata.SelectNodes("/" + strMetadataNamespacePrefix + ":elements/" + strMetadataNamespacePrefix + ":element", xnmMetadata);
					foreach (XmlNode xnDCElement in xnlDCElements)
					{
						try
						{
							// Find the relevant control for the Metadata element for the pages collection. As the controls all exist within as child controls of the page, not of 
							// the authoring container, there is no prefix, other than the strChildControlIDPrefix that was prefixed. to the control when it was created.
							Control ctrl = this.Page.FindControl(this.ID + ":AuthoringModeControlsContainer:" + xnDCElement.Attributes["name"].Value);
							// TextBox controls: just load in the text to the Text property of the control
							//if(ctrl.GetType().Equals(typeof(System.Web.UI.WebControls.TextBox)) || ctrl.GetType().BaseType.Equals(typeof(System.Web.UI.WebControls.TextBox)) || ctrl is iokoGDSCNot2SpaceTextBox || ctrl is iokoGDSCAddress)
							if (ctrl.GetType().Equals(typeof (TextBox)))
							{
								TextBox txtControl = (TextBox) ctrl;
								txtControl.Text = xnDCElement.InnerText;

							} // End TextBox
								// ListBox controls: set to selected the list item with a value matching the data
							else if (ctrl.GetType().Equals(typeof (ListBox)))
							{
								ListBox lbControl = (ListBox) ctrl;
								lbControl.ClearSelection();
								foreach (ListItem li in lbControl.Items)
								{
									if (li.Value.Equals(xnDCElement.InnerText))
									{
										li.Selected = true;
										break;
									}
								}
							} // End ListBox


							// iokoGCLListBox controls: if the data contains a single text value, just select that single item, otherwise select all the items
							/*
							else if(ctrl.GetType().Equals(typeof(com.ioko.WebControls.iokoGCLListBox)))
							{
								com.ioko.WebControls.iokoGCLListBox gcllbContrl = (com.ioko.WebControls.iokoGCLListBox)ctrl;
								char[] separators = {';'};
								if(xnDCElement.SelectNodes(strMetadataNamespacePrefix + ":multivalue", xnmMetadata).Count > 0)
								{
									foreach(XmlElement xeMultivalue in  xnDCElement.SelectNodes(strMetadataNamespacePrefix + ":multivalue", xnmMetadata))
									{
										foreach(ListItem liKeyword in gcllbContrl.Items)
										{
											if(liKeyword.Value.Equals(xeMultivalue.InnerText))
											{
												liKeyword.Selected = true;
											}
										}

									}
								} 
								else
								{
									foreach(ListItem liKeyword in gcllbContrl.Items)
									{
										if(liKeyword.Value.Equals(xnDCElement.InnerText))
										{
											liKeyword.Selected = true;
											break;
										}
									}
								}								
							}
							*/
						}
						catch (NullReferenceException nre)
						{
							this.Page.Trace.Warn("MetadataPlaceHolder.LoadPlaceholderContentForAuthoring", "Null reference exception caught:" + nre.Message);
						}
					}

				}

			}
			catch (Exception f)
			{
				string message = f.Message;
				this.Context.Trace.Warn(message);
				throw f;
			}
		}

		/// <summary>
		///		Load the Placeholder contents for presentation. This is handled within the Render method as we need to write out the meta tags to the output stream directly
		/// </summary>
		///
		protected override void LoadPlaceholderContentForPresentation(PlaceholderControlEventArgs e)
		{
			mstrMetaData = "";
			CmsHttpContext cmsHttpContext = CmsHttpContext.Current;
			if (cmsHttpContext.Mode != PublishingMode.Update)
			{
				try
				{
					XmlPlaceholder pXml = (XmlPlaceholder) this.BoundPlaceholder;

					if (!cmsHttpContext.Posting.State.Equals(PostingState.New))
					{
						XmlDocument xmlMetadata = new XmlDocument();
						XmlNamespaceManager xnmMetadata = new XmlNamespaceManager(xmlMetadata.NameTable);
						xnmMetadata.AddNamespace(strMetadataNamespacePrefix, strMetadataNamespaceURI);

						xmlMetadata.LoadXml(pXml.XmlAsString);

						XmlNodeList xnlDCElements = xmlMetadata.SelectNodes("/" + strMetadataNamespacePrefix + ":elements/" + strMetadataNamespacePrefix + ":element", xnmMetadata);
						foreach (XmlNode xnDCElement in xnlDCElements)
						{
							if (xnDCElement.InnerText.Trim().Length > 0)
							{
								try
								{
									mstrMetaData += HtmlTextWriter.TagLeftChar;
									mstrMetaData += "meta";
									mstrMetaData += HtmlTextWriter.SpaceChar;
									mstrMetaData += HtmlTextWriterAttribute.Name;
									mstrMetaData += HtmlTextWriter.EqualsDoubleQuoteString;
									mstrMetaData += xnDCElement.Attributes.GetNamedItem("name").Value;
									mstrMetaData += HtmlTextWriter.DoubleQuoteChar;
									mstrMetaData += HtmlTextWriter.SpaceChar;
									mstrMetaData += "content";
									mstrMetaData += HtmlTextWriter.EqualsDoubleQuoteString;

									//writer.WriteBeginTag("meta");
									//writer.WriteAttribute("name", xnDCElement.Attributes.GetNamedItem("name").Value, true);
									XmlNodeList xnlMultiValue = xnDCElement.SelectNodes(strMetadataNamespacePrefix + ":multivalue", xnmMetadata);
									if (xnlMultiValue != null && xnlMultiValue.Count > 0)
									{
										string strMetaContent = "";
										foreach (XmlElement xeMultiValue in xnlMultiValue)
										{
											strMetaContent += HttpUtility.HtmlEncode(xeMultiValue.InnerText) + ";";
										}
										mstrMetaData += strMetaContent;
										//writer.WriteAttribute("content", strMetaContent, true);
									}
									else
									{
										mstrMetaData += HttpUtility.HtmlEncode(xnDCElement.InnerText);
										//writer.WriteAttribute("content", xnDCElement.InnerText, true);
									}


									mstrMetaData += HtmlTextWriter.DoubleQuoteChar;

									if (xnDCElement.Attributes["scheme"] != null)
									{
										mstrMetaData += HtmlTextWriter.SpaceChar;
										mstrMetaData += "scheme";
										mstrMetaData += HtmlTextWriter.EqualsDoubleQuoteString;
										mstrMetaData += HttpUtility.HtmlEncode(xnDCElement.Attributes["scheme"].Value);
										mstrMetaData += HtmlTextWriter.DoubleQuoteChar;
									}

									if (UseXHTML)
										mstrMetaData += HtmlTextWriter.SelfClosingTagEnd;
									else
										mstrMetaData += HtmlTextWriter.TagRightChar;
								}
								catch (NullReferenceException nre)
								{
									this.Page.Trace.Warn("MetadataPlaceHolder.LoadPlaceholderContentForPresentation", "Null reference exception caught:" + nre.Message);
								}
							}
						}
					}
				}


				catch (NullReferenceException nre)
				{
					this.Page.Trace.Warn("MetadataPlaceHolder.LoadPlaceholderContentForPresentation", "Null reference exception caught:" + nre.Message);
				}

				catch (XmlException xe)
				{
					XmlException ex1 = xe;
				}

				this.Context.Trace.Write("MetaData", this.Context.Server.HtmlEncode(mstrMetaData));

				// Try to locate the literal control to place the 
				Control cControlToBind = Page.FindControl(ControlToBind);
				if (cControlToBind != null && cControlToBind is Literal)
				{
					Literal lControlToBind = cControlToBind as Literal;
					lControlToBind.Text = mstrMetaData;

				}
				else
				{
					this.Page.Response.Filter = new MetaDataStream(this.Page.Response.Filter, mstrMetaData);
				}
			} // CmsContextMode != PublishingMode.Update

		}


		/// <summary>
		///		Populate the default content for a new posting being created.
		/// </summary>
		/// <remarks>There are currently no default content for this control</remarks>
		protected override void OnPopulatingDefaultContent(PlaceholderControlCancelEventArgs e)
		{
		}

		/// <summary>
		/// This event is triggered by the MetaData Placeholder and is primarily for use with Commerce Server
		/// </summary>
		public delegate void ProfileSaving(object sender, ProfileSavingEventArgs profileArgs);

		/// <summary>
		/// The Event for when the Profile is saving (For use with Commerce Server)
		/// </summary>
		public event ProfileSaving ProfileSavingEvent;

		/// <summary>
		///		Save the placeholder contents to the Mcms placeholder.
		/// </summary>
		/// <remarks>Read in the saved data from the controls. If the item is mandatory, then a validation error will be thrown if no value has been entered</remarks>
		/// <param name="e">Any arguments for the save event</param>
		protected override void SavePlaceholderContent(PlaceholderControlSaveEventArgs e)
		{
			// Get the bound placeholder from Mcms
			XmlDocument xmlConfig = GetConfigXml();
			XmlDocument xmlMetadata = new XmlDocument();
			XmlPlaceholder pXml = (XmlPlaceholder) this.BoundPlaceholder;
			try
			{
				XmlNamespaceManager xnmConfig = new XmlNamespaceManager(xmlConfig.NameTable);
				xnmConfig.AddNamespace(strMetadataConfigNamespacePrefix, strMetadataConfigNamespaceURI);
				XmlNamespaceManager xnmMetadata = new XmlNamespaceManager(xmlConfig.NameTable);
				xnmMetadata.AddNamespace(strMetadataNamespacePrefix, strMetadataNamespaceURI);


				XmlElement xeElements = xmlMetadata.CreateElement(strMetadataNamespacePrefix, "elements", strMetadataNamespaceURI);


				//Error check for null placholder
				if (!pXml.Equals(null))
				{
					ArrayList alErrors = new ArrayList();
					// Enumerate each configuration element from the Metadata configuration file and see if a form element with a matching name is found
					foreach (XmlElement xeConfigElement in xmlConfig.SelectNodes("/" + strMetadataConfigNamespacePrefix + ":elements/" + strMetadataConfigNamespacePrefix + ":element", xnmConfig))
					{
						string strCurrentFormElement = this.ID + ":AuthoringModeControlsContainer:" + xeConfigElement.Attributes.GetNamedItem("name").Value;
						//this.Context.Trace.Write("Looking for element " + strCurrentFormElement);

						#region this.Context.Request.Form[strCurrentFormElement] != null

						if (this.Context.Request.Form[strCurrentFormElement] != null)
						{
							// raise an event to save any profile associated date - if this exists. We won't use this in this class, but this will setup us up to subclass this class at a later point and
							// use it in an MSIB project
							if (ProfileSavingEvent != null)
							{
								try
								{
									ProfileSavingEvent(this, new ProfileSavingEventArgs(this.Context.Request.Form[strCurrentFormElement], xeConfigElement.Attributes.GetNamedItem("Profile").Value, CmsHttpContext.Current.Posting));
								}
								catch (Exception exp)
								{
									Context.Trace.Warn("ProfileSaving", exp.Message, exp);
								}
							}

							//this.Context.Trace.Write("Found it");
							// add an element to the XML data to save. If the form contains multiple selected values, then add a child element for each selected value. Otherwise, just set the text to the value
							XmlElement xeElement = xmlMetadata.CreateElement(strMetadataNamespacePrefix, "element", strMetadataNamespaceURI);
							XmlAttribute xaName = xmlMetadata.CreateAttribute("name");
							xaName.Value = xeConfigElement.Attributes["name"].Value;

							// Add support for scheme attribute
							if (xeConfigElement.Attributes["scheme"] != null)
							{
								XmlAttribute xaScheme = xmlMetadata.CreateAttribute("scheme");
								xaScheme.Value = xeConfigElement.Attributes["scheme"].Value;
								xeElement.Attributes.Append(xaScheme);
							}

							xeElement.Attributes.Append(xaName);

							#region this.Context.Request.Form.GetValues(strCurrentFormElement).GetUpperBound(0)

							if (this.Context.Request.Form.GetValues(strCurrentFormElement).GetUpperBound(0) > 0)
							{
								string[] strMultiValues = this.Context.Request.Form.GetValues(strCurrentFormElement);
								for (int i = 0; i <= strMultiValues.GetUpperBound(0); i++)
								{
									XmlElement xeMultiValue = xmlMetadata.CreateElement(strMetadataNamespacePrefix, "multivalue", strMetadataNamespaceURI);
									XmlText xtMultiValue = xmlMetadata.CreateTextNode((string) strMultiValues[i]);
									xeMultiValue.AppendChild(xtMultiValue);
									xeElement.AppendChild(xeMultiValue);
								}
							}
							else
							{
								XmlText xtElement = xmlMetadata.CreateTextNode(this.Context.Request.Form[strCurrentFormElement]);

								// See if the configuration item was mandatory. If so, ensure that a value was entered
								if (xeConfigElement.SelectSingleNode("@mandatory") != null && xeConfigElement.SelectSingleNode("@mandatory").Value.Equals("true"))
								{
									if (xtElement.Value.Equals(""))
									{
										string strDisplayName = xeConfigElement.SelectSingleNode("@name").Value;
										if (xeConfigElement.SelectSingleNode("@displayName") != null)
											strDisplayName = xeConfigElement.SelectSingleNode("@displayName").Value;

										alErrors.Add("Required Metadata field (" + strDisplayName + ") is missing");

										//WebAuthorContext.Current.RaiseErrorEvent(new WebAuthorErrorEventArgs("FailedSavePlaceholder", ));
									}

								}

								/*
								string strIokoGDSCControlStart = "com.ioko.WebControls.GDSC";

								// if the namespace for control has a left of the namespace specified above, it is a GDSC validation control, so was can
								// cast the control to the IGDSCCmsControl interface in order to validate it. 
								if(xeConfigElement.Attributes.GetNamedItem("type") != null &&  xeConfigElement.Attributes.GetNamedItem("type").Value.Length > strIokoGDSCControlStart.Length && xeConfigElement.Attributes.GetNamedItem("type").Value.Substring(0, strIokoGDSCControlStart.Length).Equals(strIokoGDSCControlStart))
								{
									try
									{
										IGDSCCmsControl igdscCmsControl = (IGDSCCmsControl)this.Page.FindControl(strCurrentFormElement);
										if(!igdscCmsControl.Validate())
										{
											alErrors.Add(igdscCmsControl.ValidationError);
											//WebAuthorContext.Current.RaiseErrorEvent(new WebAuthorErrorEventArgs("FailedSavePlaceholder", new Exception(igdscCmsControl.ValidationError)));

										}
									}
									catch(InvalidCastException ice)
									{
										this.Context.Trace.Warn("MetadataPlaceHolder.SavePlaceholderContent", ice.Message);
									}
									
								}
								*/
								xeElement.AppendChild(xtElement);
							}

							#endregion

							xeElements.AppendChild(xeElement);
						}

						#endregion
					}

					xmlMetadata.AppendChild(xeElements);

					if (alErrors.Count > 0)
					{
						string strExceptions = "";
						foreach (string strException in alErrors)
						{
							strExceptions += strException + "<" + HtmlTextWriterTag.Br + ">";

						}
						WebAuthorContext.Current.RaiseErrorEvent(new WebAuthorErrorEventArgs("FailedSavePlaceholder", new Exception(strExceptions)));
					}


				}
			}
			catch (Exception f)
			{
				string message = f.Message;
				this.Context.Trace.Warn(message);
			}
			pXml.XmlAsString = xmlMetadata.InnerXml;

		}


		//	/// <summary>
		//	/// Overrides the Render method of the base class. 
		//	/// </summary>
		//	/// <remarks>If this is being run in CMS Update mode then the base method is called. Otherwise the meta data is written to the HtmlTextWriter. Currently this only supports Html. 
		//	/// 
		//	/// </remarks>
		//	/// <param name="writer">A HtmlTextWriter passed in when this control needs to be rendered by the runtime</param>
		//		protected override void Render(System.Web.UI.HtmlTextWriter writer)
		//		{
		//		}

		#endregion

		#region Private Methods ------------------------------------

		/// <summary>
		/// Helper method to load in the Metadata XML configuration
		/// </summary>
		/// <returns>System.Xml.XmlDocument containing the XML specified by the ConfigFile property</returns>
		private XmlDocument GetConfigXml()
		{
			Uri uriConfig = new Uri(ConfigFile);
			XmlDocument xmlConfig = new XmlDocument();

			// for Http use the XmlTextReader to read the configuration file in
			if (uriConfig.Scheme.Equals("http") || uriConfig.Scheme.Equals("https"))
			{
				xmlConfig.Load(new XmlTextReader(this.ConfigFile));
			}	
				// otherwise, use a FileReader to read the configuration file in
			else
			{
				string strConfigFile = ConfigFile;
				if (strConfigFile.StartsWith("file:///"))
				{
					strConfigFile = strConfigFile.Replace("file:///", "");
				}
				using (FileStream fsConfig = new FileStream(strConfigFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite))
				{
					xmlConfig.Load(fsConfig);
				}

			}


			return xmlConfig;
		}

		#endregion
	} //Close Class

	/// <summary>
	/// The EventArgs for when the Profile is saving (For use with Commerce Server)
	/// </summary>
	public class ProfileSavingEventArgs : EventArgs
	{
		private string mstrValue;
		private string mstrProfileName;
		private Posting mPosting;

		/// <summary>
		/// The EventArgs for the Profile (For use with Commerce Server)
		/// </summary>
		public ProfileSavingEventArgs(string Value, string ProfileName, Posting p)
		{
			mstrValue = Value;
			mstrProfileName = ProfileName;
			mPosting = p;
		}

		/// <summary>
		/// The value for the Profile (For use with Commerce Server)
		/// </summary>
		public string Value
		{
			get { return mstrValue; }
		}

		/// <summary>
		/// The name for the Profile (For use with Commerce Server)
		/// </summary>
		public string ProfileName
		{
			get { return mstrProfileName; }
		}

		/// <summary>
		/// The Posting for the Profile (For use with Commerce Server)
		/// </summary>
		public Posting PostingToProfile
		{
			get { return mPosting; }
		}
	}
} //Close Namspace
