using System;
using System.Diagnostics;
using System.IO;
using System.Threading;

namespace MSIBPlusPack.ContentManagement.Publishing.Placeholders
{
	internal class MetaDataStream : Stream
	{
		private Stream mResponseStream;
		private string mstrMetadata;
		private long _position;
		byte[] cachedOutput;

		public MetaDataStream(Stream responseStream, string metadata)
		{
			this.mResponseStream = responseStream;
			this.mstrMetadata = metadata;
		}

		// The following members of Stream must be overriden.
		public override bool CanRead
		{
			get { return mResponseStream.CanRead; }
		}

		public override bool CanSeek
		{
			get { return mResponseStream.CanSeek; }
		}

		public override bool CanWrite
		{
			get { return mResponseStream.CanWrite; }
		}

		public override long Length
		{
			get { return mResponseStream.Length + mstrMetadata.Length; }
		}

		public override long Position
		{
			get { return _position; }
			set { _position = value; }
		}

		public override long Seek(long offset, SeekOrigin direction)
		{
			return mResponseStream.Seek(offset, direction);
		}

		public override void SetLength(long length)
		{
			mResponseStream.SetLength(length);
		}

		public override void Close()
		{
			// newdata is a copy of the inbound data
			int offset=0;
			byte[] buffer = new byte[cachedOutput.Length];
			int count = cachedOutput.Length;
			Buffer.BlockCopy(cachedOutput,0,buffer,0,count);
			
			// newdata is a copy of the inbound data
			byte[] newdata = new byte[count];
			// copy the buffer into our copy of the data
			Buffer.BlockCopy(buffer, offset, newdata, 0, count);

			// start enumerating thro' 
			for (int i = 0; i < count; i++)
			{
				//if(buffer[i] == '<' && count - i > 5 && buffer[i+1] == '/')
				//	First check that we have </
				if(buffer[i] == '<' && count - i > 5 && buffer[i+1] == '/' )
				{
					//	Then check there are enough chars for </head>
					if(i+6 < count)
					{
						//	check that we have </xxxx>
						if(buffer[i+6] == '>')
						{
							//	check for head
							string tagName = "";
							for(int j = 0; j < 4; j++)
							{
								tagName += (char)buffer[i + j + 2];
							}

							if(tagName.ToLower(Thread.CurrentThread.CurrentCulture).Equals("head"))
							{
						
								newdata = new byte[count + mstrMetadata.Length];
								i -= 0;
								int j = i;
								Buffer.BlockCopy(buffer, offset, newdata, 0, i);
								foreach(char c in mstrMetadata)
								{
									newdata[j++] = (byte)c;
								}
						
								Buffer.BlockCopy(buffer, offset + i, newdata, i + mstrMetadata.Length, count - i );
								count += mstrMetadata.Length;
								break;

							}
						}
					}
				}
			
		
			}

			mResponseStream.Write(newdata, 0, count);

			mResponseStream.Close();
		}

		public override void Flush()
		{
			mResponseStream.Flush();
		}

		public override int Read(byte[] buffer, int offset, int count)
		{
			return mResponseStream.Read(buffer, offset, count);
		}

		// The Write method actually does the filtering.
		public override void Write(byte[] buffer, int offset, int count)
		{
			
			if(cachedOutput == null)
			{
				cachedOutput = new byte[count];
				Buffer.BlockCopy(buffer, offset, cachedOutput, 0, count);
				//buffer.CopyTo(cachedOutput, 0);
			}
			else
			{
				Debug.Write("Got another write!");

				int iOriginalLength = cachedOutput.Length;
				byte[] cachedOutputCopy = new byte[cachedOutput.Length + buffer.Length];
				Buffer.BlockCopy(cachedOutput, 0, cachedOutputCopy,0, iOriginalLength);
				Buffer.BlockCopy(buffer, 0, cachedOutputCopy, iOriginalLength, buffer.Length);

				cachedOutput = cachedOutputCopy;
			}    
		}

	}

}
