<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="/">
	<xsl:apply-templates/>
</xsl:template>


<xsl:template match="nav">
	<a name="top"/>
	<xsl:for-each select="anchor">
		<a href="#bookmark{@letter}"><xsl:value-of select="@letter"/></a>&#160;
	</xsl:for-each>	
	<br/>
	<xsl:apply-templates/>
	<br/>
	<xsl:for-each select="anchor">
		<a href="#bookmark{@letter}"><xsl:value-of select="@letter"/></a>&#160;
	</xsl:for-each>	
</xsl:template>

<xsl:template match="text()"/>

<xsl:template match="channel">
<li>
<a href="{postingurl}" class="leftnavmenuitem" target="_self"><xsl:value-of select="displayname"/></a>&#160;
</li>
<br/>
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="anchor">
	<xsl:if test="@backtotop='true'">
		<br/>
		<a href="#top">Back to top</a>
		<br/>
	</xsl:if>
	<a name="bookmark{@letter}"/>
	<br/>
</xsl:template>

<xsl:template match="posting">
<li>
<a href="{postingurl}" class="leftnavmenuitem" target="_self"><xsl:value-of select="displayname"/></a>
</li>
</xsl:template>


</xsl:stylesheet>

  