using System;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.Design;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Text;

namespace MSIBPlusPack.Web.UI.WebControls.Design
{
	/// <summary>
	/// Summary description for Navigation.
	/// </summary>
	internal class NavigationDesigner : ControlDesigner
	{
		/// <summary>
		/// Returns something to the IDE in the event of nothing coming from GetDesignTimeHTML
		/// </summary>
		/// <returns>string</returns>
		protected override string GetEmptyDesignTimeHtml()
		{

			return CreatePlaceHolderDesignTimeHtml("cScapeNav"); 

		}

		/// <summary>
		/// Brings back a representation of the control in design time
		/// </summary>
		/// <returns>string</returns>
		public override string GetDesignTimeHtml()
		{
			NavigationControl navCon = (NavigationControl) Component;

			StringBuilder szOutPut = new StringBuilder();

			szOutPut.Append("<table border=0 bgcolor=\"#AAAAFF\"><tr><td align=\"left\"><small>");
			
			#region Presentation Mode
			szOutPut.Append("Display:&nbsp;<b>");
			switch(navCon.PresentationMode)
			{
				case NavigationControl.NavigationPresentationMode.BreadCrumb:
				{

					szOutPut.Append("BreadCrumb");
					break;

				}
				case NavigationControl.NavigationPresentationMode.ComboBox:
				{

					szOutPut.Append("Nav Combo");
					break;

				}
				case NavigationControl.NavigationPresentationMode.Primary:
				{

					szOutPut.Append("Nav Primary");
					break;

				}
				case NavigationControl.NavigationPresentationMode.SecondaryAllChannels:
				{

					szOutPut.Append("Secondary All Channels");
					break;

				}
				case NavigationControl.NavigationPresentationMode.SecondaryIgnoreUnderScore:
				{

					szOutPut.Append("Secondary Ignore UnderScore");
					break;

				}
				case NavigationControl.NavigationPresentationMode.SecondarySelectedPrimary:
				{

					szOutPut.Append("Secondary Selected Primary");
					break;

				}
				case NavigationControl.NavigationPresentationMode.Highlight:
				{

					szOutPut.Append("Highlight Posts");
					break;

				}
				case NavigationControl.NavigationPresentationMode.SiteMap:
				{

					szOutPut.Append("Site Map");
					break;

				}
				case NavigationControl.NavigationPresentationMode.AtoZ:
				{

					szOutPut.Append("A to Z");
					break;

				}


			}
			szOutPut.Append("</b><br>");
			#endregion

			#region Root Channel
			
			szOutPut.Append("Root Channel:<b>");
			szOutPut.Append(navCon.RootChannel);
			szOutPut.Append("</b><br>");

			#endregion

			#region DevMode

			szOutPut.Append("Mode :<b>");
			
			switch(navCon.Mode)
			{
				case MSIBPlusPack.Web.UI.WebControls.NavigationControl.EnmMode.Development:
				{
					szOutPut.Append("Development Mode");
					break;
				}
				case MSIBPlusPack.Web.UI.WebControls.NavigationControl.EnmMode.DevelopmentDebugXML:
				{
					szOutPut.Append("Debug XML Mode");
					break;
				}
				case MSIBPlusPack.Web.UI.WebControls.NavigationControl.EnmMode.Production:
				{
					szOutPut.Append("Production");
					break;
				}

			}

			szOutPut.Append("</b><br>");			

			#endregion

			szOutPut.Append("</td></tr><tr><td bgcolor=\"#EEEEFF\">");

			szOutPut.Append("<a href=\"http:www.msibpluspack.com\" style=\"text-decoration:none\"><i>MSIB Navigation</i></a>");

			szOutPut.Append("</td></tr></table>");

			StringWriter szWriter =  new StringWriter();

			HtmlTextWriter htmWriter = new HtmlTextWriter(szWriter);

			HyperLink placeHolderLink = new HyperLink();

			placeHolderLink.Text = szOutPut.ToString(); 
			placeHolderLink.RenderControl(htmWriter);


		

			return szWriter.ToString();

		}

		/// <summary>
		///		Initialization routine. Captures the component and casts it to our object. 
		/// </summary>
		internal NavigationControl _NavigationControl;

		public override void Initialize(IComponent component)
		{
			base.Initialize(component);
			_NavigationControl = (NavigationControl) component;
		}

	}
}
