using System;
using System.IO;
using System.Text;
using System.Web;
using System.Xml;
using System.Xml.Xsl;
using System.Xml.XPath;


namespace MSIBPlusPack.Web.UI.WebControls
{
	/// <summary>
	/// A repository for commonly used static functions.
	/// </summary>
	/// <remarks>See the member list for information on NavigationHelper methods/properties.</remarks>
	public class NavigationHelper
	{


		#region XSL Transform of result 
		/// <summary>
		/// This method transforms the supplied XML string using the XSL stylesheet at the path supplied.
		/// </summary>
		/// <param name="strXML">A string of XML data to be transformed.</param>
		/// <param name="strXSLFile">A string containing the virtual path 
		/// to the XSL stylesheet to use.</param>
		/// <returns>A string of HTML representing the transformed result set.</returns>
		/// <remarks>In the event of an error the function returns a string representing an XML node 
		/// containing details of the error.</remarks>
		public static string TransformXML(string strXML, string strXSLFile)
		{

			StringBuilder sbReturn = new StringBuilder();

			strXSLFile = HttpContext.Current.Server.MapPath(strXSLFile);

			StringReader sReader = new StringReader(strXML);

			StringWriter sWriter = new StringWriter(sbReturn);

			XmlTextWriter xmlWriter = new XmlTextWriter(sWriter);

			//Load XML into an XPath
			XPathDocument xpthResults = new XPathDocument(sReader);
			
			XslTransform xslTrans = new XslTransform();

			try
			{
			
				//Load our XSL file
				xslTrans.Load(strXSLFile);

				//And transform
				xslTrans.Transform(xpthResults, null, xmlWriter);

			}
			catch(Exception e)
			{
				
				sbReturn.Append("<Error>");
				sbReturn.Append(e.Message);
				sbReturn.Append(" - ");
				sbReturn.Append(e.InnerException);
				sbReturn.Append("</Error>");

			}

			return sbReturn.ToString();

		}
		/// <summary>
		/// This method transforms the supplied XML string using the XSL stylesheet accessed by the supplied 
		/// XmlTextReader.
		/// </summary>
		/// <param name="strXML">A string of XML data to be transformed.</param>
		/// <param name="xmlXSL">An XmlTextReader accessing the XSL stylesheet to use.</param>
		/// <returns>A string of HTML representing the transformed result set.</returns>
		/// <remarks>In the event of an error the function returns a string representing an XML node 
		/// containing details of the error.</remarks>
		public static string TransformXML(string strXML, XmlTextReader xmlXSL)
		{

			StringBuilder sbReturn = new StringBuilder();

			StringReader sReader = new StringReader(strXML);

			StringWriter sWriter = new StringWriter(sbReturn);

			XmlTextWriter xmlWriter = new XmlTextWriter(sWriter);

			//Load XML into an XPath
			XPathDocument xpthResults = new XPathDocument(sReader);

			XslTransform xslTrans = new XslTransform();

			try
			{
			
				//Load our XSL file
				xslTrans.Load(xmlXSL);

				//And transform
				xslTrans.Transform(xpthResults, null, xmlWriter);

			}
			catch(Exception e)
			{
			

				throw(e);

			}

			return sbReturn.ToString();

		}

		/// <summary>
		/// This method transforms the supplied XML string using the XSL stylesheet accessed by the supplied 
		/// XmlReader.
		/// </summary>
		/// <param name="xmlNav">An XmlDocument object representing the XML data to be transformed.</param>
		/// <param name="xmlXSL">An XmlReader accessing the XSL stylesheet to use.</param>
		/// <returns>A string of HTML representing the transformed result set.</returns>
		/// <remarks>In the event of an error the function returns a string representing an XML node 
		/// containing details of the error.</remarks>
		public static string TransformXML(XmlDocument xmlNav, XmlReader xmlXSL)
		{

			StringBuilder sbReturn = new StringBuilder();

			StringWriter sWriter = new StringWriter(sbReturn);

			XmlTextWriter xmlWriter = new XmlTextWriter(sWriter);
			
			XslTransform xslTrans = new XslTransform();

			try
			{
			
				//Load our XSL file
				xslTrans.Load(xmlXSL);

				//And transform
				xslTrans.Transform(xmlNav, null, xmlWriter);

			}
			catch(Exception e)
			{
				
				
				throw(e);

			}

			return sbReturn.ToString();

		}

		#endregion

		#region posting display name cleaning 
		/// <summary>
		/// As we allow users to Mark up the Displayname for rendering purposes, this function cleans out the markup, for simple use.
		/// </summary>
		/// <param name="vstrDisplayName">A string representing the DisplayName of a Posting.</param>
		/// <returns>A string representing the 'cleaned' DisplayName.</returns>
		/// <remarks>Removes words with ^^ ^ and removes |.</remarks>
		public static string GetDisplayName(string vstrDisplayName)
		{
			
			//Get our display name into a string, because if it has a ^^ light text marking we remove that word, plus we replace '|'
			string strDisplay = vstrDisplayName;

			if(strDisplay.IndexOf("^") > -1)
			{
					
				int iIndex = strDisplay.LastIndexOf("^");

				strDisplay = strDisplay.Substring(++iIndex);

			}

			strDisplay = strDisplay.Replace("|"," ");

			return strDisplay;

		
		}

		#endregion

		#region Remove HTML mark up
		/// <summary>
		/// Simple function to strip out HTML tags
		/// </summary>
		/// <param name="vstrClean">string to clean</param>
		/// <returns>String sans HTML mark up</returns>
		/// <remarks>Use caution when calling as this currently removes anything between &lt; &gt;</remarks>
		public static string RemoveHTML(string vstrClean)
		{

			int iPos;

			
			iPos = vstrClean.IndexOf("<");

			while(iPos > -1)
			{

				vstrClean = vstrClean.Replace(vstrClean.Substring(iPos, (vstrClean.IndexOf(">",iPos)-(iPos-1))),"");	
			
				iPos = vstrClean.IndexOf("<");

			}


			return vstrClean;


		}

		#endregion

		#region Display As HTML
		/// <summary>
		/// Convert HTML and XML to display in a browser.
		/// </summary>
		/// <remarks>This method replaces angled-brackets etc. with their equivalent HTML-encoding 
		/// to ensure the string will be displayed in a browser.</remarks>
		/// <param name="strDisplay">A string of HTML or XML to be cleaned for display in a browser.</param>
		/// <returns>A string representing the HTML to be displayed.</returns>
		public static string DisplayAsHTML(string strDisplay)
		{

			string strReturn = strDisplay;

			strReturn = strReturn.Replace("><", "&gt;*BE**BR**B*&lt;");

			strReturn = strReturn.Replace("<","*B*&lt;");

			strReturn = strReturn.Replace(">", "&gt;*BE*");

			strReturn = strReturn.Replace("*BR*", "<br>");

			strReturn = strReturn.Replace("*BE*", "</b>");

			strReturn = strReturn.Replace("*B*", "<b>");

			return strReturn;

		}
		#endregion


	}
}
