namespace MSIBPlusPack.ContentManagement.Publishing.Placeholders
{
	/// <summary>
	/// The NearestMapProvider interface defines the base requirements for arbitrary Map Providers to be bolted into this software.
	/// Concrete Mapping Provider specific extensions to this interface must be dealt with accordingly.
	/// </summary>
	internal interface INearestMapProvider
	{
		#region Properties
		string EntityTypeValue
		{
			get;
			set;
		}

		string Keywords
		{
			get;
			set;
		}

		string Version
		{
			get;
		}

		NearestMapEntityType[] MapEntityTypes
		{
			get;
		}
		#endregion

		#region Method Members
		//void ValidateConnectivity();		// Internal
		bool FindNearest();
		void MoveIn();
		void MoveOut();
		void MoveWest();
		void MoveEast();
		void MoveNorth();
		void MoveSouth();
		#endregion
	}
}
