namespace MSIBPlusPack.ContentManagement.Publishing.Placeholders
{
	/// <summary>
	/// The NearestMapEntityType class defines Entity Types for Nearest searches.
	/// I.e. classes of items that can be searched for by the Nearest component as a <i>point of interest</i>.
	/// </summary>
	/// <remarks>
	/// <para>Entity Types have a <see cref="NearestMapEntityType.Name"/> property for display purposes and a <see cref="NearestMapEntityType.Value"/> property that contains the corresponding key / ID.</para>
	/// <para>The read-only property <see cref="NearestMapPointProvider.MapEntityTypes"/> returns a list of all valid Entity Types that can be searched for with the current points of interest data source (as an array of NearestMapEntityType objects).</para>
	/// <para>The property <see cref="NearestMapPointProvider.EntityTypeValue"/> exposes the <see cref="NearestMapEntityType.Value"/> of the Entity Type to search for.</para>
	/// <para>This class cannot be overridden nor instantiated by external assemblies.</para>
	/// </remarks>
	public sealed class NearestMapEntityType
	{
		#region State management fields
		private string _name;
		private string _value;
		#endregion

		#region Constructors
		internal NearestMapEntityType(string Name, string Value)
		{
			_name = Name;
			_value = Value;
		}
		#endregion

		#region Properties
		/// <summary>
		/// The read-only Name of an Entity Type. This property can be used for presentation purposes.
		/// </summary>
		public string Name
		{
			get { return _name; }
		}

		/// <summary>
		/// The read-only Value (key / ID) of an Entity Type. It is this MapPoint Entity Type property that must be specified for the Nearest component to perform a search.
		/// </summary>
		public string Value
		{
			get { return _value; }
		}
		#endregion
	}
}
