using System;
using System.Configuration;
using System.Net;
using MSIBPlusPack.ContentManagement.Publishing.Placeholders.MapPointService;

namespace MSIBPlusPack.ContentManagement.Publishing.Placeholders
{
	/// <summary>
	/// Internal wrapper for MapPoint service
	/// </summary>
	internal class NearestMapPointGlobal
	{
		#region Constuctors
		/// <summary>
		/// Initializes the MapPoint .NET connection objects.
		/// </summary>
		internal NearestMapPointGlobal()
		{
			InitializeMPNetConnection();
		}
		#endregion

		#region Proxy handling
		private IWebProxy proxy;

		internal IWebProxy Proxy
		{
			get
			{
				return proxy;
			}
		}
		#endregion

		#region MapPointNet
		// This section handles the initialization and management of the classes for the MapPoint .NET service

		/// <summary>
		/// These are the actual instances of the objects that call the MapPoint .NET service
		/// </summary>
		private RenderServiceSoap renderService;
		private FindServiceSoap findService;
		private RouteServiceSoap routeService;
		private CommonServiceSoap commonService;

		/// <summary>
		/// Performs the work needed to initialize the connection to the 
		/// MapPoint .NET service
		/// </summary>
		private void InitializeMPNetConnection()
		{
			try
			{
				// Create and set the logon information (note comment in web.config -- here would be the place to
				// decrypt/unhash the user/password from the config file).
				NetworkCredential ourCredentials = new NetworkCredential( ConfigurationSettings.AppSettings["MPUser"],
					ConfigurationSettings.AppSettings["MPPass"] );
				
				// Create the render service
				renderService = new RenderServiceSoap();
				renderService.Credentials = ourCredentials;
				renderService.PreAuthenticate = true;
				
				// Create the find service
				findService = new FindServiceSoap();
				// set the logon information
				findService.Credentials = ourCredentials;
				findService.PreAuthenticate = true;
				
				// Create the route service
				routeService = new RouteServiceSoap();
				// set the logon information
				routeService.Credentials = ourCredentials;
				routeService.PreAuthenticate = true;

				// Create the common service
				commonService = new CommonServiceSoap();
				// set the logon information
				commonService.Credentials = ourCredentials;
				commonService.PreAuthenticate = true;
				
			}
			catch( Exception ex )
			{
				throw new Exception("Exception attempting to connect to MapPoint .NET: " + ex.Message);
			}
			proxy = commonService.Proxy;
		}

		/// <summary>
		/// An instance of the render service class
		/// </summary>
		internal RenderServiceSoap RenderService
		{
			get
			{
				renderService.Proxy = proxy;
				return renderService;
			}
		}

		/// <summary>
		/// An instance of the find service class
		/// </summary>
		internal FindServiceSoap FindService
		{
			get
			{
				findService.Proxy = proxy;
				return findService;
			}
		}

		/// <summary>
		/// An instance of the route service class
		/// </summary>
		internal RouteServiceSoap RouteService
		{
			get
			{
				routeService.Proxy = proxy;
				return routeService;
			}
		}

		/// <summary>
		/// An instance of the common service class
		/// </summary>
		internal CommonServiceSoap CommonService
		{
			get
			{
				commonService.Proxy = proxy;
				return commonService;
			}
		}
		
		#endregion
	}
}
