using System;
using System.Xml;

namespace MSIBPlusPack.Xml.Serialization
{
	/// <summary>
	/// Provides XML serialization / deserialization for the MSIB Plus Pack Nearest component
	/// </summary>
	internal class NearestXMLSerializer
	{
		#region State management fields
		private string entityTypeValue;
		private string keywords;
		private string mapPointDataSource;
		private string pointsOfInterestDataSource;
		private int range;

		#endregion

		#region Constructors
		/// <summary>
		/// Initializes default instance fields
		/// </summary>
		internal NearestXMLSerializer()
		{
			SetDefaultState();
		}

		/// <summary>
		/// Initializes instance fields from XML
		/// </summary>
		/// <param name="xml">XML to initialize properties from</param>
		internal NearestXMLSerializer(string xml)
		{
			XML = xml;
		}
		#endregion

		#region Default field state members
		/// <summary>
		/// Sets the default state of fields
		/// </summary>
		private void SetDefaultState()
		{
			entityTypeValue = "";
			keywords = "";
			range = 10;
			mapPointDataSource = "MapPoint.EU";
			pointsOfInterestDataSource = "NavTech.EU";
		}
		#endregion

		#region Properties
		/// <summary>
		/// Exposes the read / write XML representation of Nearest component configuration
		/// </summary>
		internal string XML
		{
			get {
				return String.Format("<Nearest>" +
					"<EntityTypeValue>{0}</EntityTypeValue>" +
					"<Keywords>{1}</Keywords>" +
					"<MapPointDataSource>{3}</MapPointDataSource>" +
					"<PointsOfInterestDataSource>{4}</PointsOfInterestDataSource>" +
					"<Range>{2}</Range>" +
					"</Nearest>",
					entityTypeValue, keywords, range, mapPointDataSource, pointsOfInterestDataSource);
			}
			set {
				SetDefaultState();

				XmlDocument doc = new XmlDocument();
				doc.LoadXml(value);

				try {
					entityTypeValue = doc.SelectSingleNode("/Nearest/EntityTypeValue").InnerText;
				}
				catch { }

				try {
					keywords = doc.SelectSingleNode("/Nearest/Keywords").InnerText;
				} 
				catch { }

				try 
				{
					mapPointDataSource = doc.SelectSingleNode("/Nearest/MapPointDataSource").InnerText;
				} 
				catch { }

				try 
				{
					pointsOfInterestDataSource = doc.SelectSingleNode("/Nearest/PointsOfInterestDataSource").InnerText;
				} 
				catch { }

				try 
				{
					range = Int32.Parse(doc.SelectSingleNode("/Nearest/Range").InnerText);
				} 
				catch { }
			}
		}

		internal string EntityTypeValue
		{
			get
			{
				if (null == entityTypeValue)
					return null;

				if (entityTypeValue.Trim().Length == 0)
					return null;

				return entityTypeValue;
			}
			set { entityTypeValue = value; }
		}

		internal string Keywords
		{
			get
			{
				if (null == keywords)
					return keywords;

				if (keywords.Trim().Length == 0)
					return null;

				return keywords;
			}
			set { keywords = value; }
		}

		internal string MapPointDataSource
		{
			get { return mapPointDataSource; }
			set { mapPointDataSource = value; }
		}

		internal string PointsOfInterestDataSource
		{
			get { return pointsOfInterestDataSource; }
			set { pointsOfInterestDataSource = value; }
		}

		internal int Range
		{
			get { return range; }
			set { range = value; }
		}
		#endregion
	}
}
