using System;
using System.Text;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.ContentManagement.WebControls;
using MSIBPlusPack.ContentManagement.Publishing.Placeholders;

namespace NearestExample
{
	/// <summary>
	/// This is a basic example presentation layer for the MSIB Plus Pack Nearest component (overriding NearestPlaceholder).
	/// The CMS author chooses the entity type for the search.
	/// The subscriber (site user) selects the keywords and range for the nearest search.
	/// The search results consist of a map and table of results.
	/// </summary>
	public class NearestPlaceholderExampleBasic : NearestPlaceholder
	{		
		#region Controls
		// Authoring
		protected DropDownList ddlEntityType;

		// Presentation
		protected TextBox tbKeywords;
		protected DropDownList ddlRange;
		protected Button btnSearch;
		protected Panel pnlResults;
		protected Panel pnlResultsLocationError;
		protected Table tblSearchResults;
		protected System.Web.UI.WebControls.Image imgMap;
		#endregion

		#region Properties
		private string _MapImageUrl = "/MSIBPlusPack/Map.aspx";

		public string MapImageUrl
		{
			get { return _MapImageUrl; }
			set { _MapImageUrl = value; }
		}
		#endregion

		#region NearestPlaceholder override members
		protected override void CreateAuthoringChildControls(BaseModeContainer authoringContainer)
		{
			// Call NearestPlaceHolder class's LoadPlaceholderContentForAuthoring member frist to initialize MapPointProvider
			base.CreateAuthoringChildControls(authoringContainer);

			//
			// TODO: Add your code here
			//

			// Create entity type drop down control
			ddlEntityType = new DropDownList();
			ddlEntityType.ID = "ddlEntityType";
			foreach (NearestMapEntityType mapEntityType in MapPointProvider.MapEntityTypes)
				ddlEntityType.Items.Add(new ListItem(mapEntityType.Name, mapEntityType.Value));

			// Add controls to container
			authoringContainer.Controls.Add(new LiteralControl("<b>Nearest MapPoint Search</b>" +
				"<p>Please specify the required entity type that site users will search for in conjunction with this Posting:</p>" +
				"<table><tr><td>Entity Type:</td><td>"));
			authoringContainer.Controls.Add(ddlEntityType);
			authoringContainer.Controls.Add(new LiteralControl(String.Format("</td></tr></table>")));
		}

		protected override void LoadPlaceholderContentForAuthoring(PlaceholderControlEventArgs e)
		{
			// Call NearestPlaceHolder class's LoadPlaceholderContentForAuthoring member first to initialize MapPointProvider
			base.LoadPlaceholderContentForAuthoring(e);

			//
			// TODO: Add your code here
			//

			if (null != MapPointProvider.EntityTypeValue)
				ddlEntityType.SelectedValue = MapPointProvider.EntityTypeValue;
		}

		protected override void SavePlaceholderContent(PlaceholderControlSaveEventArgs e)
		{
			//
			// TODO: Add your code here
			//

			if (null != ddlEntityType)
				MapPointProvider.EntityTypeValue = ddlEntityType.SelectedValue;

			// Call NearestPlaceHolder class's SavePlaceholderContent last to save the MapPointProvider state to the placeholder definition
			base.SavePlaceholderContent(e);
		}

		protected override void CreatePresentationChildControls(BaseModeContainer presentationContainer)
		{
			// Call NearestPlaceHolder class's CreatePresentationChildControls member frist to initialize MapPointProvider
			try { base.CreatePresentationChildControls(presentationContainer); } 
			catch { return; }	// Prevent errors being reported to site subscribers - just remove the control from the page

			//
			// TODO: Add your code here
			//

			// Create Search keywords textbox
			tbKeywords = new TextBox();
			tbKeywords.ID = "tbKeywords";
			tbKeywords.Width = 128;
			tbKeywords.MaxLength = 50;			// Give the site subscriber ample space for arbitrary keywords
			tbKeywords.ToolTip = "Please enter your Postcode here";

			// Create Range drop down list:
			ddlRange = new DropDownList();
			ddlRange.ID = "ddlRange";
			ddlRange.Width = 128;
			ddlRange.Items.Add(new ListItem("2 miles","2"));
			ddlRange.Items.Add(new ListItem("5 miles","5"));
			ddlRange.Items.Add(new ListItem("10 miles","10"));
			ddlRange.Items.Add(new ListItem("25 miles","25"));
			ddlRange.Items.Add(new ListItem("80 miles","80"));
			ddlRange.SelectedValue = "10";

			// Create Search button
			btnSearch = new Button();
			btnSearch.ID = "btnSearch";
			btnSearch.Text = "Search";
			btnSearch.Click += new EventHandler(btnSearch_Click);
			btnSearch.ToolTip = "Click to perform search";

			// Create Map image
			imgMap = new System.Web.UI.WebControls.Image();
			imgMap.ImageUrl = _MapImageUrl;
			imgMap.ID = "imageMap";
			imgMap.Width = 500;
			imgMap.Height = 500;
			imgMap.BorderWidth = 1;
			imgMap.AlternateText = "Map";
			imgMap.Visible = MapPointProvider.MapRendered;

			// Create search results table:
			tblSearchResults = new Table();
			tblSearchResults.ID = "tblSearchResults";
			tblSearchResults.GridLines = GridLines.Both;
			tblSearchResults.BorderWidth = 2;
			tblSearchResults.CellPadding = 4;
			tblSearchResults.CellSpacing = 0;

			// Create results panel
			pnlResults = new Panel();
			pnlResults.ID = "pnlResults";
			pnlResults.Visible = MapPointProvider.SearchActive;
			pnlResults.Controls.Add(imgMap);
			pnlResults.Controls.Add(new LiteralControl("<br><br>"));
			pnlResults.Controls.Add(tblSearchResults);

			// Create results error panel
			pnlResultsLocationError = new Panel();
			pnlResultsLocationError.ID = "pnlResultsLocationError";
			pnlResultsLocationError.Visible = false;
			pnlResultsLocationError.Controls.Add(new LiteralControl("<b>The specified search location could not be found, please provide an alternate postcode or keyword.</b>"));

			// Add controls to container
//			presentationContainer.Controls.Add(new LiteralControl("<b>Search</b>" +
//				"<table><tr><td>Postcode/Keywords:</td><td>"));
			presentationContainer.Controls.Add(tbKeywords);
//			presentationContainer.Controls.Add(new LiteralControl("</tr><tr><td>Range:</td><td>"));
//			presentationContainer.Controls.Add(ddlRange);
//			presentationContainer.Controls.Add(new LiteralControl("</td></tr><tr><td colspan='2' align='right'>"));
			presentationContainer.Controls.Add(btnSearch);
//			presentationContainer.Controls.Add(new LiteralControl("</td></tr></table>"));
			presentationContainer.Controls.Add(pnlResults);
			presentationContainer.Controls.Add(pnlResultsLocationError);

			// Populate the results table with the current results
			if (MapPointProvider.SearchActive)
				PopulateNearestResults();
		}
		#endregion

		#region Presentation context event handler members
		public void btnSearch_Click(object sender, System.EventArgs e)
		{
			MapPointProvider.Keywords = tbKeywords.Text;
			MapPointProvider.Range = Int32.Parse(ddlRange.SelectedValue);	

			MapPointProvider.FindNearest();

			pnlResults.Visible = MapPointProvider.SearchActive;
			pnlResultsLocationError.Visible = !MapPointProvider.SearchActive;
			imgMap.Visible = MapPointProvider.MapRendered;

			if (MapPointProvider.SearchActive)
				PopulateNearestResults();
		}
		#endregion

		#region Presentation nearest result table population
		private void PopulateNearestResults()
		{
			tblSearchResults.Rows.Clear();

			TableRow tableRow = new TableRow();
			TableHeaderCell tableHeaderCell = new TableHeaderCell();
			tableRow.Cells.Add(tableHeaderCell);
			tableHeaderCell = new TableHeaderCell();
			tableHeaderCell.Text = "Name";
			tableRow.Cells.Add(tableHeaderCell);
			tableHeaderCell = new TableHeaderCell();
			tableHeaderCell.Text = "Address";
			tableRow.Cells.Add(tableHeaderCell);
			tblSearchResults.Rows.Add(tableRow);

			if (0 == MapPointProvider.NearestResults.Length)
			{
				tableRow = new TableRow();
				TableCell tableCell = new TableCell();
				tableCell.ColumnSpan = 4;
				tableCell.Text = "No items were found near the specified location.";
				tableRow.Cells.Add(tableCell);
				tblSearchResults.Rows.Add(tableRow);

				return;
			}

			foreach(NearestResult nearestResult in MapPointProvider.NearestResults)
			{
				tableRow = new TableRow();

				TableCell tableCell = new TableCell();
				tableCell.Text = nearestResult.ResultCount.ToString();
				tableRow.Cells.Add(tableCell);

				tableCell = new TableCell();
				tableCell.Text = nearestResult.Name;
				tableRow.Cells.Add(tableCell);

				tableCell = new TableCell();
				StringBuilder stringBuilder = new StringBuilder();
				if (nearestResult.AddressLine != null)
					stringBuilder.AppendFormat("{0}, ", nearestResult.AddressLine);
				if (nearestResult.PrimaryCity != null)
					stringBuilder.AppendFormat("{0}, ", nearestResult.PrimaryCity);
				if (nearestResult.SecondaryCity != null)
					stringBuilder.AppendFormat("{0}, ", nearestResult.SecondaryCity);
				stringBuilder.Append(nearestResult.PostalCode);
				tableCell.Text = String.Format(stringBuilder.ToString());
				tableRow.Cells.Add(tableCell);

				tblSearchResults.Rows.Add(tableRow);
			}
		}
		#endregion
	}
}
