using System.Configuration;
using System.Xml;

namespace MSIBPlusPack.Web
{
	/// <summary>
	/// Summary description for OutputFilteringGlobalConfigurationHandler.
	/// </summary>
	internal class OutputFilteringConfigurationHandler: IConfigurationSectionHandler
	{
		public OutputFilteringConfigurationHandler()
		{
		}

		public object Create(object parent, object configContext, XmlNode section)
		{
			OutputFilteringGlobalConfigurationData ofgcd = new OutputFilteringGlobalConfigurationData();
			XmlNodeList xnlGlobals = section.SelectNodes("//add");

			foreach(XmlNode xnGlobal in xnlGlobals)
			{
				//OutputFilteringGlobalConfigurationItem ofgci = new OutputFilteringGlobalConfigurationItem();
				
				//ofgci.Name = xnGlobal.Attributes.GetNamedItem("name").Value;
				//ofgci.ActivateOn = xnGlobal.Attributes.GetNamedItem("activateOn").Value;
				/*try 
				{
					ofgci.ActivateOnValue = xnGlobal.Attributes.GetNamedItem("activateOnValue").Value;
				} 
				catch (Exception e){}
				ofgci.Config = ConfigurationSettings.GetConfig(ofgci.Name) as OutputFilteringConfiguration;
				*/
				//ofgcd.OutputFilteringGlobalConfigurationItems.Add(ofgci);
				ofgcd.Add(ParseItem(xnGlobal));
			}
			return ofgcd;
		}


		public OutputFilteringConfiguration ParseItem(XmlNode section)
		{
			OutputFilteringConfiguration toc = new OutputFilteringConfiguration();
			XmlAttributeCollection attrSection = section.Attributes;
			foreach(XmlAttribute attr in attrSection)
			{
				switch(attr.Name)
				{
					case "xhtml":
						if(attr.Value.Equals("true"))
							toc.UseXHTML = true;
						break;
					case "activateOn":
						toc.ActivateOn = attr.Value;
						break;
					case "activateOnValue":
						toc.ActivateValue = attr.Value;
						break;
					case "name":
						toc.Name = attr.Value;
						break;
				}
			}
			
			XmlNodeList xnlTags = section.SelectNodes("./tag");

			foreach(XmlNode xnTag in xnlTags)
			{
				Tag tag = new Tag();
				if(xnTag.Attributes.Count > 0)
				{
					tag.name = xnTag.Attributes.GetNamedItem("name").Value;
					tag.action = GetAction(xnTag.Attributes.GetNamedItem("action").Value);
					tag.data = xnTag.InnerText;
				}
				if(xnTag.HasChildNodes)
				{
					XmlNodeList xnlAttributes = xnTag.SelectNodes("./attribute");

					foreach(XmlNode xnAttr in xnlAttributes)
					{
						TransformAttribute attr = new TransformAttribute();
						attr.name = xnAttr.Attributes.GetNamedItem("name").Value;
						attr.action = GetAction(xnAttr.Attributes.GetNamedItem("action").Value);
					}
														   

				}
				toc.tag.Add(tag);
			}

			//	Add the paths
			XmlNodeList xnlPaths = section.SelectNodes("./path");
			
		
			foreach(XmlNode xnPath  in xnlPaths)
			{
				//TODO add each node to the configuration data class...
				
			}
			
			return toc;
		}

		private Action GetAction(string strAction)
		{
			switch(strAction)
			{
				case "remove":
					return Action.remove;
					//break;
				case "removeAttribute":
					return Action.removeAttribute;
					//break;
				case "replace":
					return Action.replace;
					//break;
				case "replaceWithAttribute":
					return Action.replaceWithAttribute;
					//break;
				case "removeContents":
					return Action.removeContents;
					//break;													
				default:
					return Action.none;
					//break;
			}
		}
	}
}

