using System;
using System.ComponentModel;
using System.Configuration;
using System.Web;
using ioko.ComponentModel.LicenseProvider;

namespace MSIBPlusPack.Web
{
	/// <summary>
	/// Summary description for OutputFilteringModule.
	/// </summary>
	[LicenseProvider(typeof(PlusPackLicenseProvider))]
	public class OutputFilteringModule : IHttpModule
	{
		private OutputFilteringGlobalConfigurationData ofgcd;

		#region Licensing static fields
		private static PlusPackLicense license = null;
		private static DateTime lastDate;
		#endregion

		#region Licensing Test
		private void ValidateLicense()
		{
			try
			{
				bool updateLicense = false;

				if (license == null)
					updateLicense = true;
				else if (lastDate != DateTime.Today)
					updateLicense = true;

				if (updateLicense)
				{
					license = (PlusPackLicense)LicenseManager.Validate(typeof(OutputFilteringModule),this);
					lastDate = DateTime.Today;
				}

				switch(license.Validity)
				{
					case MSIBLicenseValidator.LicenseState.Full:
						return;

					case MSIBLicenseValidator.LicenseState.Trial_Active:
						if (updateLicense)
						{
							TimeSpan span = license.ExpiryDate.Date.Subtract(lastDate);
							int daysRemaining = span.Days + 1;
							if (daysRemaining <= 7)
								throw new Exception(String.Format("Warning: Your trial license of MSIB Plus Pack will run out in {0} days. This component will function normally for the remainder of today.",
									daysRemaining));
						}
						return;

					case MSIBLicenseValidator.LicenseState.Invalid:
					case MSIBLicenseValidator.LicenseState.None:
						break;

					case MSIBLicenseValidator.LicenseState.Trial_Expired:
						throw new Exception("Your trial MSIB Plus Pack trial license has expired. To continue using this component please purchase the relevant license(s).");
				}		
			} 
			catch {}

			throw new Exception("You need a valid MSIB Plus Pack license. Please purchase the relevant license(s).");
		}
		#endregion

		public void Init(HttpApplication context)
		{
			ValidateLicense();

			ofgcd = ConfigurationSettings.GetConfig("OutputFiltering") as OutputFilteringGlobalConfigurationData;

			context.BeginRequest += new EventHandler(OutputFiltering_BeginRequest);			
		}

		private void OutputFiltering_BeginRequest(object sender, EventArgs e)
		{
			
			OutputFilteringConfiguration ofcToApply = new OutputFilteringConfiguration();
			HttpContext ctx = HttpContext.Current;

			bool bActivateFilter = false;
			foreach(OutputFilteringConfiguration ofc in ofgcd.Filters)
			{
				
				
			
				switch(ofc.ActivateOn)
				{

					case "queryString":
						
						if(ctx.Request.QueryString[ofc.ActivateValue] != null)
						{
							MergeOutputConfiguration(ofc, ofcToApply);
							bActivateFilter = true;
						}
						break;
					case "hostHeader":
						if(ctx.Request.ServerVariables["HTTP_HOST"].Equals(ofc.ActivateValue))
						{
							MergeOutputConfiguration(ofc, ofcToApply);
							bActivateFilter = true;
						}
						break;
					case "always":
						MergeOutputConfiguration(ofc, ofcToApply);
						bActivateFilter = true;
						break;

				}
			}

			if(bActivateFilter)
			{
				
				ctx.Response.Filter = new OutputFilteringStream(ctx.Response.Filter, ofcToApply);
			}

		}

		//	As we are looping twice, one for normal tags, once for XHTML, we merge so nbsp's etc aren't converted twice
		private void MergeOutputConfiguration(OutputFilteringConfiguration ofcToAdd, OutputFilteringConfiguration ofcMaster)
		{
			// TODO merge the paths list
			ofcMaster.tag.AddRange(ofcToAdd.tag);
			ofcMaster.attribute.AddRange(ofcToAdd.attribute);
			if(ofcMaster.UseXHTML || ofcToAdd.UseXHTML)
				ofcMaster.UseXHTML = true;			
		}

		public void Dispose()
		{
			ofgcd = null;
		}		
	}
}

