using System;
using System.Collections;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Web.UI;
using System.Xml;
//using Sgml;

namespace MSIBPlusPack.Web
{
	/// <summary>
	/// Summary description for OutputFilteringStream.
	/// </summary>
	public class OutputFilteringStream : Stream
	{
		private Stream _responseStream;
		//private long _length;
		private long _position;
		byte[] cachedOutput;
		OutputFilteringConfiguration toc;

		public OutputFilteringStream(Stream responseStream, OutputFilteringConfiguration appConfig)
		{
			Debug.Write("OutputFilteringStream constructor called with responsestream of length ");
			_responseStream = responseStream;
			toc = appConfig;
			//_length = responseStream.Length;
			//_position = responseStream.Position;
		}

		public override bool CanRead
		{
			get	{ return true;}//_responseStream.CanRead;}
		}

		public override bool CanSeek
		{
			get{ return true;}//_responseStream.CanSeek;}
		}

		public override bool CanWrite
		{
			get{ return true;}//_responseStream.CanWrite;}
		}

		public override long Length
		{
			get{ return 0;}
		}

		public override long Position
		{
			get
			{
				return _position;
			}
			set
			{
				_position = value;
			}
		}

		public override long Seek(long offset, SeekOrigin origin)
		{
			throw new NotSupportedException();
			//return _responseStream.Seek(offset, origin);
		}

		public override void SetLength(long value)
		{
			throw new NotSupportedException();
			//_responseStream.SetLength(value);
		}

		public override void Close()
		{
			//			//_responseStream.Write(buffer, offset, count);
			
			MemoryStream ms = new MemoryStream(cachedOutput.Length);
			object sw;
			XmlTextWriter xtw = null;
			HtmlTextWriter htw = null;
			if(toc.UseXHTML)
			{
				xtw = new XmlTextWriter(new StreamWriter(ms));
				xtw.WriteStartDocument();
				sw = xtw;
			}
			else
			{
				htw = new HtmlTextWriter(new StreamWriter(ms));//, System.Text.Encoding.Default));
				sw = htw;
			}
			Debug.Write("Encoding of the HtmlTextWriter stream is " + GetEncoding(sw).EncodingName + " codepage " + GetEncoding(sw).CodePage);

			char[] cbuffer = new char[cachedOutput.Length];
			//byte[] cbuffer = new byte[cachedOutput.Length];
			GetEncoding(sw).GetChars(cachedOutput, 0, cachedOutput.Length, cbuffer,0);
			
			String s = new String(cbuffer);
			s.Trim();
			SgmlReader sr = new SgmlReader();
			sr.DocType = "HTML";
			sr.InputStream = new StringReader(s);

			while(sr.Read())
			{
				//bool bWriteElement = true;
				switch(sr.NodeType)
				{
					case XmlNodeType.Element:
						string strName = sr.Name;
						bool bIsEmptyElement = sr.IsEmptyElement;
						//System.Diagnostics.Debug.Write("Got element " + sr.Name + " with " + sr.AttributeCount.ToString() + " attributes");//sw.Write("ELEMENT(" + sr.Name + ")");
						bool bProcessAttributes = true;						
						ArrayList attributes = null;

						foreach(Tag tag in toc.tag)
						{
							bool bBreakOutOfLoop = false;
							if(sr.Name != null)
							{
								if(sr.Name.Equals(tag.name))
								{
									//bTagMatch = true;
									switch(tag.action)
									{
										case Action.remove:
											bProcessAttributes = false;
											bBreakOutOfLoop = true;
											break;
										case Action.replaceWithAttribute:
											bProcessAttributes = false;
											if(sr.HasAttributes)
											{
												Write(sw, sr.GetAttribute(tag.data));
											}
										
											break;
										case Action.replace:
											//sw.WriteBeginTag(tag.data);
											strName = tag.data;
											//bTagMatch = false;
											break;
										case Action.removeContents:
											bProcessAttributes = false;
											sr.ReadOuterXml();
											break;
									}

									if(bProcessAttributes)
									{
										if(tag.attribute != null)
										{
											attributes = tag.attribute;
										}
									}
									if (bBreakOutOfLoop)
									{
										//break;
									}
								}
							}
						}
						if(attributes == null)
							attributes = toc.attribute;
						else
							attributes.AddRange(toc.attribute);
						if(bProcessAttributes)
						{
							
							if(sw is HtmlTextWriter)
								htw.WriteBeginTag(strName);
							else
								xtw.WriteStartElement(strName);

									
									
								
							//sr.MoveToFirstAttribute();
							//int i= 0;
							int iAttrCount = sr.AttributeCount;
							for(int i=0; i<iAttrCount; i++)
							{			
								bool bShowAttribute = true;
								sr.MoveToAttribute(i);
								string strAttrName = sr.Name;
								if(attributes != null)
								{
									foreach(TransformAttribute attr in attributes)
									{
										if(attr.name.Equals(strAttrName))
										{
											switch(attr.action)
											{
												case Action.remove:
													bShowAttribute = false;
													break;
												case Action.replace:
													strAttrName = attr.data;
													break;
											}
											break;
										}											
									}
								}


								sr.ReadAttributeValue();
								if(bShowAttribute)
								{
									if(sw is HtmlTextWriter)
										htw.WriteAttribute(strAttrName, sr.Value);
									else if(sw is XmlTextWriter)
									{
										//XmlTextWriter xtw = sw as XmlTextWriter;
								

										//xtw.WriteAttributeString(strAttrName, sr.Value);
										xtw.WriteStartAttribute(strAttrName, null);
										xtw.WriteString(sr.Value);
										xtw.WriteEndAttribute();
									}
								}
										
							}		
							if(sw is HtmlTextWriter)
								Write(sw, ">");
							else if(sw is XmlTextWriter && bIsEmptyElement)
								xtw.WriteEndElement();							
						}
						break;
					case XmlNodeType.EndElement:
						Debug.Write("Got an end element: "+ sr.Name);
						bool bEndTagMatch = false;
						foreach(Tag tag in toc.tag)
						{
							if(sr.Name.Equals(tag.name))
							{
								bEndTagMatch = true;
								switch(tag.action)
								{
									case Action.remove:
										break;
									case Action.replace:
										if(sw is HtmlTextWriter)
											htw.WriteEndTag(tag.data);
										else if(sw is XmlTextWriter)
											xtw.WriteEndElement();
										break;
								}
								break;
							}
						}
						if(!bEndTagMatch)
						{
							if(sw is HtmlTextWriter)
								htw.WriteEndTag(sr.Name);
							else if(sw is XmlTextWriter)
								xtw.WriteEndElement();
						}
						break;
					case XmlNodeType.ProcessingInstruction:
						Debug.Write("Got a processing instruction: " + sr.Value);
						// an XML PI will already be written for this page - don't write it again
						if(!sr.Name.Equals("xml"))
							Write(sw, sr.ReadOuterXml());
						break;

					case XmlNodeType.Text:
						Debug.Write("Got text: " + sr.Value);						
						Write(sw, sr.Value);
						break;
					case XmlNodeType.Comment:
						Debug.Write("Got a comment: " + sr.Value);
						if(sw is XmlTextWriter)
							xtw.WriteComment(sr.Value);
						else
							Write(sw, "<!--" + sr.Value + "-->");
						break;
					case XmlNodeType.Whitespace:
						Write(sw, sr.Value);
						break;
					case XmlNodeType.EntityReference:
						Debug.Write("Got an entity ref: " + sr.Name);
						break;
					case XmlNodeType.CDATA:
						if(sw is XmlTextWriter)
							xtw.WriteString(sr.Value);
						else
							htw.Write(sr.Value);
						break;
					case XmlNodeType.DocumentType:
						if(!(sw is XmlTextWriter))
							//xtw.WriteDocType(sr.Name, sr.PublicIdentifier, sr.Value, null);
							//else
							Write(sw, sr.ReadOuterXml());
						break;
					default:
						Debug.Write("Got a node of type " + sr.NodeType.ToString());
						//sw.Write(sr.ReadString());
						break;
				}
			}
			sr.Close();
			if(xtw != null)
				xtw.WriteEndDocument();
			WriterFlush(sw);
			//			System.Text.Encoder enc = System.Text.UnicodeEncoding.Default.GetEncoder();
			//
			//			//ms.WriteTo(_responseStream);
			//			_responseStream.Write(ms.GetBuffer(), 0, (int)ms.Length);
			//			int iChunks = (cachedOutput.Length / int.MaxValue);
			//			int iRemainder = cachedOutput.Length % int.MaxValue;
			//			for(int i=0; i<= iChunks; i++)
			//				_responseStream.Write(cachedOutput, i * int.MaxValue, i == iChunks ? iRemainder : int.MaxValue);
			//_responseStream.Write(cachedOutput, 0, cachedOutput.Length);
			_responseStream.Write(ms.GetBuffer(), 0, ms.GetBuffer().Length);
			_responseStream.Close();
		}

		private void Write(object writer, string data)
		{
			if(writer is XmlTextWriter)
				((XmlTextWriter)writer).WriteRaw(data);
			else
				((HtmlTextWriter)writer).Write(data);
		}

		private Encoding GetEncoding(object writer)
		{
			if(writer is XmlTextWriter)
				return Encoding.Default;
			else
				return ((HtmlTextWriter)writer).Encoding;
		}

		private void WriterFlush(object writer)
		{
			if(writer is XmlTextWriter)
				((XmlTextWriter)writer).Flush();
			else if(writer is HtmlTextWriter)
				((HtmlTextWriter)writer).Flush();

		}
		
		public override void Flush()
		{
			_responseStream.Flush();
		}

		public override int Read(byte[] buffer, int offset, int count)
		{
			return _responseStream.Read(buffer, offset, count);
		}

		public override void Write(byte[] buffer, int offset, int count)
		{
			Debug.Write("Got a write with " + buffer.Length.ToString() + " bytes in it and a count of " + count.ToString() + " at offset " + offset);
			//System.Diagnostics.Debug.Write("ResponseStream is of length: " + _responseStream.Get
			if(cachedOutput == null)
			{
				cachedOutput = new byte[count];
				Buffer.BlockCopy(buffer, offset, cachedOutput, 0, count);
				//buffer.CopyTo(cachedOutput, 0);
			}
			else
			{
				Debug.Write("Got another write!");

				int iOriginalLength = cachedOutput.Length;
				byte[] cachedOutputCopy = new byte[cachedOutput.Length + buffer.Length];
				Buffer.BlockCopy(cachedOutput, 0, cachedOutputCopy,0, iOriginalLength);
				Buffer.BlockCopy(buffer, 0, cachedOutputCopy, iOriginalLength, buffer.Length);

				cachedOutput = cachedOutputCopy;
			}
		}


	}
}

