//using Sgml;
using System;
using System.IO;
using System.Xml;

namespace MSIBPlusPack.Web
{
	/// <summary>
	/// Helper class to allow string processing using SGMLReader/Parser
	/// </summary>
	internal class SGMLReaderHelper
	{
		private string _errors;

		public string Errors
		{
			get { return _errors; }
			set { _errors = value; }
		}

		public SGMLReaderHelper()
		{
		}

		public string ProcessString(string strInputHtml)
		{
			string strOutputXhtml = String.Empty;
			SgmlReader reader = new SgmlReader();
			reader.DocType = "HTML";
			StringReader sr = new StringReader(strInputHtml);
			reader.InputStream = sr;
			StringWriter sw = new StringWriter();
			XmlTextWriter w = new XmlTextWriter(sw);
			reader.Read();
			while (!reader.EOF)
			{
				w.WriteNode(reader, true);
			}
			w.Flush();
			w.Close();
			this.Errors = reader.ErrorLog;
			return sw.ToString();
		}
	}
}
