using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;
using Mcms.SiteManager;

namespace Mcms.SiteManager.Console
{
	/// <summary>
	/// Summary description for MCMSSiteManagerConsole.
	/// </summary>
	public class MCMSSiteManagerConsole : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button CreateRoleButton;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.TextBox DomainTextBox;
		private System.Windows.Forms.TextBox UserNameTextBox;
		private System.Windows.Forms.TextBox PasswordTextBox;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.TextBox RoleNameTextBox;
		private System.Windows.Forms.ComboBox RoleTypeComboBox;
		private System.Windows.Forms.GroupBox groupBox3;
		private System.Windows.Forms.TextBox RoleGuidTextBox;
		private System.Windows.Forms.Button AddRoleToContainerButton;
		private System.Windows.Forms.TextBox ContainerGuidTextBox;
		private System.Windows.Forms.TextBox MessagesLabel;
		private System.Windows.Forms.GroupBox groupBox4;
		private System.Windows.Forms.TextBox RoleGuidTextBox2;
		private System.Windows.Forms.Button ListUsersButton;
		private System.Windows.Forms.GroupBox groupBox5;
		private System.Windows.Forms.TextBox UserWinNtNameTextBox;
		private System.Windows.Forms.TextBox RoleGuidTextBox3;
		private System.Windows.Forms.Button AddUserToRoleButton;
		private System.Windows.Forms.GroupBox groupBox6;
		private System.Windows.Forms.TextBox ContainerGuidTextBox2;
		private System.Windows.Forms.Button ListRolesForContainerButton;
		private System.Windows.Forms.Button ConnectToServerButton;
		private System.Windows.Forms.GroupBox groupBox7;
		private System.Windows.Forms.Button ListAllRolesButton;
		private System.Windows.Forms.ComboBox RoleTypeComboBox2;
		private System.Windows.Forms.GroupBox groupBox8;
		private System.Windows.Forms.TextBox RoleGuidTextBox4;
		private System.Windows.Forms.Button GetRoleButton;
		private Security security;
		private string CRLF = System.Environment.NewLine;
		private System.Windows.Forms.Button RemoveRoleFromContainerButton;
		private System.Windows.Forms.Button RemoveUserFromRoleButton;
		private System.Windows.Forms.GroupBox groupBox9;
		private System.Windows.Forms.TextBox RoleGuidTextBox5;
		private System.Windows.Forms.Button DeleteRoleButton;
		private string CRLF2 = System.Environment.NewLine+System.Environment.NewLine;
		public MCMSSiteManagerConsole()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			CustomEventHandlers();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.CreateRoleButton = new System.Windows.Forms.Button();
			this.DomainTextBox = new System.Windows.Forms.TextBox();
			this.UserNameTextBox = new System.Windows.Forms.TextBox();
			this.PasswordTextBox = new System.Windows.Forms.TextBox();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.RoleTypeComboBox = new System.Windows.Forms.ComboBox();
			this.RoleNameTextBox = new System.Windows.Forms.TextBox();
			this.groupBox3 = new System.Windows.Forms.GroupBox();
			this.ContainerGuidTextBox = new System.Windows.Forms.TextBox();
			this.RoleGuidTextBox = new System.Windows.Forms.TextBox();
			this.AddRoleToContainerButton = new System.Windows.Forms.Button();
			this.MessagesLabel = new System.Windows.Forms.TextBox();
			this.groupBox4 = new System.Windows.Forms.GroupBox();
			this.RoleGuidTextBox2 = new System.Windows.Forms.TextBox();
			this.ListUsersButton = new System.Windows.Forms.Button();
			this.groupBox5 = new System.Windows.Forms.GroupBox();
			this.UserWinNtNameTextBox = new System.Windows.Forms.TextBox();
			this.RoleGuidTextBox3 = new System.Windows.Forms.TextBox();
			this.AddUserToRoleButton = new System.Windows.Forms.Button();
			this.groupBox6 = new System.Windows.Forms.GroupBox();
			this.ContainerGuidTextBox2 = new System.Windows.Forms.TextBox();
			this.ListRolesForContainerButton = new System.Windows.Forms.Button();
			this.ConnectToServerButton = new System.Windows.Forms.Button();
			this.groupBox7 = new System.Windows.Forms.GroupBox();
			this.ListAllRolesButton = new System.Windows.Forms.Button();
			this.RoleTypeComboBox2 = new System.Windows.Forms.ComboBox();
			this.groupBox8 = new System.Windows.Forms.GroupBox();
			this.RoleGuidTextBox4 = new System.Windows.Forms.TextBox();
			this.GetRoleButton = new System.Windows.Forms.Button();
			this.RemoveRoleFromContainerButton = new System.Windows.Forms.Button();
			this.RemoveUserFromRoleButton = new System.Windows.Forms.Button();
			this.groupBox9 = new System.Windows.Forms.GroupBox();
			this.RoleGuidTextBox5 = new System.Windows.Forms.TextBox();
			this.DeleteRoleButton = new System.Windows.Forms.Button();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.groupBox3.SuspendLayout();
			this.groupBox4.SuspendLayout();
			this.groupBox5.SuspendLayout();
			this.groupBox6.SuspendLayout();
			this.groupBox7.SuspendLayout();
			this.groupBox8.SuspendLayout();
			this.groupBox9.SuspendLayout();
			this.SuspendLayout();
			// 
			// CreateRoleButton
			// 
			this.CreateRoleButton.Location = new System.Drawing.Point(320, 16);
			this.CreateRoleButton.Name = "CreateRoleButton";
			this.CreateRoleButton.TabIndex = 8;
			this.CreateRoleButton.Text = "Create";
			this.CreateRoleButton.Click += new System.EventHandler(this.CreateRoleButton_Click);
			// 
			// DomainTextBox
			// 
			this.DomainTextBox.Location = new System.Drawing.Point(16, 16);
			this.DomainTextBox.Name = "DomainTextBox";
			this.DomainTextBox.Size = new System.Drawing.Size(152, 20);
			this.DomainTextBox.TabIndex = 1;
			this.DomainTextBox.Text = "domain";
			// 
			// UserNameTextBox
			// 
			this.UserNameTextBox.Location = new System.Drawing.Point(168, 16);
			this.UserNameTextBox.Name = "UserNameTextBox";
			this.UserNameTextBox.Size = new System.Drawing.Size(152, 20);
			this.UserNameTextBox.TabIndex = 2;
			this.UserNameTextBox.Text = "user name";
			// 
			// PasswordTextBox
			// 
			this.PasswordTextBox.Location = new System.Drawing.Point(320, 16);
			this.PasswordTextBox.Name = "PasswordTextBox";
			this.PasswordTextBox.Size = new System.Drawing.Size(128, 20);
			this.PasswordTextBox.TabIndex = 3;
			this.PasswordTextBox.Text = "password";
			this.PasswordTextBox.Enter += new System.EventHandler(this.PasswordTextBox_Enter);
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.ConnectToServerButton);
			this.groupBox1.Controls.Add(this.DomainTextBox);
			this.groupBox1.Controls.Add(this.UserNameTextBox);
			this.groupBox1.Controls.Add(this.PasswordTextBox);
			this.groupBox1.Location = new System.Drawing.Point(0, 0);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(536, 48);
			this.groupBox1.TabIndex = 4;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Connect to Server";
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.Add(this.RoleTypeComboBox);
			this.groupBox2.Controls.Add(this.RoleNameTextBox);
			this.groupBox2.Controls.Add(this.CreateRoleButton);
			this.groupBox2.Location = new System.Drawing.Point(0, 48);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(536, 48);
			this.groupBox2.TabIndex = 5;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Create Security Role";
			// 
			// RoleTypeComboBox
			// 
			this.RoleTypeComboBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.RoleTypeComboBox.Location = new System.Drawing.Point(168, 16);
			this.RoleTypeComboBox.Name = "RoleTypeComboBox";
			this.RoleTypeComboBox.Size = new System.Drawing.Size(152, 21);
			this.RoleTypeComboBox.TabIndex = 7;
			// 
			// RoleNameTextBox
			// 
			this.RoleNameTextBox.Location = new System.Drawing.Point(16, 16);
			this.RoleNameTextBox.Name = "RoleNameTextBox";
			this.RoleNameTextBox.Size = new System.Drawing.Size(152, 20);
			this.RoleNameTextBox.TabIndex = 6;
			this.RoleNameTextBox.Text = "role name";
			// 
			// groupBox3
			// 
			this.groupBox3.Controls.Add(this.RemoveRoleFromContainerButton);
			this.groupBox3.Controls.Add(this.ContainerGuidTextBox);
			this.groupBox3.Controls.Add(this.RoleGuidTextBox);
			this.groupBox3.Controls.Add(this.AddRoleToContainerButton);
			this.groupBox3.Location = new System.Drawing.Point(0, 96);
			this.groupBox3.Name = "groupBox3";
			this.groupBox3.Size = new System.Drawing.Size(536, 48);
			this.groupBox3.TabIndex = 6;
			this.groupBox3.TabStop = false;
			this.groupBox3.Text = "Add / Remove Security Role to / from Container";
			// 
			// ContainerGuidTextBox
			// 
			this.ContainerGuidTextBox.Location = new System.Drawing.Point(168, 16);
			this.ContainerGuidTextBox.Name = "ContainerGuidTextBox";
			this.ContainerGuidTextBox.Size = new System.Drawing.Size(152, 20);
			this.ContainerGuidTextBox.TabIndex = 10;
			this.ContainerGuidTextBox.Text = "container guid";
			// 
			// RoleGuidTextBox
			// 
			this.RoleGuidTextBox.Location = new System.Drawing.Point(16, 16);
			this.RoleGuidTextBox.Name = "RoleGuidTextBox";
			this.RoleGuidTextBox.Size = new System.Drawing.Size(152, 20);
			this.RoleGuidTextBox.TabIndex = 9;
			this.RoleGuidTextBox.Text = "role guid";
			// 
			// AddRoleToContainerButton
			// 
			this.AddRoleToContainerButton.Location = new System.Drawing.Point(320, 16);
			this.AddRoleToContainerButton.Name = "AddRoleToContainerButton";
			this.AddRoleToContainerButton.TabIndex = 11;
			this.AddRoleToContainerButton.Text = "Add";
			this.AddRoleToContainerButton.Click += new System.EventHandler(this.AddRoleToContainerButton_Click);
			// 
			// MessagesLabel
			// 
			this.MessagesLabel.AcceptsReturn = true;
			this.MessagesLabel.AcceptsTab = true;
			this.MessagesLabel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.MessagesLabel.Location = new System.Drawing.Point(0, 432);
			this.MessagesLabel.Multiline = true;
			this.MessagesLabel.Name = "MessagesLabel";
			this.MessagesLabel.ReadOnly = true;
			this.MessagesLabel.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.MessagesLabel.Size = new System.Drawing.Size(536, 160);
			this.MessagesLabel.TabIndex = 7;
			this.MessagesLabel.Text = "";
			// 
			// groupBox4
			// 
			this.groupBox4.Controls.Add(this.RoleGuidTextBox2);
			this.groupBox4.Controls.Add(this.ListUsersButton);
			this.groupBox4.Location = new System.Drawing.Point(0, 144);
			this.groupBox4.Name = "groupBox4";
			this.groupBox4.Size = new System.Drawing.Size(536, 48);
			this.groupBox4.TabIndex = 8;
			this.groupBox4.TabStop = false;
			this.groupBox4.Text = "List Users for Role";
			// 
			// RoleGuidTextBox2
			// 
			this.RoleGuidTextBox2.Location = new System.Drawing.Point(16, 16);
			this.RoleGuidTextBox2.Name = "RoleGuidTextBox2";
			this.RoleGuidTextBox2.Size = new System.Drawing.Size(152, 20);
			this.RoleGuidTextBox2.TabIndex = 9;
			this.RoleGuidTextBox2.Text = "role guid";
			// 
			// ListUsersButton
			// 
			this.ListUsersButton.Location = new System.Drawing.Point(168, 16);
			this.ListUsersButton.Name = "ListUsersButton";
			this.ListUsersButton.TabIndex = 11;
			this.ListUsersButton.Text = "List Users";
			this.ListUsersButton.Click += new System.EventHandler(this.ListUsersButton_Click);
			// 
			// groupBox5
			// 
			this.groupBox5.Controls.Add(this.RemoveUserFromRoleButton);
			this.groupBox5.Controls.Add(this.UserWinNtNameTextBox);
			this.groupBox5.Controls.Add(this.RoleGuidTextBox3);
			this.groupBox5.Controls.Add(this.AddUserToRoleButton);
			this.groupBox5.Location = new System.Drawing.Point(0, 184);
			this.groupBox5.Name = "groupBox5";
			this.groupBox5.Size = new System.Drawing.Size(536, 48);
			this.groupBox5.TabIndex = 9;
			this.groupBox5.TabStop = false;
			this.groupBox5.Text = "Add / Remove User to / from Role";
			// 
			// UserWinNtNameTextBox
			// 
			this.UserWinNtNameTextBox.Location = new System.Drawing.Point(168, 16);
			this.UserWinNtNameTextBox.Name = "UserWinNtNameTextBox";
			this.UserWinNtNameTextBox.Size = new System.Drawing.Size(152, 20);
			this.UserWinNtNameTextBox.TabIndex = 10;
			this.UserWinNtNameTextBox.Text = "WinNT://Domain/User";
			// 
			// RoleGuidTextBox3
			// 
			this.RoleGuidTextBox3.Location = new System.Drawing.Point(16, 16);
			this.RoleGuidTextBox3.Name = "RoleGuidTextBox3";
			this.RoleGuidTextBox3.Size = new System.Drawing.Size(152, 20);
			this.RoleGuidTextBox3.TabIndex = 9;
			this.RoleGuidTextBox3.Text = "role guid";
			// 
			// AddUserToRoleButton
			// 
			this.AddUserToRoleButton.Location = new System.Drawing.Point(320, 16);
			this.AddUserToRoleButton.Name = "AddUserToRoleButton";
			this.AddUserToRoleButton.TabIndex = 11;
			this.AddUserToRoleButton.Text = "Add";
			this.AddUserToRoleButton.Click += new System.EventHandler(this.AddUserToRoleButton_Click);
			// 
			// groupBox6
			// 
			this.groupBox6.Controls.Add(this.ContainerGuidTextBox2);
			this.groupBox6.Controls.Add(this.ListRolesForContainerButton);
			this.groupBox6.Location = new System.Drawing.Point(0, 232);
			this.groupBox6.Name = "groupBox6";
			this.groupBox6.Size = new System.Drawing.Size(536, 48);
			this.groupBox6.TabIndex = 10;
			this.groupBox6.TabStop = false;
			this.groupBox6.Text = "List Container Roles";
			// 
			// ContainerGuidTextBox2
			// 
			this.ContainerGuidTextBox2.Location = new System.Drawing.Point(16, 16);
			this.ContainerGuidTextBox2.Name = "ContainerGuidTextBox2";
			this.ContainerGuidTextBox2.Size = new System.Drawing.Size(152, 20);
			this.ContainerGuidTextBox2.TabIndex = 9;
			this.ContainerGuidTextBox2.Text = "container guid";
			// 
			// ListRolesForContainerButton
			// 
			this.ListRolesForContainerButton.Location = new System.Drawing.Point(168, 16);
			this.ListRolesForContainerButton.Name = "ListRolesForContainerButton";
			this.ListRolesForContainerButton.TabIndex = 11;
			this.ListRolesForContainerButton.Text = "List Roles";
			this.ListRolesForContainerButton.Click += new System.EventHandler(this.ListRolesForContainerButton_Click);
			// 
			// ConnectToServerButton
			// 
			this.ConnectToServerButton.Location = new System.Drawing.Point(448, 16);
			this.ConnectToServerButton.Name = "ConnectToServerButton";
			this.ConnectToServerButton.TabIndex = 4;
			this.ConnectToServerButton.Text = "Connect";
			this.ConnectToServerButton.Click += new System.EventHandler(this.ConnectToServerButton_Click);
			// 
			// groupBox7
			// 
			this.groupBox7.Controls.Add(this.RoleTypeComboBox2);
			this.groupBox7.Controls.Add(this.ListAllRolesButton);
			this.groupBox7.Location = new System.Drawing.Point(0, 280);
			this.groupBox7.Name = "groupBox7";
			this.groupBox7.Size = new System.Drawing.Size(536, 48);
			this.groupBox7.TabIndex = 11;
			this.groupBox7.TabStop = false;
			this.groupBox7.Text = "List All Roles";
			// 
			// ListAllRolesButton
			// 
			this.ListAllRolesButton.Location = new System.Drawing.Point(168, 16);
			this.ListAllRolesButton.Name = "ListAllRolesButton";
			this.ListAllRolesButton.TabIndex = 11;
			this.ListAllRolesButton.Text = "List Roles";
			this.ListAllRolesButton.Click += new System.EventHandler(this.ListAllRolesButton_Click);
			// 
			// RoleTypeComboBox2
			// 
			this.RoleTypeComboBox2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.RoleTypeComboBox2.Location = new System.Drawing.Point(16, 16);
			this.RoleTypeComboBox2.Name = "RoleTypeComboBox2";
			this.RoleTypeComboBox2.Size = new System.Drawing.Size(152, 21);
			this.RoleTypeComboBox2.TabIndex = 12;
			// 
			// groupBox8
			// 
			this.groupBox8.Controls.Add(this.RoleGuidTextBox4);
			this.groupBox8.Controls.Add(this.GetRoleButton);
			this.groupBox8.Location = new System.Drawing.Point(0, 328);
			this.groupBox8.Name = "groupBox8";
			this.groupBox8.Size = new System.Drawing.Size(536, 48);
			this.groupBox8.TabIndex = 12;
			this.groupBox8.TabStop = false;
			this.groupBox8.Text = "Get Role Name";
			// 
			// RoleGuidTextBox4
			// 
			this.RoleGuidTextBox4.Location = new System.Drawing.Point(16, 16);
			this.RoleGuidTextBox4.Name = "RoleGuidTextBox4";
			this.RoleGuidTextBox4.Size = new System.Drawing.Size(152, 20);
			this.RoleGuidTextBox4.TabIndex = 9;
			this.RoleGuidTextBox4.Text = "role guid";
			// 
			// GetRoleButton
			// 
			this.GetRoleButton.Location = new System.Drawing.Point(168, 16);
			this.GetRoleButton.Name = "GetRoleButton";
			this.GetRoleButton.TabIndex = 11;
			this.GetRoleButton.Text = "Get Role";
			this.GetRoleButton.Click += new System.EventHandler(this.GetRoleButton_Click);
			// 
			// RemoveRoleFromContainerButton
			// 
			this.RemoveRoleFromContainerButton.Location = new System.Drawing.Point(392, 16);
			this.RemoveRoleFromContainerButton.Name = "RemoveRoleFromContainerButton";
			this.RemoveRoleFromContainerButton.TabIndex = 12;
			this.RemoveRoleFromContainerButton.Text = "Remove";
			this.RemoveRoleFromContainerButton.Click += new System.EventHandler(this.RemoveRoleFromContainerButton_Click);
			// 
			// RemoveUserFromRoleButton
			// 
			this.RemoveUserFromRoleButton.Location = new System.Drawing.Point(392, 16);
			this.RemoveUserFromRoleButton.Name = "RemoveUserFromRoleButton";
			this.RemoveUserFromRoleButton.TabIndex = 13;
			this.RemoveUserFromRoleButton.Text = "Remove";
			this.RemoveUserFromRoleButton.Click += new System.EventHandler(this.RemoveUserFromRoleButton_Click);
			// 
			// groupBox9
			// 
			this.groupBox9.Controls.Add(this.RoleGuidTextBox5);
			this.groupBox9.Controls.Add(this.DeleteRoleButton);
			this.groupBox9.Location = new System.Drawing.Point(0, 376);
			this.groupBox9.Name = "groupBox9";
			this.groupBox9.Size = new System.Drawing.Size(536, 48);
			this.groupBox9.TabIndex = 13;
			this.groupBox9.TabStop = false;
			this.groupBox9.Text = "Delete Security Role";
			// 
			// RoleGuidTextBox5
			// 
			this.RoleGuidTextBox5.Location = new System.Drawing.Point(16, 16);
			this.RoleGuidTextBox5.Name = "RoleGuidTextBox5";
			this.RoleGuidTextBox5.Size = new System.Drawing.Size(152, 20);
			this.RoleGuidTextBox5.TabIndex = 6;
			this.RoleGuidTextBox5.Text = "role guid";
			// 
			// DeleteRoleButton
			// 
			this.DeleteRoleButton.Location = new System.Drawing.Point(168, 16);
			this.DeleteRoleButton.Name = "DeleteRoleButton";
			this.DeleteRoleButton.TabIndex = 8;
			this.DeleteRoleButton.Text = "Delete";
			this.DeleteRoleButton.Click += new System.EventHandler(this.DeleteRoleButton_Click);
			// 
			// MCMSSiteManagerConsole
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(536, 597);
			this.Controls.Add(this.groupBox9);
			this.Controls.Add(this.groupBox8);
			this.Controls.Add(this.groupBox7);
			this.Controls.Add(this.groupBox6);
			this.Controls.Add(this.groupBox5);
			this.Controls.Add(this.groupBox4);
			this.Controls.Add(this.MessagesLabel);
			this.Controls.Add(this.groupBox3);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.groupBox1);
			this.Name = "MCMSSiteManagerConsole";
			this.Text = "MCMS Site Manager Console";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.MCMSSiteManagerConsole_Closing);
			this.Load += new System.EventHandler(this.MCMSSiteManagerConsole_Load);
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.groupBox3.ResumeLayout(false);
			this.groupBox4.ResumeLayout(false);
			this.groupBox5.ResumeLayout(false);
			this.groupBox6.ResumeLayout(false);
			this.groupBox7.ResumeLayout(false);
			this.groupBox8.ResumeLayout(false);
			this.groupBox9.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MCMSSiteManagerConsole());
		}



		private void CreateRoleButton_Click(object sender, System.EventArgs e)
		{
			string newRoleGuid = security.CreateRole(RoleNameTextBox.Text,(Security.RoleType)Enum.Parse(typeof(Security.RoleType),RoleTypeComboBox.SelectedItem.ToString()));
			MessagesLabel.AppendText(newRoleGuid+CRLF2);
		}

		private void PasswordTextBox_Enter(object sender, System.EventArgs e)
		{
			PasswordTextBox.PasswordChar = '*';
			PasswordTextBox.Select();

		}
		private void TextBox_Enter(object sender, System.EventArgs e)
		{
			TextBox textBox = (TextBox)sender;
			textBox.Select();

		}
		private void CustomEventHandlers()
		{
			this.DomainTextBox.Enter += new EventHandler(TextBox_Enter);
			this.UserNameTextBox.Enter += new EventHandler(TextBox_Enter);
			//this.PasswordTextBox.Enter += new EventHandler(TextBox_Enter);
			this.RoleNameTextBox.Enter += new EventHandler(TextBox_Enter);
			this.ContainerGuidTextBox.Enter  += new EventHandler(TextBox_Enter);
			this.RoleGuidTextBox.Enter  += new EventHandler(TextBox_Enter);
		}

		private void MCMSSiteManagerConsole_Load(object sender, System.EventArgs e)
		{
			RoleTypeComboBox.Items.AddRange(Enum.GetNames(typeof(Security.RoleType)));
			RoleTypeComboBox2.Items.AddRange(Enum.GetNames(typeof(Security.RoleType)));
			
		}

		private void AddRoleToContainerButton_Click(object sender, System.EventArgs e)
		{
			security.AddRoleToContainer(ContainerGuidTextBox.Text,RoleGuidTextBox.Text);
			MessagesLabel.AppendText( "Done."+CRLF2);
		}

		private void ListUsersButton_Click(object sender, System.EventArgs e)
		{
			string[] userList = security.ListUsersForRole(RoleGuidTextBox2.Text);
			if (userList==null)
				MessagesLabel.AppendText( "No items."+CRLF2);
			else
				MessagesLabel.AppendText( string.Join(CRLF, userList)+CRLF2);
		}

		private void AddUserToRoleButton_Click(object sender, System.EventArgs e)
		{
			security.AddUserToRole(RoleGuidTextBox3.Text,UserWinNtNameTextBox.Text);
			MessagesLabel.AppendText("Done."+CRLF2);
		}

		private void ListRolesForContainerButton_Click(object sender, System.EventArgs e)
		{
			string[] roleList = security.ListContainerRoles(ContainerGuidTextBox2.Text);
			if (roleList==null)
				MessagesLabel.AppendText( "No items."+CRLF2);
			else
				MessagesLabel.AppendText( string.Join(CRLF, roleList)+CRLF2);
		}

		private void MCMSSiteManagerConsole_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			Application.Exit();
		}

		private void ConnectToServerButton_Click(object sender, System.EventArgs e)
		{
			security = new Security(Environment.MachineName,DomainTextBox.Text, UserNameTextBox.Text,PasswordTextBox.Text);
			MessagesLabel.AppendText("Okay."+CRLF2);
		}

		private void ListAllRolesButton_Click(object sender, System.EventArgs e)
		{
			string[] roleList = security.ListAllRoles((Security.RoleType)Enum.Parse(typeof(Security.RoleType),RoleTypeComboBox2.SelectedItem.ToString()));
			if (roleList==null)
				MessagesLabel.AppendText( "No items."+CRLF2);
			else
				MessagesLabel.AppendText( string.Join(CRLF, roleList)+CRLF2);
		}

		private void GetRoleButton_Click(object sender, System.EventArgs e)
		{
			string roleName = security.GetRoleName(RoleGuidTextBox4.Text);
			if (roleName!=null)
			{
				MessagesLabel.AppendText( roleName + CRLF2);
			}
		}

		private void RemoveRoleFromContainerButton_Click(object sender, System.EventArgs e)
		{
			security.RemoveRoleFromContainer(ContainerGuidTextBox.Text,RoleGuidTextBox.Text);
			MessagesLabel.AppendText( "Done."+CRLF2);

		}

		private void RemoveUserFromRoleButton_Click(object sender, System.EventArgs e)
		{
			security.RemoveUserFromRole(RoleGuidTextBox3.Text,UserWinNtNameTextBox.Text);
			MessagesLabel.AppendText("Done."+CRLF2);
			
		}

		private void DeleteRoleButton_Click(object sender, System.EventArgs e)
		{
			security.DeleteRole(RoleGuidTextBox5.Text);
		}


	}
}