using System;

namespace Mcms.SiteManager
{
	/// <summary>
	/// Summary description for Channels.
	/// </summary>
	public class Channel : IDisposable
	{
		private AESERVEROBJECTLib.AESessionClass aeSession;
		private RERIGHTSCHKLib.IAEServer mcmsServer;
		//private Microsoft.ContentManagement.Interop.AEInterfaces.IAEResourceGallery mcmsRootResourceGal;
		private RERIGHTSCHKLib.RERightsChecker mcmsRightsChecker;
		private RERIGHTSCHKLib.IAESession mcmsSession;

		public Channel(string domain, string user, string password)
		{
			mcmsRightsChecker = new RERIGHTSCHKLib.RERightsChecker();
			aeSession = new AESERVEROBJECTLib.AESessionClass();
			mcmsSession = (RERIGHTSCHKLib.IAESession)aeSession;
			mcmsSession.Login("WinNT://"+domain+"/"+user, password, "[Unknown Host]", (int)Microsoft.ContentManagement.Interop.AEInterfaces.AESESSION_LOGIN_OPTIONS.AELOGIN_EDIT);
			mcmsServer = mcmsSession.GetDefaultServer();
		}

		public void CreateCustomProperty(string propertyName, string[] propertyValues, string defaultValue, string channelGuid)
		{
			string propertyValuesXml = string.Empty;
			if (propertyValues!=null && propertyValues.Length>0)
			{
				propertyValuesXml = "<CUSTOM>";
				foreach (string propertyValue in propertyValues)
				{
					propertyValuesXml += "<ENUMITEM>" + propertyValue + "</ENUMITEM>";
				}
				propertyValuesXml += "</CUSTOM>";
			}
			RERIGHTSCHKLib.IAENode node = mcmsServer.GetNodeByGUID(channelGuid,false);
			RERIGHTSCHKLib.IAEChannel channel = (RERIGHTSCHKLib.IAEChannel)node;
			RERIGHTSCHKLib.IAELock channelLock = channel.Lock;
			channelLock.Lock(false);
			RERIGHTSCHKLib.IAEGenericPropertyCollection properties = channel.GenericProperties;
			RERIGHTSCHKLib.IAEGenericProperty property = properties.CreateProperty(propertyName,defaultValue);
			if (propertyValuesXml!=string.Empty)
			{
				RERIGHTSCHKLib.IAEGenericProperty propertyList = properties.CreateProperty("_enum" + propertyName,propertyValuesXml);
			}
			channelLock.CommitAndCheckin(false);
		}
		public void Dispose()
		{
			mcmsSession.Logout();
			mcmsServer = null;
			mcmsSession = null;
			aeSession = null;
			mcmsRightsChecker = null;
		}
		
	}

}
