using System;
using System.Collections;
using RERIGHTSCHKLib;
namespace Mcms.SiteManager
{
	/// <summary>
	/// Summary description for Class1.
	/// </summary>
	public class Security : IDisposable
	{
		private AESERVEROBJECTLib.AESessionClass aeSession;
		private IAEServer mcmsServer;
		//private Microsoft.ContentManagement.Interop.AEInterfaces.IAEResourceGallery mcmsRootResourceGal;
		private RERightsChecker mcmsRightsChecker;
		private IAESession mcmsSession;
		private string _domain;
		private string _user;
		private string _password;
		private string _machineName;
		public Security(string machineName, string domain, string user, string password)
		{
			_machineName = machineName;
			_domain = domain;
			_user = user;
			_password = password;
		}
		private void ConnectToServer()
		{
			mcmsRightsChecker = new RERightsChecker();
			aeSession = new AESERVEROBJECTLib.AESessionClass();
			mcmsSession = (IAESession)aeSession;
			mcmsSession.Login("WinNT://"+_domain+"/"+_user, _password, _machineName, (int)Microsoft.ContentManagement.Interop.AEInterfaces.AESESSION_LOGIN_OPTIONS.AELOGIN_EDIT);
			mcmsServer = mcmsSession.GetDefaultServer();
		}

		private void DisconnectFromServer()
		{
			aeSession.CommitAll();
			aeSession.Logout();
			mcmsSession.Logout();
			mcmsServer = null;
			mcmsSession = null;
			aeSession = null;
			mcmsRightsChecker = null;
		}


		private string GetRoleTypeGuid(RoleType roleType)
		{
			string userGalleryGuid = null;
			switch (roleType)
			{
				case RoleType.Subscriber:
					userGalleryGuid = mcmsServer.GenericProperties.GetPropertyByName("_UserGallerySubscribers").Value;
					break;
				case RoleType.Author:
					userGalleryGuid = mcmsServer.GenericProperties.GetPropertyByName("_UserGalleryAuthors").Value;
					break;
				case RoleType.Editor:
					userGalleryGuid = mcmsServer.GenericProperties.GetPropertyByName("_UserGalleryEditors").Value;
					break;
				case RoleType.Moderator:
					userGalleryGuid = mcmsServer.GenericProperties.GetPropertyByName("_UserGalleryModerators").Value;
					break;
				case RoleType.ResourceManager:
					userGalleryGuid = mcmsServer.GenericProperties.GetPropertyByName("_UserGalleryResManagers").Value;
					break;
				case RoleType.TemplateDesigner:
					userGalleryGuid = mcmsServer.GenericProperties.GetPropertyByName("_UserGalleryTempDesigners").Value;
					break;
				case RoleType.ChannelManager:
					userGalleryGuid = mcmsServer.GenericProperties.GetPropertyByName("_UserGalleryChanManagers").Value;
					break;

			}
			return userGalleryGuid;

		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="name">Name for the new role</param>
		/// <param name="type">Role Type based on Role Type enum</param>
		/// <returns>New Role Guid</returns>
		public string CreateRole(string name, RoleType roleType) 
		{
			ConnectToServer();
			string roleTypeGuid=GetRoleTypeGuid(roleType);
			RE_ROLE mcmsRoleType = mcmsRightsChecker.GetUserRoleTypeFromParentGUID(mcmsSession, mcmsServer, roleTypeGuid);
			IAEUserRole newRole = mcmsRightsChecker.CreateUserRole(mcmsSession, mcmsServer, mcmsRoleType, name);
			string roleGuid = newRole.GUID;
			DisconnectFromServer();
			return roleGuid;
		}
		public enum RoleType
		{
			Subscriber,
			Author,
			Editor,
			Moderator,
			ResourceManager,
			TemplateDesigner,
			ChannelManager
		}
		public void AddRoleToContainer(string containerGuid, string roleGuid)
		{
			ConnectToServer();
			IAENode container = mcmsServer.GetNodeByGUID(containerGuid,false);
			IAELock containerLock = container.Lock;
			containerLock.Lock(false);
			container.ACL.AddRole(roleGuid);
			containerLock.CommitAndCheckin(false);
			DisconnectFromServer();
		}

		public void RemoveRoleFromContainer(string containerGuid, string roleGuid)
		{
			ConnectToServer();
			IAENode container = mcmsServer.GetNodeByGUID(containerGuid,false);
			IAELock containerLock = container.Lock;
			containerLock.Lock(false);
			for( int count=0; count<container.ACL.Count;count++)
			{
				if (container.ACL[count]==roleGuid)
				{
					container.ACL.DeleteRole(count);
					break;
				}
			}
			containerLock.CommitAndCheckin(false);
			DisconnectFromServer();
		}


		/// <summary>
		/// 
		/// </summary>
		/// <param name="roleGuid"></param>
		/// <param name="winNtName">The name of an existing Windows Group or User in the 
		/// WinNT://Domain/GroupOrUser format</param>
		public void AddUserToRole(string roleGuid, string winNtName)
		{
			ConnectToServer();
			IAENode node = mcmsServer.GetNodeByGUID(roleGuid,false);
			IAELock nodeLock = node.Lock;
			nodeLock.CheckoutAndLock(false,AELOCK_CHECKOUT.AELOCK_CHECKOUT_WITHDRAW_CHECKED_IN);
			DisconnectFromServer();
			ConnectToServer();
			node = mcmsServer.GetNodeByGUID(roleGuid,false);
			IAEUserRole role = (IAEUserRole)node;
			if (role.RoleMembers.GetUser(winNtName)==null)
			{
				role.RoleMembers.AddUser(winNtName,0);
			}
			role.MyApprovalStatus = AE_NODE_APPROVAL.AE_NODE_APPROVAL_ACCEPTED;
			nodeLock = node.Lock;
			nodeLock.CommitAndCheckin(false);
			DisconnectFromServer();
		}

		public void RemoveUserFromRole(string roleGuid, string winNtName)
		{
			ConnectToServer();
			IAENode node = mcmsServer.GetNodeByGUID(roleGuid,false);
			IAELock nodeLock = node.Lock;
			nodeLock.CheckoutAndLock(false,AELOCK_CHECKOUT.AELOCK_CHECKOUT_WITHDRAW_CHECKED_IN);
			DisconnectFromServer();
			ConnectToServer();
			node = mcmsServer.GetNodeByGUID(roleGuid,false);
			IAEUserRole role = (IAEUserRole)node;
			if (role.RoleMembers.GetUser(winNtName)!=null)
			{
				role.RoleMembers.DeleteUser(winNtName);
			}
			role.MyApprovalStatus = AE_NODE_APPROVAL.AE_NODE_APPROVAL_ACCEPTED;
			nodeLock = node.Lock;
			nodeLock.CommitAndCheckin(false);
			DisconnectFromServer();
		}

		public void DeleteRole(string roleGuid)
		{
			throw(new Exception("Not implemented")); 	
		}

		public string[] ListUsersForRole(string roleGuid)
		{
			ConnectToServer();
			IAENode node = mcmsServer.GetNodeByGUID(roleGuid,false);
			IAEUserRole role = (IAEUserRole)node;
			if (role.RoleMembers.Count>0)
			{
				string[] roleMembers = new string[role.RoleMembers.Count];
				int count = 0;
				foreach (IAEUser roleMember in role.RoleMembers)
				{
					roleMembers[count] = roleMember.UserName;
					count ++;
				}
				DisconnectFromServer();
				return roleMembers;
			}
			DisconnectFromServer();
			return null;
		}
		public string GetRoleName(string roleGuid)
		{
			ConnectToServer();
			IAENode node = mcmsServer.GetNodeByGUID(roleGuid,false);
			DisconnectFromServer();
			return node.Name;
		}

		public string[] ListAllRoles(RoleType roleType)
		{
			ConnectToServer();
			string roleTypeGuid = GetRoleTypeGuid(roleType);
			IAENode node = mcmsServer.GetNodeByGUID(roleTypeGuid,false);
			if (node.Children.Count>0)
			{
				string[] nodeChildren = new string[node.Children.Count];
				int count = 0;
				foreach (string nodeChild in node.Children)
				{
					nodeChildren[count] = nodeChild;
					count ++;
				}
				DisconnectFromServer();
				return nodeChildren;
			}
			DisconnectFromServer();
			return null;
		}


		public string[] ListContainerRoles(string containerGuid)
		{
			ConnectToServer();
			IAENode container = mcmsServer.GetNodeByGUID(containerGuid,false);
			if (container.ACL.Count>0)
			{
				string [] containerRoles = new string[container.ACL.Count];
				for ( int count=0; count<container.ACL.Count; count++)
				{
					containerRoles[count] = container.ACL[count];
				}
				DisconnectFromServer();
				return containerRoles;

			}
			DisconnectFromServer();
			return null;
		}
		public void Dispose()
		{

		}






	}
}
