/*
<?xml version="1.0" encoding="iso-8859-1"?>
<FileInfo>
  <Date />
  <Description />
  <Copyright><![CDATA[
    Copyright  2001 - 2003 Microsoft Corporation. All rights reserved.
    THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY 
    KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
    PARTICULAR PURPOSE.
    ]]></Copyright>
</FileInfo>
*/

// TODO: Test serialisation
// TODO: Test synchronized access under stress from a multi-threaded client

namespace Heaptest
{
	using System;
	using System.Drawing;
	using System.Collections;
	using System.ComponentModel;
	using System.Windows.Forms;
	using Microsoft.Samples.Collections;

	/// <summary>
	/// Summary description for HeapTestForm.
	/// </summary>
	public class HeapTestForm : System.Windows.Forms.Form
	{
		Heap theHeap = new Heap();
        public static string[] words = { "Lorem", "ipsum", null, "dolor", "sit", "met", "consectetur", "dipisicing", "elit", "sed", "do", "eiusmod", "tempor", "incididunt", "ut", "labore", "et", "dolore", "magna", "aliqua", "Ut", "enim", "ad", "minim", "veniam", "quis", "nostrud", "exercitation", "ullamco", "laboris" };
        int index=0;
		
		private System.Windows.Forms.Button btnAdd;
		private System.Windows.Forms.Label lblAddWord;
		private System.Windows.Forms.Button btnExtract;
		private System.Windows.Forms.GroupBox grpContents;
		private System.Windows.Forms.ListBox lbxInternal;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.ListBox lbxExtracted;
		private System.Windows.Forms.ListBox lbxEnumeration;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.TextBox txtPeek;
		private System.Windows.Forms.Button btnClear;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox txtIsEmpty;
		private System.Windows.Forms.Button btnCheckContains;
		private System.Windows.Forms.TextBox txtCheckContains;
        private System.Windows.Forms.Button btnGoSynchro;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public HeapTestForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			UpdateControlState();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.btnAdd = new System.Windows.Forms.Button();
            this.lblAddWord = new System.Windows.Forms.Label();
            this.btnExtract = new System.Windows.Forms.Button();
            this.grpContents = new System.Windows.Forms.GroupBox();
            this.label2 = new System.Windows.Forms.Label();
            this.lbxEnumeration = new System.Windows.Forms.ListBox();
            this.lbxInternal = new System.Windows.Forms.ListBox();
            this.label3 = new System.Windows.Forms.Label();
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this.lbxExtracted = new System.Windows.Forms.ListBox();
            this.label4 = new System.Windows.Forms.Label();
            this.txtPeek = new System.Windows.Forms.TextBox();
            this.btnClear = new System.Windows.Forms.Button();
            this.label1 = new System.Windows.Forms.Label();
            this.txtIsEmpty = new System.Windows.Forms.TextBox();
            this.btnCheckContains = new System.Windows.Forms.Button();
            this.txtCheckContains = new System.Windows.Forms.TextBox();
            this.btnGoSynchro = new System.Windows.Forms.Button();
            this.grpContents.SuspendLayout();
            this.groupBox2.SuspendLayout();
            this.SuspendLayout();
            // 
            // btnAdd
            // 
            this.btnAdd.Location = new System.Drawing.Point(8, 8);
            this.btnAdd.Name = "btnAdd";
            this.btnAdd.Size = new System.Drawing.Size(104, 23);
            this.btnAdd.TabIndex = 0;
            this.btnAdd.Text = "Add word number ";
            this.btnAdd.Click += new System.EventHandler(this.btnAdd_Click);
            // 
            // lblAddWord
            // 
            this.lblAddWord.Location = new System.Drawing.Point(120, 8);
            this.lblAddWord.Name = "lblAddWord";
            this.lblAddWord.TabIndex = 2;
            this.lblAddWord.Text = "lblAddWord";
            // 
            // btnExtract
            // 
            this.btnExtract.Location = new System.Drawing.Point(312, 8);
            this.btnExtract.Name = "btnExtract";
            this.btnExtract.TabIndex = 3;
            this.btnExtract.Text = "Extract word";
            this.btnExtract.Click += new System.EventHandler(this.btnExtract_Click);
            // 
            // grpContents
            // 
            this.grpContents.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
                | System.Windows.Forms.AnchorStyles.Left)));
            this.grpContents.Controls.Add(this.label2);
            this.grpContents.Controls.Add(this.lbxEnumeration);
            this.grpContents.Controls.Add(this.lbxInternal);
            this.grpContents.Controls.Add(this.label3);
            this.grpContents.Location = new System.Drawing.Point(8, 104);
            this.grpContents.Name = "grpContents";
            this.grpContents.Size = new System.Drawing.Size(496, 488);
            this.grpContents.TabIndex = 4;
            this.grpContents.TabStop = false;
            this.grpContents.Text = "Heap Contents";
            this.grpContents.Resize += new System.EventHandler(this.grpContents_Resize);
            // 
            // label2
            // 
            this.label2.Location = new System.Drawing.Point(16, 24);
            this.label2.Name = "label2";
            this.label2.TabIndex = 4;
            this.label2.Text = "Internal Array";
            // 
            // lbxEnumeration
            // 
            this.lbxEnumeration.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.lbxEnumeration.Location = new System.Drawing.Point(272, 48);
            this.lbxEnumeration.Name = "lbxEnumeration";
            this.lbxEnumeration.Size = new System.Drawing.Size(216, 407);
            this.lbxEnumeration.TabIndex = 3;
            // 
            // lbxInternal
            // 
            this.lbxInternal.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
                | System.Windows.Forms.AnchorStyles.Left)));
            this.lbxInternal.Location = new System.Drawing.Point(8, 48);
            this.lbxInternal.Name = "lbxInternal";
            this.lbxInternal.Size = new System.Drawing.Size(226, 407);
            this.lbxInternal.TabIndex = 2;
            // 
            // label3
            // 
            this.label3.Location = new System.Drawing.Point(272, 16);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(100, 24);
            this.label3.TabIndex = 4;
            this.label3.Text = "Unordered Enumeration";
            // 
            // groupBox2
            // 
            this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.groupBox2.Controls.Add(this.lbxExtracted);
            this.groupBox2.Location = new System.Drawing.Point(560, 104);
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.Size = new System.Drawing.Size(240, 488);
            this.groupBox2.TabIndex = 3;
            this.groupBox2.TabStop = false;
            this.groupBox2.Text = "Extracted Ouput";
            // 
            // lbxExtracted
            // 
            this.lbxExtracted.Dock = System.Windows.Forms.DockStyle.Fill;
            this.lbxExtracted.Location = new System.Drawing.Point(3, 16);
            this.lbxExtracted.Name = "lbxExtracted";
            this.lbxExtracted.Size = new System.Drawing.Size(234, 459);
            this.lbxExtracted.TabIndex = 6;
            // 
            // label4
            // 
            this.label4.Location = new System.Drawing.Point(568, 64);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(88, 23);
            this.label4.TabIndex = 5;
            this.label4.Text = "Peeked Output:";
            // 
            // txtPeek
            // 
            this.txtPeek.Location = new System.Drawing.Point(664, 64);
            this.txtPeek.Name = "txtPeek";
            this.txtPeek.ReadOnly = true;
            this.txtPeek.Size = new System.Drawing.Size(128, 20);
            this.txtPeek.TabIndex = 6;
            this.txtPeek.Text = "";
            // 
            // btnClear
            // 
            this.btnClear.Location = new System.Drawing.Point(440, 8);
            this.btnClear.Name = "btnClear";
            this.btnClear.TabIndex = 7;
            this.btnClear.Text = "Clear Heap";
            this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
            // 
            // label1
            // 
            this.label1.Location = new System.Drawing.Point(568, 8);
            this.label1.Name = "label1";
            this.label1.TabIndex = 9;
            this.label1.Text = "Is empty?";
            // 
            // txtIsEmpty
            // 
            this.txtIsEmpty.Location = new System.Drawing.Point(680, 8);
            this.txtIsEmpty.Name = "txtIsEmpty";
            this.txtIsEmpty.ReadOnly = true;
            this.txtIsEmpty.Size = new System.Drawing.Size(112, 20);
            this.txtIsEmpty.TabIndex = 10;
            this.txtIsEmpty.Text = "";
            // 
            // btnCheckContains
            // 
            this.btnCheckContains.Enabled = false;
            this.btnCheckContains.Location = new System.Drawing.Point(16, 56);
            this.btnCheckContains.Name = "btnCheckContains";
            this.btnCheckContains.Size = new System.Drawing.Size(96, 23);
            this.btnCheckContains.TabIndex = 13;
            this.btnCheckContains.Text = "Check contains?";
            this.btnCheckContains.Click += new System.EventHandler(this.btnCheckContains_Click);
            // 
            // txtCheckContains
            // 
            this.txtCheckContains.Location = new System.Drawing.Point(120, 56);
            this.txtCheckContains.Name = "txtCheckContains";
            this.txtCheckContains.Size = new System.Drawing.Size(120, 20);
            this.txtCheckContains.TabIndex = 14;
            this.txtCheckContains.Text = "";
            this.txtCheckContains.TextChanged += new System.EventHandler(this.txtCheckContains_TextChanged);
            // 
            // btnGoSynchro
            // 
            this.btnGoSynchro.Location = new System.Drawing.Point(312, 56);
            this.btnGoSynchro.Name = "btnGoSynchro";
            this.btnGoSynchro.TabIndex = 15;
            this.btnGoSynchro.Text = "Go Synchro";
            this.btnGoSynchro.Click += new System.EventHandler(this.btnGoSynchro_Click);
            // 
            // HeapTestForm
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(816, 598);
            this.Controls.Add(this.btnGoSynchro);
            this.Controls.Add(this.txtCheckContains);
            this.Controls.Add(this.btnCheckContains);
            this.Controls.Add(this.txtIsEmpty);
            this.Controls.Add(this.label1);
            this.Controls.Add(this.btnClear);
            this.Controls.Add(this.txtPeek);
            this.Controls.Add(this.label4);
            this.Controls.Add(this.grpContents);
            this.Controls.Add(this.btnExtract);
            this.Controls.Add(this.lblAddWord);
            this.Controls.Add(this.btnAdd);
            this.Controls.Add(this.groupBox2);
            this.Name = "HeapTestForm";
            this.Text = "HeapTestForm";
            this.Resize += new System.EventHandler(this.HeapTestForm_Resize);
            this.grpContents.ResumeLayout(false);
            this.groupBox2.ResumeLayout(false);
            this.ResumeLayout(false);

        }
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new HeapTestForm());
		}

		private void btnAdd_Click(object sender, System.EventArgs e)
		{
			theHeap.Add( words[index] );
			index++;
			UpdateControlState();

		}

		private void UpdateControlState()
		{
			// Populate the list from the internal array
			lbxInternal.Items.Clear();
			if ( theHeap.Count > 0 )
			{
				object [] inner = new object[theHeap.Count];
				theHeap.CopyTo( inner, 0 );
				foreach ( object obj in inner )
				{
					lbxInternal.Items.Add( obj != null ? Convert.ToString( obj ) : "<null>" );
				}
			}

			// Populate the unordered list with an enumeration
			lbxEnumeration.Items.Clear();
			foreach ( object obj in theHeap ) 
			{
				lbxEnumeration.Items.Add( obj != null ? Convert.ToString( obj ) : "<null>" );
			}

			btnAdd.Enabled= index < words.Length;
			btnExtract.Enabled = theHeap.Count > 0;
			lblAddWord.Text = (index+1).ToString() + " of " + words.Length.ToString();
			if ( !theHeap.IsEmpty() )
			{
				txtPeek.Text = theHeap.Peek() != null ? theHeap.Peek().ToString() : "<null>";
			}
			else
			{
				txtPeek.Text = "<empty>";
			}
			txtIsEmpty.Text = theHeap.IsEmpty().ToString();
            btnCheckContains.Enabled = txtCheckContains.Text.Length > 0;

            btnGoSynchro.Enabled = !theHeap.IsSynchronized;

		}

		private void btnExtract_Click(object sender, System.EventArgs e)
		{
			object obj = theHeap.Extract();
			lbxExtracted.Items.Add( obj != null ? Convert.ToString( obj ) : "<null>" );
			UpdateControlState();
		}

		private void HeapTestForm_Resize(object sender, System.EventArgs e)
		{
			grpContents.Width = groupBox2.Left-20-grpContents.Left;
		}

		private void grpContents_Resize(object sender, System.EventArgs e)
		{
			lbxInternal.Width = lbxEnumeration.Left-2-lbxInternal.Left;
		}

		private void btnClear_Click(object sender, System.EventArgs e)
		{
			theHeap.Clear();
			UpdateControlState();
		}

		private void btnCheckContains_Click(object sender, System.EventArgs e)
		{
			if ( theHeap.Contains( txtCheckContains.Text ) )
			{
				MessageBox.Show( "Yes" );
			}
			else 
			{
				MessageBox.Show( "No" );
			}
            UpdateControlState();
        }

		private void txtCheckContains_TextChanged(object sender, System.EventArgs e)
		{
            UpdateControlState();

		}

        private void btnGoSynchro_Click(object sender, System.EventArgs e)
        {
            theHeap = Heap.Synchronized( theHeap );
            UpdateControlState();
        }
	}
	internal class LengthComparer : IComparer
	{
		#region IComparer Members

		public int Compare(object x, object y)
		{
			return x.ToString().Length - y.ToString().Length;
		}

		#endregion

	}

	internal class ReverseStringComparer : IComparer
	{
		#region IComparer Members

		public int Compare(object x, object y)
		{
			return -((IComparable)x).CompareTo( y );
		}

		#endregion

	}
}
