using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using Microsoft.Ink;
using Leszynski.SampleInkControls;

namespace Tester
{
	public class InkToolBarForm : System.Windows.Forms.Form
	{
		private Leszynski.SampleInkControls.InkToolBar myInkToolBar;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Button buttonExit;
		private System.Windows.Forms.Button buttonSave;
		private System.Windows.Forms.Button buttonCreate;
		private System.Windows.Forms.PictureBox pictureBox;
		private Microsoft.Ink.InkPicture inkPicture;
		private Bitmap MyImage;
		private System.Windows.Forms.OpenFileDialog openFileDialog;
		private System.Windows.Forms.SaveFileDialog saveFileDialog;

		private System.ComponentModel.Container components = null;

		public InkToolBarForm()
		{
			InitializeComponent();
			
			//
			// Set default pen color to red.
			//
			//DrawingAttributes da			  = new DrawingAttributes(Color.Red);
			//myInkToolBar.DefaultPenSettings = da;
		}

		#region Dispose
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(InkToolBarForm));
			this.myInkToolBar = new Leszynski.SampleInkControls.InkToolBar();
			this.button1 = new System.Windows.Forms.Button();
			this.buttonExit = new System.Windows.Forms.Button();
			this.buttonSave = new System.Windows.Forms.Button();
			this.buttonCreate = new System.Windows.Forms.Button();
			this.pictureBox = new System.Windows.Forms.PictureBox();
			this.inkPicture = new Microsoft.Ink.InkPicture();
			this.openFileDialog = new System.Windows.Forms.OpenFileDialog();
			this.saveFileDialog = new System.Windows.Forms.SaveFileDialog();
			this.SuspendLayout();
			// 
			// myInkToolBar
			// 
			this.myInkToolBar.ButtonSize = new System.Drawing.Size(31, 30);
			this.myInkToolBar.Divider = false;
			this.myInkToolBar.Name = "myInkToolBar";
			this.myInkToolBar.Size = new System.Drawing.Size(546, 31);
			this.myInkToolBar.TabIndex = 2;
			this.myInkToolBar.ModeChanged += new System.EventHandler(this.InkToolBar_ModeChanged);
			this.myInkToolBar.SettingsChanged += new System.EventHandler(this.InkToolBar_SettingsChanged);
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(96, 288);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(72, 24);
			this.button1.TabIndex = 12;
			this.button1.Text = "Get Picture";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// buttonExit
			// 
			this.buttonExit.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.buttonExit.Location = new System.Drawing.Point(448, 288);
			this.buttonExit.Name = "buttonExit";
			this.buttonExit.Size = new System.Drawing.Size(88, 23);
			this.buttonExit.TabIndex = 11;
			this.buttonExit.Tag = "0";
			this.buttonExit.Text = "E&xit";
			this.buttonExit.Click += new System.EventHandler(this.buttonExit_Click_1);
			// 
			// buttonSave
			// 
			this.buttonSave.Enabled = false;
			this.buttonSave.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.buttonSave.Location = new System.Drawing.Point(352, 288);
			this.buttonSave.Name = "buttonSave";
			this.buttonSave.Size = new System.Drawing.Size(88, 23);
			this.buttonSave.TabIndex = 10;
			this.buttonSave.Tag = "0";
			this.buttonSave.Text = "Save Image";
			this.buttonSave.Click += new System.EventHandler(this.buttonSave_Click_1);
			// 
			// buttonCreate
			// 
			this.buttonCreate.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.buttonCreate.Location = new System.Drawing.Point(208, 288);
			this.buttonCreate.Name = "buttonCreate";
			this.buttonCreate.Size = new System.Drawing.Size(136, 23);
			this.buttonCreate.TabIndex = 9;
			this.buttonCreate.Tag = "0";
			this.buttonCreate.Text = "Create Annotated Image";
			this.buttonCreate.Click += new System.EventHandler(this.buttonCreate_Click_1);
			// 
			// pictureBox
			// 
			this.pictureBox.BackColor = System.Drawing.Color.White;
			this.pictureBox.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.pictureBox.Location = new System.Drawing.Point(277, 48);
			this.pictureBox.Name = "pictureBox";
			this.pictureBox.Size = new System.Drawing.Size(264, 216);
			this.pictureBox.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pictureBox.TabIndex = 8;
			this.pictureBox.TabStop = false;
			// 
			// inkPicture
			// 
			this.inkPicture.BackColor = System.Drawing.Color.White;
			this.inkPicture.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.inkPicture.Image = ((System.Drawing.Bitmap)(resources.GetObject("inkPicture.Image")));
			this.inkPicture.Location = new System.Drawing.Point(4, 48);
			this.inkPicture.MarginX = -2147483648;
			this.inkPicture.MarginY = -2147483648;
			this.inkPicture.Name = "inkPicture";
			this.inkPicture.Size = new System.Drawing.Size(264, 216);
			this.inkPicture.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.inkPicture.TabIndex = 7;
			// 
			// openFileDialog
			// 
			this.openFileDialog.Filter = "GIF (*.gif)|*.gif | BMP (*.bmp)|*.bmp";
			// 
			// saveFileDialog
			// 
			this.saveFileDialog.FileName = "annotatedImage1";
			this.saveFileDialog.Filter = "GIF (*.gif)|*.gif | BMP (*.bmp)|*.bmp";
			// 
			// InkToolBarForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(546, 328);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.button1,
																		  this.buttonExit,
																		  this.buttonSave,
																		  this.buttonCreate,
																		  this.pictureBox,
																		  this.inkPicture,
																		  this.myInkToolBar});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.MaximizeBox = false;
			this.Name = "InkToolBarForm";
			this.Text = "InkToolBar Test Form";
			this.TopMost = true;
			this.Load += new System.EventHandler(this.InkToolBarForm_Load);
			this.ResumeLayout(false);

		}
		#endregion

		[STAThread]
		static void Main() 
		{
			Application.Run(new InkToolBarForm());
		}

		private void InkToolBarForm_Load(object sender, System.EventArgs e)
		{
			//Use event handlers to initialize
			InkToolBar_SettingsChanged(sender, e);
			InkToolBar_ModeChanged(sender, e);
		}
			
		private void InkToolBar_SettingsChanged(object source, EventArgs e)
		{
			switch (this.myInkToolBar.Mode)
			{
				case InkToolBarMode.Pen:
				case InkToolBarMode.Highlighter:
					this.inkPicture.DefaultDrawingAttributes = this.myInkToolBar.InkDrawingAttributes;
					break;
				case InkToolBarMode.Eraser:
					inkPicture.EraserMode  = this.myInkToolBar.EraserAttributes.Mode;
					inkPicture.EraserWidth = this.myInkToolBar.EraserAttributes.Size;
					break;
				default:
					break;
			}
		}
		
		private void InkToolBar_ModeChanged(object source, EventArgs e)
		{
			switch (this.myInkToolBar.Mode)
			{
				case InkToolBarMode.Eraser:
					inkPicture.Selection	 = inkPicture.Ink.CreateStrokes();
					inkPicture.EditingMode = InkOverlayEditingMode.Delete;
					break;
				case InkToolBarMode.Lasso:
					inkPicture.EditingMode = InkOverlayEditingMode.Select;
					break;
				default:
					inkPicture.Selection	 = inkPicture.Ink.CreateStrokes();
					inkPicture.EditingMode = InkOverlayEditingMode.Ink;
					break;
			}
		}
		private void buttonCreate_Click(object sender, System.EventArgs e) 
		{ 

			// 
			//      dispose of the existing pictureBox image 
			// 
			if(pictureBox.Image != null) 
			{ 
				pictureBox.Image.Dispose(); 
			} 

			// 
			//      create a new image 
			// 
			Bitmap image = (Bitmap)inkPicture.Image.Clone(); 
			// 
			// update the picture box with the new image 
			// 
			pictureBox.Image = image; 
			// 
			//      Create a new Graphics instance to draw on the new image 
			// 
			using (Graphics g = Graphics.FromImage(image)) 
			{ 
				long sx;
				long sy;
				sx = inkPicture.Image.Width;
				sy = inkPicture.Image.Height;
				float sx2 = sx / 264.0F;
				float sy2 = sy / 219.0F;
				inkPicture.Renderer.Scale(sx2, sy2);
				inkPicture.Renderer.Draw(g, inkPicture.Ink.Strokes); 
			} 



			// 
			// enable the saveas button 
			// 
			buttonSave.Enabled = true; 
		} 

		private void buttonExit_Click(object sender, System.EventArgs e)
		{
			this.Dispose();
		}

		private void buttonSave_Click(object sender, System.EventArgs e)
		{
			saveFileDialog.FileName = "annotatedImage1";
			if(DialogResult.OK == saveFileDialog.ShowDialog(this))
			{
				try
				{
					string filename = saveFileDialog.FileName;
					filename = filename.Trim();
					string compareFilename = filename.ToLower();
					if(compareFilename.EndsWith(".gif"))
					{
						pictureBox.Image.Save(filename, ImageFormat .Gif);
					}					
					else if(compareFilename.EndsWith(".bmp"))
					{
						pictureBox.Image.Save(filename, ImageFormat .Bmp);
					}
				}
				catch(Exception ex)
				{
					MessageBox.Show("Error saving the image: \n\n" + ex.ToString());
				}
			}
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
		
			openFileDialog.FileName = "*.*";
			if(openFileDialog.ShowDialog() == DialogResult.OK)
			{
				try
				{
					string filename = openFileDialog.FileName;
					filename = filename.Trim();
					string compareFilename = filename.ToLower();
					MyImage = new Bitmap(filename);
					inkPicture.Image = (Image) MyImage ;
	
				}
				catch(Exception ex)
				{
					MessageBox.Show("Error saving the image: \n\n" + ex.ToString());
				}

			}
		}

		private void buttonCreate_Click_1(object sender, System.EventArgs e)
		{
		
			// 
			//      dispose of the existing pictureBox image 
			// 
			if(pictureBox.Image != null) 
			{ 
				pictureBox.Image.Dispose(); 
			} 

			// 
			//      create a new image 
			// 
			Bitmap image = (Bitmap)inkPicture.Image.Clone(); 
			// 
			// update the picture box with the new image 
			// 
			pictureBox.Image = image; 
			// 
			//      Create a new Graphics instance to draw on the new image 
			// 
			using (Graphics g = Graphics.FromImage(image)) 
			{ 
				long sx;
				long sy;
				sx = inkPicture.Image.Width;
				sy = inkPicture.Image.Height;
				float sx2 = sx / 264.0F;
				float sy2 = sy / 219.0F;
				inkPicture.Renderer.Scale(sx2, sy2);
				inkPicture.Renderer.Draw(g, inkPicture.Ink.Strokes); 
			} 



			// 
			// enable the saveas button 
			// 
			buttonSave.Enabled = true; 
		}

		private void buttonSave_Click_1(object sender, System.EventArgs e)
		{
			saveFileDialog.FileName = "annotatedImage1";
			if(DialogResult.OK == saveFileDialog.ShowDialog(this))
			{
				try
				{
					string filename = saveFileDialog.FileName;
					filename = filename.Trim();
					string compareFilename = filename.ToLower();
					if(compareFilename.EndsWith(".gif"))
					{
						pictureBox.Image.Save(filename, ImageFormat.Gif);
					}					
					else if(compareFilename.EndsWith(".bmp"))
					{
						pictureBox.Image.Save(filename, ImageFormat.Bmp);
					}
				}
				catch(Exception ex)
				{
					MessageBox.Show("Error saving the image: \n\n" + ex.ToString());
				}
			}
		}

		private void buttonExit_Click_1(object sender, System.EventArgs e)
		{
		this.Dispose();
		}
	}
}
