Imports System.ComponentModel
Imports System.Web.UI
Imports System.Drawing

<DefaultProperty("Text"), ToolboxData("<{0}:FlashGraph runat=server></{0}:FlashGraph>")> Public Class FlashGraph
    Inherits GraphBase


    Protected Overrides Sub Render(ByVal output As System.Web.UI.HtmlTextWriter)
        Try
            If Me.GradientColor.IsEmpty Then Me.GradientColor = Me.BackColor

            Dim Height As Integer = 265
            Dim Width As Integer = 435
            If InStr(Me.Width.ToString, "px", CompareMethod.Text) > 0 Then Width = CInt(Replace(Me.Width.ToString, "px", ""))
            If InStr(Me.Height.ToString, "px", CompareMethod.Text) > 0 Then Height = CInt(Replace(Me.Height.ToString, "px", ""))
            Dim BackColor As String = Mid(Hex(Me.BackColor.ToArgb), 3, 100)
            Dim FillColor As String = Mid(Hex(Me.FillColor.ToArgb), 3, 100)
            Dim FontColor As String = Mid(Hex(Me.ForeColor.ToArgb), 3, 100)
            Dim LineColor As String = Mid(Hex(Me.LineColor.ToArgb), 3, 100)
            Dim GradientColor As String = ""
            If Me.GradientColor.IsEmpty = False Then GradientColor = Mid(Hex(Me.GradientColor.ToArgb), 3, 100)

            Dim GridLineColor As String = Mid(Hex(Me.GridLineColor.ToArgb), 3, 100)
            Dim URL As String = Me.ResolveUrl(Me.MovieURL)
            Dim POSTURL As String
            Dim UniqueID As String
            Dim Div As String = "<DIV"
            Try

                POSTURL = Me.Page.Request.Path
                UniqueID = Me.UniqueID.ToString
            Catch ex As Exception

            End Try
            If Not Me.Style("LEFT") Is Nothing And Not Me.Style("TOP") Is Nothing Then
                Div &= " style=""POSITION: absolute; LEFT: " & Me.Style("LEFT") & "; TOP: " & Me.Style("TOP") & """"
            End If
            Div &= ">"
            Dim Text As String = Div & "<!--url's used in the movie-->" & vbCrLf _
                & "<!--text used in the movie-->" & vbCrLf _
                & "<!-- saved from url=(0013)about:internet -->" & vbCrLf _
                & "<object classid=""clsid:d27cdb6e-ae6d-11cf-96b8-444553540000"" codebase=""http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0"" width=""" & Width & """ height=""" & Height & """ id=""MyGraph"" align=""middle"">" & vbCrLf _
                & "<param name=""allowScriptAccess"" value=""sameDomain"" />" & vbCrLf _
                & "<param name=""movie"" value=""" & URL & "?FillTransparency=" & Me.FillOpacity.ToString & "&BgColor=" & BackColor & "&GradientAngle=" & Me.GradientAngle.ToString & "&GradientColor=" & GradientColor & "&TickCount=" & Environment.TickCount.ToString & "&PostURL=" & POSTURL & "&UniqueID=" & UniqueID & "&GraphHeight=" & Height.ToString & "&GraphWidth=" & Width.ToString & "&FillColor=" & FillColor & "&FontColor=" & FontColor & "&LineColor=" & LineColor & "&GridLineColor=" & GridLineColor & """ />" & vbCrLf _
                & "<param name=""quality"" value=""high"" />" & vbCrLf _
                & "<param name=""bgcolor"" value=""#" & BackColor & """ />" & vbCrLf _
                & "<param name=""menu"" value=""false"" />" & vbCrLf _
                & "<embed src=""" & URL & """ quality=""high"" bgcolor=""#" & BackColor & """ width=""" & Width.ToString & """ height=""" & Height.ToString & """ name=""MyGraph"" align=""middle"" allowScriptAccess=""sameDomain"" type=""application/x-shockwave-flash"" pluginspage=""http://www.macromedia.com/go/getflashplayer"" />" & vbCrLf _
                & "</object></DIV>"

            output.Write(Text)
        Catch ex As Exception
            output.Write(ex.Message)

        End Try
    End Sub

    Public Property MovieURL() As String
        Get
            Try
                Dim URL As String = CStr(viewstate("MovieURL"))
                If URL <> "" Then Return URL Else Return "MyGraph.swf"
            Catch ex As Exception
                Return "MyGraph.swf"

            End Try
        End Get
        Set(ByVal Value As String)
            viewstate("MovieURL") = Value
        End Set
    End Property

    Protected Overrides Sub RenderGraphData(ByVal items As DataValues)
        Dim XML As String = "<?xml version=""1.0"" encoding=""utf-8"" standalone=""yes""?><Results>"
        Dim DataValue As DataValue


        For Each DataValue In items
            Dim Clr As String = ""
            'If DataValue.ItemColor.ToArgb <> Color.Transparent.ToArgb Then 
            If DataValue.ItemColor.IsEmpty = False Then Clr = Mid(Hex(DataValue.ItemColor.ToArgb), 3, 100)
            XML &= "<Result><Label>" & DataValue.Label & "</Label>"
            XML &= "<Value>" & DataValue.Value.ToString & "</Value>"
            XML &= "<URL>" & DataValue.URL & "</URL>"
            XML &= "<PopupLabel>" & DataValue.PopupLabel & "</PopupLabel>"
            XML &= "<ItemColor>" & Clr & "</ItemColor>"
            XML &= "</Result>"
        Next
        XML &= "</Results>"

        Me.Page.Response.Clear()
        Me.Page.Response.Write(XML)
        Me.Page.Response.End()
    End Sub
End Class

