Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.Web.UI.Design
Imports System.Drawing.Design
Imports System.ComponentModel

<DefaultEvent("Click"), ToolboxData("<{0}:OfficeButton runat=server></{0}:OfficeButton>")> _
Public Class OfficeButton
	Inherits ImageButton

#Region " Declarations "

	Private _OverImageUrl As String = ""
	Private _DisabledImageUrl As String = ""

#End Region

#Region " Properties "

	<Browsable(True), Category("Behavior"), DefaultValue(True)> _
	Public Shadows Property Enabled() As Boolean
		Get
			Return MyBase.Enabled
		End Get
		Set(ByVal Value As Boolean)
			MyBase.Enabled = Value
		End Set
	End Property

	<Category("Appearance"), DefaultValue(""), Description("The Url of the image to be shown when rolled over."), EditorAttribute(GetType(ImageUrlEditor), GetType(UITypeEditor))> _
	Public Property OverImageUrl() As String
		Get
			Return _OverImageUrl
		End Get
		Set(ByVal Value As String)
			_OverImageUrl = Value
		End Set
	End Property

	<Category("Appearance"), DefaultValue(""), Description("The Url of the image to be shown when disabled."), EditorAttribute(GetType(ImageUrlEditor), GetType(UITypeEditor))> _
	Public Property DisabledImageUrl() As String
		Get
			Return _DisabledImageUrl
		End Get
		Set(ByVal Value As String)
			_DisabledImageUrl = Value
		End Set
	End Property

#End Region

#Region " Event Handlers "

	Public Overrides Sub RenderBeginTag(ByVal writer As System.Web.UI.HtmlTextWriter)
		If Enabled Then
			MyBase.RenderBeginTag(writer)
		Else
			writer.Write(writer.TagLeftChar)
			writer.Write("img")
		End If
	End Sub

	Protected Overrides Sub AddAttributesToRender(ByVal writer As System.Web.UI.HtmlTextWriter)
		If Enabled Then
			writer.AddAttribute(HtmlTextWriterAttribute.Type, "image")
		End If
		writer.AddAttribute(HtmlTextWriterAttribute.Name, Me.UniqueID)
		If Not Enabled Then
			writer.AddAttribute(HtmlTextWriterAttribute.Disabled, "disabled")
		End If
		writer.AddAttribute(HtmlTextWriterAttribute.Title, Me.ToolTip)
		If Enabled OrElse Me.DisabledImageUrl = "" Then
			writer.AddAttribute(HtmlTextWriterAttribute.Src, Me.ImageUrl)
		Else
			writer.AddAttribute(HtmlTextWriterAttribute.Src, Me.DisabledImageUrl)
		End If
		writer.AddAttribute(HtmlTextWriterAttribute.Alt, Me.AlternateText)
		writer.AddAttribute(HtmlTextWriterAttribute.Border, Me.BorderWidth.Value.ToString)
		If Enabled Then
			writer.AddAttribute("onmouseover", "javascript:this.src='" & Me.OverImageUrl & "'")
			writer.AddAttribute("onmouseout", "javascript:this.src='" & Me.ImageUrl & "'")
		End If
	End Sub

	Protected Overrides Sub RenderContents(ByVal writer As System.Web.UI.HtmlTextWriter)
		If Enabled Then
			MyBase.RenderContents(writer)
		Else
			writer.WriteAttribute("name", Me.UniqueID)
			writer.WriteAttribute("id", Me.UniqueID)
			writer.WriteAttribute("title", Me.ToolTip)
			If Me.DisabledImageUrl <> "" Then
				writer.WriteAttribute("src", Me.DisabledImageUrl)
			Else
				writer.WriteAttribute("src", Me.ImageUrl)
			End If
			writer.WriteAttribute("alt", Me.AlternateText)
			writer.WriteAttribute("border", Me.BorderWidth.Value.ToString)
		End If
	End Sub

	Public Overrides Sub RenderEndTag(ByVal writer As System.Web.UI.HtmlTextWriter)
		If Enabled Then
			MyBase.RenderEndTag(writer)
		Else
			writer.Write(writer.TagRightChar)
		End If
	End Sub

#End Region

End Class