Imports System.ComponentModel
<Description("Owner Draw MenuItem Class with new properties such as image and font.")> _
Public Class MyMenuItem
    Inherits MenuItem
    Private mFont As Font = SystemInformation.MenuFont
    Private mImage As System.Drawing.Image = Nothing
    Private nStartTextPosition As Integer = 0
    Public Sub New()
        MyBase.New()
    End Sub
    <Description("Position of the left corner menuitem control where the text is drawing"), DefaultValue(0)> _
    Property StartTextPosition() As Integer
        Get
            StartTextPosition = nStartTextPosition
        End Get
        Set(ByVal Value As Integer)
            nStartTextPosition = Value
        End Set
    End Property
    <Description("The Font used to draw the text")> Property Font() As System.Drawing.Font
        Get
            Font = mFont
        End Get
        Set(ByVal Value As Font)
            mFont = Value
        End Set
    End Property
    <Description("This image will be used on the left side on menuitem.Note: This image is visible only at run-time !")> Property Image() As Image
        Get
            Image = mImage
        End Get
        Set(ByVal Value As Image)
            mImage = Value
        End Set
    End Property
    Protected Overrides Sub OnMeasureItem(ByVal e As System.Windows.Forms.MeasureItemEventArgs)
        Dim itemSize As SizeF
        itemSize = e.Graphics.MeasureString(Me.Text, mFont)
        Dim nIconW As Integer = 0
        Dim nIconH As Integer = 0
        If Not (mImage Is Nothing) Then
            nIconW = mImage.Width
            If mImage.Height > itemSize.Height Then nIconH = mImage.Height - itemSize.Height
        End If
        e.ItemWidth = itemSize.Width + nIconW + nStartTextPosition
        e.ItemHeight = itemSize.Height + nIconH
    End Sub

    Protected Overrides Sub OnDrawItem(ByVal e As System.Windows.Forms.DrawItemEventArgs)

        Dim selected As Boolean
        Dim textcolor As Color = SystemColors.MenuText
        Dim textformat As New StringFormat()
        textformat.HotkeyPrefix = Drawing.Text.HotkeyPrefix.Show

        Dim nIconW As Integer = 0
        If Not (mImage Is Nothing) Then
            nIconW = mImage.Width
        End If
        Dim R As New RectangleF(e.Bounds.Left + nIconW, e.Bounds.Top, e.Bounds.Width, e.Bounds.Height)

        selected = (e.State And DrawItemState.Selected)

        e.Graphics.FillRectangle(SystemBrushes.Menu, e.Bounds.Left, e.Bounds.Top, e.Bounds.Width, e.Bounds.Height)
        If selected Then
            e.DrawBackground()
            textcolor = SystemColors.HighlightText
        Else
            e.Graphics.FillRectangle(SystemBrushes.Menu, R)
        End If
        If Not (mImage Is Nothing) Then
            e.Graphics.DrawImageUnscaled(mImage, e.Bounds.Left, e.Bounds.Top)
        End If
        R.X += nStartTextPosition
        e.Graphics.DrawString(Me.Text, mFont, New SolidBrush(textcolor), R, textformat)
    End Sub
End Class
