

Public Class form1
    Inherits System.Windows.Forms.Form
    Private m_RubberPoint1 As Point
    Private m_RubberPoint2 As Point
    Private sel_tracking As Boolean = False
    Private startX As Point
    Private startY As Point
    Private endX As Point
    Private endY As Point
    Private downX As Integer = 0
    Private downY As Integer = 0
    Private upX As Integer = 0
    Private upY As Integer = 0
    Private upperLeftX As Integer = 0
    Private upperLeftY As Integer = 0
    Private lowerRightX As Integer = 0
    Private lowerRightY As Integer = 0
    Private sel_selection As Rectangle
    Private imgUndo As Image
#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents Panel1 As System.Windows.Forms.Panel
    Friend WithEvents PictureBox1 As System.Windows.Forms.PictureBox
    Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
    Friend WithEvents MenuItem1 As System.Windows.Forms.MenuItem
    Friend WithEvents mnuOpen As System.Windows.Forms.MenuItem
    Friend WithEvents mnuExit As System.Windows.Forms.MenuItem
    Friend WithEvents mnuClear As System.Windows.Forms.MenuItem
    Friend WithEvents btnCrop As System.Windows.Forms.Button
    Friend WithEvents btnUndo As System.Windows.Forms.Button
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents txtStartX As System.Windows.Forms.TextBox
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents txtStartY As System.Windows.Forms.TextBox
    Friend WithEvents Label3 As System.Windows.Forms.Label
    Friend WithEvents txtEndX As System.Windows.Forms.TextBox
    Friend WithEvents Label4 As System.Windows.Forms.Label
    Friend WithEvents Label5 As System.Windows.Forms.Label
    Friend WithEvents Label6 As System.Windows.Forms.Label
    Friend WithEvents txtEndY As System.Windows.Forms.TextBox
    Friend WithEvents OpenFileDialog1 As System.Windows.Forms.OpenFileDialog
    Friend WithEvents ToolTip1 As System.Windows.Forms.ToolTip
    Friend WithEvents txtHeight As System.Windows.Forms.TextBox
    Friend WithEvents txtWidth As System.Windows.Forms.TextBox
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container()
        Me.Panel1 = New System.Windows.Forms.Panel()
        Me.PictureBox1 = New System.Windows.Forms.PictureBox()
        Me.MainMenu1 = New System.Windows.Forms.MainMenu()
        Me.MenuItem1 = New System.Windows.Forms.MenuItem()
        Me.mnuOpen = New System.Windows.Forms.MenuItem()
        Me.mnuClear = New System.Windows.Forms.MenuItem()
        Me.mnuExit = New System.Windows.Forms.MenuItem()
        Me.btnCrop = New System.Windows.Forms.Button()
        Me.btnUndo = New System.Windows.Forms.Button()
        Me.Label1 = New System.Windows.Forms.Label()
        Me.txtStartX = New System.Windows.Forms.TextBox()
        Me.Label2 = New System.Windows.Forms.Label()
        Me.txtStartY = New System.Windows.Forms.TextBox()
        Me.Label3 = New System.Windows.Forms.Label()
        Me.txtEndX = New System.Windows.Forms.TextBox()
        Me.Label4 = New System.Windows.Forms.Label()
        Me.txtHeight = New System.Windows.Forms.TextBox()
        Me.Label5 = New System.Windows.Forms.Label()
        Me.txtWidth = New System.Windows.Forms.TextBox()
        Me.Label6 = New System.Windows.Forms.Label()
        Me.txtEndY = New System.Windows.Forms.TextBox()
        Me.OpenFileDialog1 = New System.Windows.Forms.OpenFileDialog()
        Me.ToolTip1 = New System.Windows.Forms.ToolTip(Me.components)
        Me.Panel1.SuspendLayout()
        Me.SuspendLayout()
        '
        'Panel1
        '
        Me.Panel1.AutoScroll = True
        Me.Panel1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.Panel1.Controls.AddRange(New System.Windows.Forms.Control() {Me.PictureBox1})
        Me.Panel1.Location = New System.Drawing.Point(146, 5)
        Me.Panel1.Name = "Panel1"
        Me.Panel1.Size = New System.Drawing.Size(523, 386)
        Me.Panel1.TabIndex = 0
        '
        'PictureBox1
        '
        Me.PictureBox1.Location = New System.Drawing.Point(64, 6)
        Me.PictureBox1.Name = "PictureBox1"
        Me.PictureBox1.Size = New System.Drawing.Size(291, 306)
        Me.PictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize
        Me.PictureBox1.TabIndex = 0
        Me.PictureBox1.TabStop = False
        '
        'MainMenu1
        '
        Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem1})
        '
        'MenuItem1
        '
        Me.MenuItem1.Index = 0
        Me.MenuItem1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuOpen, Me.mnuClear, Me.mnuExit})
        Me.MenuItem1.Text = "File"
        '
        'mnuOpen
        '
        Me.mnuOpen.Index = 0
        Me.mnuOpen.Text = "Open"
        '
        'mnuClear
        '
        Me.mnuClear.Index = 1
        Me.mnuClear.Text = "Clear"
        '
        'mnuExit
        '
        Me.mnuExit.Index = 2
        Me.mnuExit.Text = "Exit"
        '
        'btnCrop
        '
        Me.btnCrop.Location = New System.Drawing.Point(74, 35)
        Me.btnCrop.Name = "btnCrop"
        Me.btnCrop.Size = New System.Drawing.Size(61, 28)
        Me.btnCrop.TabIndex = 1
        Me.btnCrop.Text = "Crop"
        '
        'btnUndo
        '
        Me.btnUndo.Location = New System.Drawing.Point(78, 77)
        Me.btnUndo.Name = "btnUndo"
        Me.btnUndo.Size = New System.Drawing.Size(59, 35)
        Me.btnUndo.TabIndex = 2
        Me.btnUndo.Text = "Undo"
        '
        'Label1
        '
        Me.Label1.Location = New System.Drawing.Point(11, 133)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(86, 11)
        Me.Label1.TabIndex = 3
        Me.Label1.Text = "MouseDown X"
        '
        'txtStartX
        '
        Me.txtStartX.Location = New System.Drawing.Point(0, 155)
        Me.txtStartX.Name = "txtStartX"
        Me.txtStartX.Size = New System.Drawing.Size(74, 20)
        Me.txtStartX.TabIndex = 4
        Me.txtStartX.Text = ""
        '
        'Label2
        '
        Me.Label2.Location = New System.Drawing.Point(2, 182)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(88, 15)
        Me.Label2.TabIndex = 5
        Me.Label2.Text = "MouseDown Y"
        '
        'txtStartY
        '
        Me.txtStartY.Location = New System.Drawing.Point(3, 207)
        Me.txtStartY.Name = "txtStartY"
        Me.txtStartY.Size = New System.Drawing.Size(75, 20)
        Me.txtStartY.TabIndex = 6
        Me.txtStartY.Text = ""
        '
        'Label3
        '
        Me.Label3.Location = New System.Drawing.Point(5, 241)
        Me.Label3.Name = "Label3"
        Me.Label3.Size = New System.Drawing.Size(84, 13)
        Me.Label3.TabIndex = 7
        Me.Label3.Text = "MouseUp X"
        '
        'txtEndX
        '
        Me.txtEndX.Location = New System.Drawing.Point(4, 263)
        Me.txtEndX.Name = "txtEndX"
        Me.txtEndX.Size = New System.Drawing.Size(66, 20)
        Me.txtEndX.TabIndex = 8
        Me.txtEndX.Text = ""
        '
        'Label4
        '
        Me.Label4.Location = New System.Drawing.Point(3, 419)
        Me.Label4.Name = "Label4"
        Me.Label4.Size = New System.Drawing.Size(71, 16)
        Me.Label4.TabIndex = 9
        Me.Label4.Text = "New Height"
        '
        'txtHeight
        '
        Me.txtHeight.Location = New System.Drawing.Point(0, 447)
        Me.txtHeight.Name = "txtHeight"
        Me.txtHeight.Size = New System.Drawing.Size(72, 20)
        Me.txtHeight.TabIndex = 10
        Me.txtHeight.Text = ""
        '
        'Label5
        '
        Me.Label5.Location = New System.Drawing.Point(0, 367)
        Me.Label5.Name = "Label5"
        Me.Label5.Size = New System.Drawing.Size(85, 16)
        Me.Label5.TabIndex = 11
        Me.Label5.Text = "New Width"
        '
        'txtWidth
        '
        Me.txtWidth.Location = New System.Drawing.Point(3, 390)
        Me.txtWidth.Name = "txtWidth"
        Me.txtWidth.Size = New System.Drawing.Size(68, 20)
        Me.txtWidth.TabIndex = 12
        Me.txtWidth.Text = ""
        '
        'Label6
        '
        Me.Label6.Location = New System.Drawing.Point(7, 298)
        Me.Label6.Name = "Label6"
        Me.Label6.Size = New System.Drawing.Size(90, 18)
        Me.Label6.TabIndex = 13
        Me.Label6.Text = "MouseUp Y"
        '
        'txtEndY
        '
        Me.txtEndY.Location = New System.Drawing.Point(8, 334)
        Me.txtEndY.Name = "txtEndY"
        Me.txtEndY.Size = New System.Drawing.Size(60, 20)
        Me.txtEndY.TabIndex = 14
        Me.txtEndY.Text = ""
        '
        'form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(697, 484)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.txtEndY, Me.Label6, Me.txtWidth, Me.Label5, Me.txtHeight, Me.Label4, Me.txtEndX, Me.Label3, Me.txtStartY, Me.Label2, Me.txtStartX, Me.Label1, Me.btnUndo, Me.btnCrop, Me.Panel1})
        Me.Menu = Me.MainMenu1
        Me.Name = "form1"
        Me.Text = "Draw Selection Box"
        Me.Panel1.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region
    
    Private Sub mnuOpen_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuOpen.Click
        With OpenFileDialog1
            .InitialDirectory = "C:\"
            .Filter = "All Image Formats (*.bmp;*.jpg;*.jpeg;*.gif;*.tif)|" & _
                "*.bmp;*.jpg;*.jpeg;*.gif;*.tif|Bitmaps (*.bmp)|*.bmp|" & _
                "GIFs (*.gif)|*.gif|JPEGs (*.jpg)|*.jpg;*.jpeg|TIFs (*.tif)|*.tif"
            .FilterIndex = 1
        End With
        
        If OpenFileDialog1.ShowDialog() = DialogResult.OK Then
            With PictureBox1
                ' Keep the original width and height of the PictureBox, regardless
                ' of the image size being loaded.
                .Width = PictureBox1.Width
                .Height = PictureBox1.Height
                .Image = Image.FromFile(OpenFileDialog1.FileName)
                .SizeMode = PictureBox1.SizeMode.Normal
                .Width = PictureBox1.Image.Width
                .Height = PictureBox1.Image.Height

            End With
        End If
        PictureBox1.Visible = True
        btnCrop.Enabled = True
        btnUndo.Enabled = True
    End Sub

    Private Sub mnuExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuExit.Click
        If PictureBox1.Image Is Nothing Then
            Me.Close()
        Else : PictureBox1.Image.Dispose()
            Me.Close()
        End If
    End Sub



    Private Sub PictureBox1_MouseHover(ByVal sender As Object, ByVal e As System.EventArgs) Handles PictureBox1.MouseHover
        ToolTip1.SetToolTip(PictureBox1, PictureBox1.Width & " X " & PictureBox1.Height)
    End Sub

    Private Sub PictureBox1_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles PictureBox1.MouseDown
        sel_tracking = True
        'keeps mousepointer in Picturebox client area while left mouse button is held down
        Cursor.Clip = PictureBox1.RectangleToScreen(PictureBox1.ClientRectangle)
        'sets the starting X & Y point for the Selection Box drawn to the screen
        m_RubberPoint1 = PictureBox1.MousePosition
        m_RubberPoint2 = m_RubberPoint1

        txtStartX.Text = e.X.ToString
        txtStartY.Text = e.Y.ToString
        'DownX & DownY are NEEDED for Coordinates do not delete
        downX = e.X
        downY = e.Y


    End Sub

    Private Sub PictureBox1_MouseUp(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles PictureBox1.MouseUp
        'Allows the cursor to leave the Picturebox Client area once the left mousebutton is released
        Cursor.Clip = Nothing
        sel_tracking = False
        txtEndX.Text = e.X.ToString
        txtEndY.Text = e.Y.ToString

        'upX & upY are NEEDED do not delete, used for figuring coordinates
        upX = e.X
        upY = e.Y
    End Sub

    Private Sub PictureBox1_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles PictureBox1.MouseMove
        'THIS routine does draw an expanding dashed rectangle correctly
        If sel_tracking = True Then
            ' this routine to draw the Dashed line rectangel is all over the internet
            'don't know who first posted it
            ControlPaint.DrawReversibleFrame( _
                         New Rectangle(m_RubberPoint1.X, m_RubberPoint1.Y, _
                         -(m_RubberPoint1.X - m_RubberPoint2.X), _
                         -(m_RubberPoint1.Y - m_RubberPoint2.Y)), _
                         Me.BackColor, FrameStyle.Dashed)
            'set the new point
            m_RubberPoint2 = PictureBox1.MousePosition
            'draw new line
            ControlPaint.DrawReversibleFrame( _
            New Rectangle(m_RubberPoint1.X, m_RubberPoint1.Y, _
            -(m_RubberPoint1.X - m_RubberPoint2.X), _
            -(m_RubberPoint1.Y - m_RubberPoint2.Y)), _
            Me.BackColor, FrameStyle.Dashed)



        End If
    End Sub

    Private Sub mnuClear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuClear.Click
        If PictureBox1.Image Is Nothing Then
            Exit Sub
        Else
            PictureBox1.Image.Dispose()
            PictureBox1.Visible = False
        End If
        txtStartX.Text = ""
        txtStartY.Text = ""
        txtEndX.Text = ""
        txtEndY.Text = ""

    End Sub

    Private Sub btnCrop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCrop.Click
        imgUndo = PictureBox1.Image
        btnUndo.Enabled = True
        'this section of If then, ElseIf statements checks all possible starting and ending points
        'in the selecton area and converts them to the Normal Rectangle drawing coordinates
        ' eg: 0,0 (Upper Left Corner......... 30,30 Lower Right Corner, that way drawing a 
        'New Rectangle for the Cropped area will have the correct starting and ending points
        If downX > upX And downY > upY Then
            'start in lower right to upper left corner
            upperLeftX = upX
            upperLeftY = upY
            lowerRightX = downX
            lowerRightY = downY

        ElseIf downX < upX And downY > upY Then
            'start lower left corner to upper right corner
            upperLeftX = downX
            upperLeftY = upY
            lowerRightX = upX
            lowerRightY = downY

        ElseIf downX > upX And downY < upY Then
            'start upper right corner to lower left corner
            upperLeftX = upX
            upperLeftY = downY
            lowerRightX = downX
            lowerRightY = upY

        Else
            'normal upper left corner to lower right corner
            'this is the default behavior expected , starting with 
            'Upper left X & Y and ending with Lower Right X & Y
            ' downX < UpX and downY is < upY
            upperLeftX = downX ' starting pointx
            upperLeftY = downY ' starting pointy
            lowerRightX = upX  ' ending pointx
            lowerRightY = upY  'ending pointy

        End If
        'this could be shortened up, but it puts the Starting X & Y coordinates and the
        'ending X & Y coordinates in four textboxes that get converted to Intgers for
        'drawing the new Rectangle
        txtStartX.Text = upperLeftX.ToString
        txtStartY.Text = upperLeftY.ToString
        txtEndX.Text = lowerRightX.ToString
        txtEndY.Text = lowerRightY.ToString
        'this bit of code calculates the Width and Height for the new bitmap
        'created after cropping an image
        txtWidth.Text = (lowerRightX - upperLeftX).ToString
        txtHeight.Text = (lowerRightY - upperLeftY).ToString
        'now we can crop image from ANY Starting and Ending point
        Dim recSource As New Rectangle(CInt(txtStartX.Text), CInt(txtStartY.Text), _
        CInt(txtEndX.Text), CInt(txtEndY.Text))
        Dim bmpcropped As New Bitmap(CInt(txtWidth.Text), CInt(txtHeight.Text))

        Dim grBitmap As Graphics = Graphics.FromImage(bmpcropped)
        grBitmap.DrawImage(PictureBox1.Image, 0, 0, recSource, GraphicsUnit.Pixel)
        PictureBox1.Height = bmpcropped.Height
        PictureBox1.Width = bmpcropped.Width
        PictureBox1.Image = bmpcropped
        txtStartX.Text = ""
        txtStartY.Text = ""
        txtEndX.Text = ""
        txtEndY.Text = ""
        sel_selection = Nothing
        btnCrop.Enabled = False
    End Sub

    Private Sub btnUndo_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnUndo.Click
        'as the name indicates, this routine undoes a cropping and resets the image 
        'to it's original deminsions
        PictureBox1.Image = imgUndo
        PictureBox1.Height = imgUndo.Height
        PictureBox1.Width = imgUndo.Width
        btnUndo.Enabled = False
        txtStartX.Text = ""
        txtStartY.Text = ""
        txtEndX.Text = ""
        txtEndY.Text = ""
        txtHeight.Text = ""
        txtWidth.Text = ""
        upX = 0
        upY = 0
        downX = 0
        downY = 0
        btnCrop.Enabled = True
    End Sub
End Class
