using System;
using System.Xml.Serialization;
using System.Drawing;
using System.Diagnostics;
using Microsoft.Ink;
using System.Xml;
using System.IO;
using System.Collections;

//using System.Xml.Serialization;


namespace appInk.PictorialLoginCtrl
{
	/// <summary>
	/// 
	/// </summary>
	public class User
	{
		[XmlAttribute("UserName")]
		public string username;

		[XmlAttribute("Signature")]
		public string SignatureData
		{
			get
			{
				byte[] bytes = _signature.Save(PersistenceFormat.Base64InkSerializedFormat);
				string ink = Convert.ToBase64String(bytes);
                
				return ink;
			}
			set
			{
				string ink = value;
				_signature = new Ink();
				_signature.Load(Convert.FromBase64String(ink));
            }
		}

		private Ink _signature;

		[XmlIgnore]
		public Ink Signature
		{
			get { return _signature; }
			set { _signature = value; }
		}

		[XmlArrayAttribute("PictPasses")]
		public PictPass[] passes;

		public User()
		{
		}

		public void ToXML(string xmlfile, bool append)
		{
			if (append==false)
			{
				User.ToXML(new User[]{this}, xmlfile);
			}
			else
			{
				User[] users = User.FromXML(xmlfile);
				
				ArrayList arrUsers;
				if (users!=null)
				{
					arrUsers = new ArrayList(users.Length+1);
					foreach(User user in users)
						arrUsers.Add(user);
				}
				else
					arrUsers = new ArrayList();

				arrUsers.Add(this);

				User[] newusers = (User[]) (arrUsers.ToArray(typeof(User)));
				User.ToXML(newusers, xmlfile);
			}
		}

		public static void ToXML(User[] users, string xmlfile)
		{
			XmlSerializer serializer = 
				new XmlSerializer(typeof(User[]));
			TextWriter writer = new StreamWriter(xmlfile);
				
			serializer.Serialize(writer, users);
			writer.Close();
		}

		public static User[] FromXML(string xmlfile)
		{
			User[] users = null;

			XmlSerializer serializer = 
				new XmlSerializer(typeof(User[]));
			try
			{
				FileStream fs = new FileStream(xmlfile, FileMode.Open);
		
				users = (User[]) serializer.Deserialize(fs);
				fs.Close();
			}
			catch{}
			
			return users;
		}
	}

	
	public class Picture
	{
		public Picture()
		{
			_image = null;
		}

//		public Picture( Bitmap bitmap )
//		{
//			_image = bitmap;
//			Width = bitmap.Width;
//			Height = bitmap.Height;
//		}

		[XmlAttribute("PictId")]
		public int pictid;

		private string pictpath;

		[XmlAttribute("PictPath")]
		public string PictPath
		{
			get{ return pictpath; }
			set
			{
				pictpath = value;
				if (_image==null)
					_image = Image.FromFile(pictpath);
			}
		}


		[XmlIgnore]
		//[XmlElementAttribute("PictInfo")]
		public string PictInfo
		{		
			get
			{
				try
				{
					MemoryStream memStream = new MemoryStream();
					_image.Save(memStream, _image.RawFormat);
					//_image.Save(memStream, System.Drawing.Imaging.ImageFormat.Bmp);
					//memStream.Position = 0;
					byte[] bytes = memStream.ToArray();
					string img = Convert.ToBase64String(bytes) ;
					memStream.Close();
					return img;
				}
				catch
				{
					return "INVALID";
				}
			}
			set
			{
				string img = value;

				MemoryStream memStream2 = new MemoryStream(Convert.FromBase64String(img));
				_image = Image.FromStream(memStream2);
				//_image = new Bitmap(memStream);
				memStream2.Close();
			}
		}

		// Fields are deserialized before properties
		//public int Width;
		//public int Height;

//		//[XmlIgnore]
//		public Byte[] PictData
//		{
//			get
//			{
//				Byte[] pixels = new Byte[ Width*Height*3 ];
//				int i = 0;
//				for( int h = 0; h < Height; h++ )
//				{
//					for( int w = 0; w < Width; w++ )
//					{
//						pixels[ i++ ] = _image.GetPixel( w, h ).R;
//						pixels[ i++ ] = _image.GetPixel( w, h ).G;
//						pixels[ i++ ] = _image.GetPixel( w, h ).B;
//					}
//				}
//				return pixels;
//			}
//
//			set
//			{
//				Byte[] pixels = value;
//				if( null == _image )
//				{
//					_image = new Bitmap( Width, Height );
//				}
//				int i = 0;
//				for( int h = 0; h < Height; h++ )
//				{
//					for( int w = 0; w < Width; w++ )
//					{
//						Color color = Color.FromArgb( pixels[ i++ ], pixels[
//							i++ ], pixels[ i++ ]);
//						_image.SetPixel( w, h, color );
//					}
//				}
//			}
//		}
	    
		private Image _image;
		//private Bitmap _image;

		// Fields are deserialized before properties
		[XmlIgnore]
		public Image Image
		//public Bitmap Pict
		{
			get{ return _image; }
			set{ _image = value; }
		}
		
		public void ToXML(string xmlfile, bool append)
		{
			if (append==false)
			{
				Picture.ToXML(new Picture[]{this}, xmlfile);
			}
			else
			{
				Picture[] picts = Picture.FromXML(xmlfile);

				ArrayList arrPicts;
				if (picts!=null)
				{
					arrPicts = new ArrayList(picts.Length+1);
					foreach(Picture pict in picts)
						arrPicts.Add(pict);
				}
				else
					arrPicts = new ArrayList();

				arrPicts.Add(this);

				Picture[] newpicts = (Picture[]) (arrPicts.ToArray(typeof(Picture)));
				Picture.ToXML(newpicts, xmlfile);
			}
		}

		public static void ToXML(Picture[] picts, string xmlfile)
		{
			XmlSerializer serializer = 
				new XmlSerializer(typeof(Picture[]));
			TextWriter writer = new StreamWriter(xmlfile);
			
			serializer.Serialize(writer, picts);
			writer.Close();
		}

		public static Picture[] FromXML(string xmlfile)
		{
			Picture[] picts = null;

			XmlSerializer serializer = 
				new XmlSerializer(typeof(Picture[]));
			try
			{
				FileStream fs = new FileStream(xmlfile, FileMode.Open);
		
				picts = (Picture[])serializer.Deserialize(fs);
				fs.Close();
			}
			catch{}

			return picts;
		}
	}

	
	public class PictPass
	{
		[XmlAttribute("PictId")]
		public int pictid;

		[XmlArrayAttribute("SpotSequence")]
		public PassSpot[] spots;

		public PictPass()
		{
		}

		static public int Verify(PictPass pass1, PictPass pass2)
		{
			// Score scale from 0 to 100, not really implemented, simple check only

			if ((pass1.pictid != pass2.pictid) 
				/*||(pass1.userid != pass2.userid)*/)
				return 0;

			if (pass1.spots.Length != pass2.spots.Length)
				return 0;

			int area;
			for (int i=0; i<pass1.spots.Length; i++)
			{
				Rectangle rect1 = new Rectangle( 
					new Point((int)(pass1.spots[i].pt.X - pass1.spots[i].dx),
							(int)(pass1.spots[i].pt.Y - pass1.spots[i].dy)),
					new Size((int)(2*pass1.spots[i].dx), (int)(2*pass1.spots[i].dy))
					);

				Debug.WriteLine("Template: Spot " + i.ToString()
					+ " Pos=(" + pass1.spots[i].pt.X.ToString()
					+ "," + pass1.spots[i].pt.Y.ToString() + ") Shift=("
					+ pass1.spots[i].dx.ToString() + ", "
					+ pass1.spots[i].dy.ToString() + ") Area="
					+ (4*pass1.spots[i].dx*pass1.spots[i].dy).ToString());			

				
				if (pass2.spots[i].dx <= 2 || pass2.spots[i].dy <= 2)
				{
					pass2.spots[i].dx = 13;
					pass2.spots[i].dy = 13;
				}

				Rectangle rect2 = new Rectangle( 
					new Point((int)(pass2.spots[i].pt.X - pass2.spots[i].dx),
					(int)(pass2.spots[i].pt.Y - pass2.spots[i].dy)),
					new Size((int)(2*pass2.spots[i].dx), (int)(2*pass2.spots[i].dy))
					);

				Debug.WriteLine("Current: Spot " + i.ToString()
					+ " Pos=(" + pass2.spots[i].pt.X.ToString()
					+ "," + pass2.spots[i].pt.Y.ToString() + ") Shift=("
					+ pass2.spots[i].dx.ToString() + ", "
					+ pass2.spots[i].dy.ToString() + ") Area="
					+ (4*pass2.spots[i].dx*pass2.spots[i].dy).ToString());			


				Rectangle intersect = rect1;
				intersect.Intersect(rect2);
				area = intersect.Width * intersect.Height;

				Debug.WriteLine("Spot " + i.ToString()
					+ " Intersection Area=" + area.ToString());			
				
				// Givent the simplest check algorithm
				if (area < 0.5*(4*pass1.spots[i].dx*pass1.spots[i].dy)
					|| 1.8*area < (4*pass2.spots[i].dx*pass2.spots[i].dy)
					)
				{
					Debug.Indent();
					Debug.WriteLine("Invalid");
					Debug.Unindent();
					return 0;
				}
			}

			return 100;
		}

		public void ToXML(string xmlfile, bool append)
		{
			if (append==false)
			{
				PictPass.ToXML(new PictPass[]{this}, xmlfile);
			}
			else
			{
				PictPass[] passes = PictPass.FromXML(xmlfile);

				ArrayList arrPasses;
				
				if (passes!=null)
				{
					arrPasses = new ArrayList(passes.Length+1);
					foreach(PictPass pict in passes)
						arrPasses.Add(pict);
				}
				else
					arrPasses = new ArrayList();

				arrPasses.Add(this);

				Picture[] newpasses = (Picture[]) (arrPasses.ToArray(typeof(Picture)));
				Picture.ToXML(newpasses, xmlfile);
			}

		}

		public static void ToXML(PictPass[] passes, string xmlfile)
		{
			XmlSerializer serializer = 
				new XmlSerializer(typeof(PictPass[]));
			TextWriter writer = new StreamWriter(xmlfile);
		
			serializer.Serialize(writer, passes);
			writer.Close();
		}

		static public PictPass[] FromXML(string xmlfile)
		{
			PictPass[] passes=null;

			XmlSerializer serializer = 
				new XmlSerializer(typeof(PictPass[]));
			try
			{
				FileStream fs = new FileStream(xmlfile, FileMode.Open);
		
				passes = (PictPass[]) serializer.Deserialize(fs);
				fs.Close();
			}
			catch{}

			return passes;
		}
	}

	public class PassSpot
	{
		[XmlElementAttribute("CenterPt")]
		public Point pt;
		[XmlElementAttribute("XExtend")]
		public float dx;
		[XmlElementAttribute("YExtend")]
		public float dy;

		public PassSpot()
		{
		}
	}
}