using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using Microsoft.Ink;
using System.Xml.Serialization;
using System.IO;
using System.Diagnostics;

namespace appInk.PictorialLoginCtrl
{
	/// <summary>
	/// Summary description for PictorialLoginCtrl.
	/// </summary>
	public class PictorialLoginCtrl : System.Windows.Forms.UserControl
	{
		private Microsoft.Ink.InkPicture inkPictUser;
		private Microsoft.Ink.InkPicture inkPictPass;
		private System.Windows.Forms.Button btnPrevUser;
		private System.Windows.Forms.Button btnNextUser;
		private System.Windows.Forms.Button btnNextPict;
		private System.Windows.Forms.Button btnPrevPict;
		private System.Windows.Forms.Button btnLogin;
		private System.Windows.Forms.Button btnSave;
		private System.Windows.Forms.Button btnRegister;
		private System.Windows.Forms.LinkLabel lblSwitch;
		
		private Picture[] picts = null;
		private int pictIndex = 0;
		private User[] users = null;
		private int userIndex = 0;

		private string userdbPath;
		//private string passdbPath;

		private bool showInk;

		private Mode mode;
		private PictPass memPass;

		private User newuser = null;
		private ArrayList newpasses = new ArrayList();
		private System.Windows.Forms.Button btnClearUser;
		private System.Windows.Forms.Button btnClearPass;
		private System.Windows.Forms.Label lblHeader;
		private System.Windows.Forms.ErrorProvider errorMsg;
		private System.Windows.Forms.Label lblStatus;
		private System.Windows.Forms.Label lblInstruction;		

		
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public PictorialLoginCtrl()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			// TODO: Add any initialization after the InitComponent call

		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if( components != null )
					components.Dispose();
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.inkPictPass = new Microsoft.Ink.InkPicture();
			this.inkPictUser = new Microsoft.Ink.InkPicture();
			this.btnPrevUser = new System.Windows.Forms.Button();
			this.btnNextUser = new System.Windows.Forms.Button();
			this.btnNextPict = new System.Windows.Forms.Button();
			this.btnPrevPict = new System.Windows.Forms.Button();
			this.btnLogin = new System.Windows.Forms.Button();
			this.lblSwitch = new System.Windows.Forms.LinkLabel();
			this.btnSave = new System.Windows.Forms.Button();
			this.btnRegister = new System.Windows.Forms.Button();
			this.btnClearUser = new System.Windows.Forms.Button();
			this.btnClearPass = new System.Windows.Forms.Button();
			this.lblHeader = new System.Windows.Forms.Label();
			this.errorMsg = new System.Windows.Forms.ErrorProvider();
			this.lblStatus = new System.Windows.Forms.Label();
			this.lblInstruction = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// inkPictPass
			// 
			this.inkPictPass.Anchor = System.Windows.Forms.AnchorStyles.Bottom;
			this.inkPictPass.BackColor = System.Drawing.SystemColors.Window;
			this.inkPictPass.Location = new System.Drawing.Point(16, 136);
			this.inkPictPass.MarginX = -2147483648;
			this.inkPictPass.MarginY = -2147483648;
			this.inkPictPass.Name = "inkPictPass";
			this.inkPictPass.Size = new System.Drawing.Size(588, 348);
			this.inkPictPass.TabIndex = 0;
			this.inkPictPass.Stroke += new Microsoft.Ink.InkCollectorStrokeEventHandler(this.inkPictPass_Stroke);
			// 
			// inkPictUser
			// 
			this.inkPictUser.Anchor = System.Windows.Forms.AnchorStyles.Top;
			this.inkPictUser.BackColor = System.Drawing.SystemColors.Window;
			this.inkPictUser.Location = new System.Drawing.Point(16, 40);
			this.inkPictUser.MarginX = -2147483648;
			this.inkPictUser.MarginY = -2147483648;
			this.inkPictUser.Name = "inkPictUser";
			this.inkPictUser.Size = new System.Drawing.Size(456, 88);
			this.inkPictUser.TabIndex = 1;
			// 
			// btnPrevUser
			// 
			this.btnPrevUser.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.btnPrevUser.Location = new System.Drawing.Point(480, 80);
			this.btnPrevUser.Name = "btnPrevUser";
			this.btnPrevUser.Size = new System.Drawing.Size(24, 23);
			this.btnPrevUser.TabIndex = 2;
			this.btnPrevUser.Text = "-";
			this.btnPrevUser.Click += new System.EventHandler(this.btnPrevUser_Click);
			// 
			// btnNextUser
			// 
			this.btnNextUser.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.btnNextUser.Location = new System.Drawing.Point(480, 104);
			this.btnNextUser.Name = "btnNextUser";
			this.btnNextUser.Size = new System.Drawing.Size(24, 24);
			this.btnNextUser.TabIndex = 2;
			this.btnNextUser.Text = "+";
			this.btnNextUser.Click += new System.EventHandler(this.btnNextUser_Click);
			// 
			// btnNextPict
			// 
			this.btnNextPict.Anchor = (System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right);
			this.btnNextPict.Location = new System.Drawing.Point(608, 464);
			this.btnNextPict.Name = "btnNextPict";
			this.btnNextPict.Size = new System.Drawing.Size(24, 23);
			this.btnNextPict.TabIndex = 2;
			this.btnNextPict.Text = "+";
			this.btnNextPict.Click += new System.EventHandler(this.btnNextPict_Click);
			// 
			// btnPrevPict
			// 
			this.btnPrevPict.Anchor = (System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right);
			this.btnPrevPict.Location = new System.Drawing.Point(608, 440);
			this.btnPrevPict.Name = "btnPrevPict";
			this.btnPrevPict.Size = new System.Drawing.Size(24, 23);
			this.btnPrevPict.TabIndex = 2;
			this.btnPrevPict.Text = "-";
			this.btnPrevPict.Click += new System.EventHandler(this.btnPrevPict_Click);
			// 
			// btnLogin
			// 
			this.btnLogin.Anchor = System.Windows.Forms.AnchorStyles.Bottom;
			this.btnLogin.Location = new System.Drawing.Point(16, 496);
			this.btnLogin.Name = "btnLogin";
			this.btnLogin.Size = new System.Drawing.Size(56, 24);
			this.btnLogin.TabIndex = 3;
			this.btnLogin.Text = "Login";
			this.btnLogin.Click += new System.EventHandler(this.btnLogin_Click);
			// 
			// lblSwitch
			// 
			this.lblSwitch.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.lblSwitch.Location = new System.Drawing.Point(480, 8);
			this.lblSwitch.Name = "lblSwitch";
			this.lblSwitch.Size = new System.Drawing.Size(168, 16);
			this.lblSwitch.TabIndex = 4;
			this.lblSwitch.TabStop = true;
			this.lblSwitch.Text = "Switch UI";
			this.lblSwitch.TextAlign = System.Drawing.ContentAlignment.TopRight;
			this.lblSwitch.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.lblNewUser_LinkClicked);
			// 
			// btnSave
			// 
			this.btnSave.Anchor = System.Windows.Forms.AnchorStyles.Bottom;
			this.btnSave.Location = new System.Drawing.Point(72, 496);
			this.btnSave.Name = "btnSave";
			this.btnSave.Size = new System.Drawing.Size(56, 24);
			this.btnSave.TabIndex = 5;
			this.btnSave.Text = "Save";
			this.btnSave.Click += new System.EventHandler(this.btnSave_Click);
			// 
			// btnRegister
			// 
			this.btnRegister.Anchor = System.Windows.Forms.AnchorStyles.Bottom;
			this.btnRegister.Location = new System.Drawing.Point(128, 496);
			this.btnRegister.Name = "btnRegister";
			this.btnRegister.Size = new System.Drawing.Size(56, 24);
			this.btnRegister.TabIndex = 5;
			this.btnRegister.Text = "Finish";
			this.btnRegister.Click += new System.EventHandler(this.btnRegister_Click);
			// 
			// btnClearUser
			// 
			this.btnClearUser.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.btnClearUser.Location = new System.Drawing.Point(480, 56);
			this.btnClearUser.Name = "btnClearUser";
			this.btnClearUser.Size = new System.Drawing.Size(24, 23);
			this.btnClearUser.TabIndex = 2;
			this.btnClearUser.Text = "X";
			this.btnClearUser.Click += new System.EventHandler(this.btnClearUser_Click);
			// 
			// btnClearPass
			// 
			this.btnClearPass.Anchor = (System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right);
			this.btnClearPass.Location = new System.Drawing.Point(608, 416);
			this.btnClearPass.Name = "btnClearPass";
			this.btnClearPass.Size = new System.Drawing.Size(24, 23);
			this.btnClearPass.TabIndex = 2;
			this.btnClearPass.Text = "X";
			this.btnClearPass.Click += new System.EventHandler(this.btnClearPass_Click);
			// 
			// lblHeader
			// 
			this.lblHeader.Font = new System.Drawing.Font("Verdana", 12F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblHeader.ForeColor = System.Drawing.SystemColors.HotTrack;
			this.lblHeader.Location = new System.Drawing.Point(16, 8);
			this.lblHeader.Name = "lblHeader";
			this.lblHeader.Size = new System.Drawing.Size(96, 32);
			this.lblHeader.TabIndex = 6;
			this.lblHeader.Text = "Register";
			// 
			// lblStatus
			// 
			this.lblStatus.ForeColor = System.Drawing.Color.Crimson;
			this.errorMsg.SetIconAlignment(this.lblStatus, System.Windows.Forms.ErrorIconAlignment.TopLeft);
			this.lblStatus.Location = new System.Drawing.Point(192, 504);
			this.lblStatus.Name = "lblStatus";
			this.lblStatus.Size = new System.Drawing.Size(408, 32);
			this.lblStatus.TabIndex = 7;
			// 
			// lblInstruction
			// 
			this.lblInstruction.Location = new System.Drawing.Point(160, 8);
			this.lblInstruction.Name = "lblInstruction";
			this.lblInstruction.Size = new System.Drawing.Size(312, 32);
			this.lblInstruction.TabIndex = 8;
			// 
			// PictorialLoginCtrl
			// 
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.lblInstruction,
																		  this.lblStatus,
																		  this.lblHeader,
																		  this.btnSave,
																		  this.lblSwitch,
																		  this.btnLogin,
																		  this.btnPrevUser,
																		  this.inkPictUser,
																		  this.inkPictPass,
																		  this.btnNextUser,
																		  this.btnNextPict,
																		  this.btnPrevPict,
																		  this.btnRegister,
																		  this.btnClearUser,
																		  this.btnClearPass});
			this.Name = "PictorialLoginCtrl";
			this.Size = new System.Drawing.Size(656, 552);
			this.Load += new System.EventHandler(this.PictorialLoginCtrl_Load);
			this.Paint += new System.Windows.Forms.PaintEventHandler(this.PictorialLoginCtrl_Paint);
			this.Layout += new System.Windows.Forms.LayoutEventHandler(this.PictorialLoginCtrl_Layout);
			this.ResumeLayout(false);

		}
		#endregion

		public Picture[] Pictures
		{
			get { return picts; }
			set { picts = value;}
		}

		/*
		public User[] Users
		{
			get { return users; }
			set { users = value; }
		}
		*/

		/*
		public int PictureIndex 
		{
			get { return pictIndex; }
			set { pictIndex = value; }
		}
		*/

		/*
		public int UserIndex
		{
			get { return userIndex; }
			set { userIndex = value; }
		}
		*/
		
		public string UserDbPath
		{
			get { return userdbPath; }
			set 
			{ 
				userdbPath = value;
				if (userdbPath!=null)
					users = User.FromXML(userdbPath);
				userIndex = 0;
				UpdatePrevNext();
			}
		}

		public bool ShowInk
		{
			get { return showInk; }
			set { showInk = value; }
		}
	
		/*
		public string PassDbPath
		{
			get { return passdbPath; }
			set { passdbPath = value; }
		}
		*/


		private PictPass GetPictPassFromStrokes(Strokes strokes)
		{
			PictPass pass = new PictPass();

			//pass.userid = 1;
			pass.pictid = 1;
			
			PassSpot[] spots = new PassSpot[strokes.Count];

			for (int i=0; i<strokes.Count; i++)
			{
				spots[i] = new PassSpot();
			
				Point[] pts = strokes[i].GetPoints();

				Rectangle rect =
					strokes[i].GetBoundingBox(BoundingBoxMode.CurveFit);

				spots[i].pt.X = (rect.Left + rect.Right) / 2;
				spots[i].pt.Y = (rect.Top + rect.Bottom) / 2;
				Graphics g = CreateGraphics();
				inkPictPass.Renderer.InkSpaceToPixel(g, ref spots[i].pt);
				
				InkSpaceToRect(g, ref rect);
				g.Dispose();

				// Point form
				if (rect.Width <= 4 && rect.Height <= 4)
				{
					rect.Width = 26;
					rect.Height = 26;
				}

				spots[i].dx = rect.Width / 2.0f;
				spots[i].dy = rect.Height / 2.0f;
			}
			pass.spots = spots;

			return pass;
		}

		private void InkSpaceToRect(Graphics g, ref Rectangle rect)
		{
			Rectangle inkRect = rect;

			Point ptTL, ptBR;
			ptTL = ptBR = inkRect.Location;
			ptBR += inkRect.Size;

			inkPictPass.Renderer.InkSpaceToPixel(g, ref ptTL);
			inkPictPass.Renderer.InkSpaceToPixel(g, ref ptBR);

			rect = Rectangle.FromLTRB(ptTL.X,ptTL.Y, 
				ptBR.X, ptBR.Y);
		}

		private void PictorialLoginCtrl_Load(object sender, System.EventArgs e)
		{
			/*
			Stream debugFile = File.Create("C:\\DebugPictPass.txt");			
			TextWriterTraceListener listener = new TextWriterTraceListener(debugFile);
			Debug.Listeners.Add(listener);
			Debug.AutoFlush = true;
			*/

			mode = Mode.Verify;
			ChangeUI();
		}

		private void PictorialLoginCtrl_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			Graphics g = e.Graphics;
			g.DrawRectangle(new Pen(Color.Black, 2), new Rectangle(0, 0, Size.Width, Size.Height));

			if (picts != null && picts.Length>0 )
				inkPictPass.Image = picts[pictIndex].Image;

			if (users != null && users.Length>0 
				&& inkPictUser.InkEnabled == false && mode == Mode.Verify)
			{
				inkPictUser.Ink = users[userIndex].Signature.Clone();
				inkPictUser.Refresh();
			}
			else if ( inkPictUser.InkEnabled == false
				&& (mode == Mode.RegisterConfirm || mode == Mode.RegisterDraft)
				&& newuser.Signature != null)
			{
				inkPictUser.Ink = newuser.Signature.Clone();
				inkPictUser.Refresh();
			}
			else
			{
				inkPictUser.Refresh();
			}
		}
		
		private void btnPrevUser_Click(object sender, System.EventArgs e)
		{
			lblStatus.Text = "";
			errorMsg.SetError(lblStatus, "");
			
			if (users != null && users.Length>0)
			{
				userIndex -= 1;
				if (userIndex < 0)
					userIndex = 0;
		
				inkPictUser.Ink = users[userIndex].Signature.Clone();
				inkPictUser.Refresh();
			}

			UpdatePrevNext();
		}

		private void btnNextUser_Click(object sender, System.EventArgs e)
		{
			lblStatus.Text = "";
			errorMsg.SetError(lblStatus, "");

			if (users != null && users.Length>0 )
			{
				userIndex += 1;
				if (userIndex >= users.Length)
					userIndex = users.Length - 1;

				inkPictUser.Ink = users[userIndex].Signature.Clone();
				inkPictUser.Refresh();
			}

			UpdatePrevNext();
		}

		private void btnPrevPict_Click(object sender, System.EventArgs e)
		{
			lblStatus.Text = "";
			errorMsg.SetError(lblStatus, "");

			int oldIndex = pictIndex;
			if (picts != null && picts.Length>0 )
			{
				pictIndex -= 1;
				if (pictIndex < 0)
					pictIndex = 0;
		
				inkPictPass.Image = picts[pictIndex].Image;
			}
			if (pictIndex != oldIndex)
			{
				inkPictPass.Size = inkPictPass.Image.Size;
				inkPictPass.Ink.DeleteStrokes();
				inkPictPass.Refresh();
			}
			
			UpdatePrevNext();
		}

		private void btnNextPict_Click(object sender, System.EventArgs e)
		{
			lblStatus.Text = "";
			errorMsg.SetError(lblStatus, "");

			int oldIndex = pictIndex;
			if (picts != null && picts.Length>0 )
			{
				pictIndex += 1;
				if (pictIndex >= picts.Length)
					pictIndex = picts.Length - 1;

				inkPictPass.Image = picts[pictIndex].Image;
			}
			if (pictIndex != oldIndex)
			{
				inkPictPass.Ink.DeleteStrokes();
				inkPictPass.Refresh();
			}

			UpdatePrevNext();
		}

		private void UpdatePrevNext()
		{
			if (mode != Mode.Verify)
			{
				btnPrevUser.Enabled = false;
				btnNextUser.Enabled = false;
			}
			else
			{
				btnPrevUser.Enabled = true;
				btnNextUser.Enabled = true;

				if (users==null)
				{
					btnPrevUser.Enabled = false;
					btnNextUser.Enabled = false;
				}
				else
				{
					if (userIndex<=0)
						btnPrevUser.Enabled = false;
					else
						btnPrevUser.Enabled = true;
					if (userIndex>=users.Length-1)
						btnNextUser.Enabled = false;
					else
						btnNextUser.Enabled = true;
				}
			}

			if (picts==null)
			{
				btnPrevPict.Enabled = false;
				btnNextPict.Enabled = false;
			}
			else
			{
				if (pictIndex<=0)
					btnPrevPict.Enabled = false;
				else
					btnPrevPict.Enabled = true;
				if (pictIndex>=picts.Length-1)
					btnNextPict.Enabled = false;
				else
					btnNextPict.Enabled = true;
			}
		}

		private void ChangeUI()
		{
			if (mode == Mode.RegisterDraft)
			{
				lblHeader.Text = "Register";
				if (inkPictUser.InkEnabled)
				{
					lblInstruction.Text = "Write your preferred username, spot-mark the image with circles and click on Save to register.";
					btnClearUser.Enabled = true;
				}
				
				inkPictPass.Ink.DeleteStrokes();
				inkPictPass.Refresh();
				
				btnSave.Visible = true;
				btnSave.Enabled = true;
				btnSave.Text = "Save";

				btnLogin.Visible = false;
				btnLogin.Enabled = false;

				lblSwitch.Text = "Cancel Registration";
			}
			else if (mode == Mode.Verify
				|| mode == Mode.RegisterConfirm)
			{
				inkPictUser.InkEnabled = false;

				lblInstruction.Text = "Select your username and one image, spot-mark the image with circles to login.";
				
				inkPictPass.Ink.DeleteStrokes();
				inkPictPass.Refresh();
				
				btnClearUser.Enabled = false;
				
				btnRegister.Visible = false;
				btnRegister.Enabled = false;

				if (mode == Mode.RegisterConfirm)
				{
					lblHeader.Text = "Register";
					btnSave.Visible = true;
					btnSave.Enabled = true;
					btnSave.Text = "Confirm";
				
					btnLogin.Visible = false;
					btnLogin.Enabled = false;
				
					lblSwitch.Text = "Cancel Registration";
					// userIndex is not relevant
				}
				else if (mode == Mode.Verify)
				{
					lblHeader.Text = "Login";

					btnSave.Visible = false;
					btnSave.Enabled = false;
					btnSave.Text = "Confirm";
				
					btnLogin.Visible = true;
					btnLogin.Enabled = true;
				
					lblSwitch.Text = "New User? Register Now!";
					// Load the very last user signature
					if (users!=null && users.Length > 0)
					{
						userIndex = users.Length - 1;
					}
				}
			}

			UpdatePrevNext();
		}

		private void lblNewUser_LinkClicked(object sender, System.Windows.Forms.LinkLabelLinkClickedEventArgs e)
		{
			lblStatus.Text = "";
			errorMsg.SetError(lblStatus, "");

			if (mode==Mode.Verify)
			{
				mode = Mode.RegisterDraft;
				inkPictUser.Ink.DeleteStrokes();
				inkPictUser.InkEnabled = true;
				inkPictUser.Refresh();
				Refresh();
				newuser = new User();
				newpasses.Clear();
			}
			else if (mode==Mode.RegisterDraft
				|| mode==Mode.RegisterConfirm)
			{
				mode = Mode.Verify;
				newuser = null;
				// Registration is aborted
				inkPictUser.InkEnabled = false;
				inkPictUser.Ink.DeleteStrokes();
				inkPictUser.Refresh();
				Refresh();
			}
			ChangeUI();
		}

		private void btnRegister_Click(object sender, System.EventArgs e)
		{
			lblStatus.Text = "";
			errorMsg.SetError(lblStatus, "");

			if (newpasses.Count <= 0)
			{
				//MessageBox.Show("You have not registered for any image yet.");
				//errorMsg.SetError(inkPictPass, "You have not registered for any image yet.");
				//errorMsg.SetIconAlignment(inkPictPass, ErrorIconAlignment.TopRight);
				lblStatus.Text = "You have not registered for any image yet.";
				errorMsg.SetError(lblStatus, lblStatus.Text);
				return;
			}

			newuser.passes = (PictPass[])(newpasses.ToArray(typeof(PictPass)));
			newuser.ToXML(userdbPath, true);

			UserDbPath = userdbPath;

			mode = Mode.Verify;
			ChangeUI();
		}

		private void btnSave_Click(object sender, System.EventArgs e)
		{
			lblStatus.Text = "";
			errorMsg.SetError(lblStatus, "");

			if (newuser.Signature == null)
			{
				if (inkPictUser.Ink.Strokes.Count <= 0)
				{
					//MessageBox.Show("Please write down your preferred username first.");
					//errorMsg.SetError(inkPictUser, "Please write down your preferred username first.");
					//errorMsg.SetIconAlignment(inkPictUser, ErrorIconAlignment.TopRight);
					lblStatus.Text = "Please write down your preferred username first.";
					errorMsg.SetError(lblStatus, lblStatus.Text);
					return;
				}
				newuser.Signature = inkPictUser.Ink.Clone();
			}

			switch (mode)
			{
				case Mode.RegisterDraft:
				{
					if (inkPictPass.Ink.Strokes.Count <= 0)
					{
						//MessageBox.Show("You have not spot-marked anything on the image. Please try again.");
						//errorMsg.SetError(inkPictPass, "You have not spot-marked anything on the image. Please try again.");
						//errorMsg.SetIconAlignment(inkPictPass, ErrorIconAlignment.TopRight);
						lblStatus.Text = "You have not spot-marked anything on the image. Please try again.";
						errorMsg.SetError(lblStatus, lblStatus.Text);
						return;
					}
					memPass = GetPictPassFromStrokes(inkPictPass.Ink.Strokes);
					memPass.pictid = picts[pictIndex].pictid;
					bool bExisting = false;
					foreach(PictPass pass in newpasses)
					{
						if (pass.pictid == memPass.pictid)
						{
							//MessageBox.Show("You have already registered for this image.");
							//errorMsg.SetError(inkPictPass, "You have already registered for this image.");
							//errorMsg.SetIconAlignment(inkPictPass, ErrorIconAlignment.TopRight);
							lblStatus.Text = "You have already registered for this image.";
							errorMsg.SetError(lblStatus, lblStatus.Text);

							bExisting = true;
							mode = Mode.RegisterDraft;
							ChangeUI();
							break;
						}
					}
					if (!bExisting)
					{
						//MessageBox.Show("Please spot-mark again to verify your registration for this image.") ;
						//errorMsg.SetError(inkPictPass, "Please spot-mark again to verify your registration for this image.");
						//errorMsg.SetIconAlignment(inkPictPass, ErrorIconAlignment.TopRight);
							
						lblStatus.Text = "Please spot-mark again to verify your registration for this image.";
						errorMsg.SetError(lblStatus, lblStatus.Text);
						mode = Mode.RegisterConfirm;
						ChangeUI();
					}
				}
					break;
				case Mode.RegisterConfirm:
				{
					if (inkPictPass.Ink.Strokes.Count <= 0)
					{
						//MessageBox.Show("You have not spot-marked anything on the image. Please try again.");
						//errorMsg.SetError(inkPictPass, "You have not spot-marked anything on the image. Please try again.");
						//errorMsg.SetIconAlignment(inkPictPass, ErrorIconAlignment.TopRight);
						lblStatus.Text = "You have not spot-marked anything on the image. Please try again.";
						errorMsg.SetError(lblStatus, lblStatus.Text);
						return;
					}
					PictPass verifyPass = GetPictPassFromStrokes(inkPictPass.Ink.Strokes);
					verifyPass.pictid =  picts[pictIndex].pictid;
					
					if (PictPass.Verify(memPass, verifyPass)>90)
					{
						//MessageBox.Show("You have successfully completed your registration for this image. Proceed to another image for registration (optional) or click on Finish to end.");
						//errorMsg.SetError(inkPictPass, "You have successfully completed your registration for this image. Proceed to another image for registration (optional) or click on Finish to end.");
						//errorMsg.SetIconAlignment(inkPictPass, ErrorIconAlignment.TopRight);
						lblStatus.Text = "You have successfully completed your registration for this image."
						 + " Proceed to another image for registration (optional) or click on Finish to end.";
						newpasses.Add(memPass);
						mode = Mode.RegisterDraft;
						ChangeUI();

						btnRegister.Visible = true;
						btnRegister.Enabled = true;

						inkPictUser.InkEnabled = false;
					}
					else
					{
						//MessageBox.Show("Verification is not successful. Registration is rolled back. Please try again.");
						//errorMsg.SetError(inkPictPass, "Verification is not successful. Registration is rolled back. Please try again.");
						//errorMsg.SetIconAlignment(inkPictPass, ErrorIconAlignment.TopRight);
						lblStatus.Text = "Verification is not successful. Registration is rolled back. Please try again.";
						errorMsg.SetError(lblStatus, lblStatus.Text);
						
						mode = Mode.RegisterDraft;
						ChangeUI();
					}
				}
					break;
				default :
					MessageBox.Show("Error! Not implemented!");
					break;
			}

		}

		private void btnLogin_Click(object sender, System.EventArgs e)
		{
			lblStatus.Text = "";
			errorMsg.SetError(lblStatus, "");

			switch (mode)
			{
				case Mode.Verify:
				{
					if (inkPictPass.Ink.Strokes.Count <= 0)
					{
						//MessageBox.Show("You have not spot-marked anything on the image. Please try again.");
						//errorMsg.SetError(inkPictPass, "You have not spot-marked anything on the image. Please try again.");
						//errorMsg.SetIconAlignment(inkPictPass, ErrorIconAlignment.TopRight);
						lblStatus.Text = "You have not spot-marked anything on the image. Please try again.";
						errorMsg.SetError(lblStatus, lblStatus.Text);
						return;
					}
					PictPass verifyPass = GetPictPassFromStrokes(inkPictPass.Ink.Strokes);
					verifyPass.pictid =  picts[pictIndex].pictid;

					PictPass targetPass = null;
					foreach (PictPass pass in users[userIndex].passes)
					{
						if (pass.pictid == picts[pictIndex].pictid)
						{
							targetPass = pass;
							break;
						}
					}
					if (targetPass==null)
					{
						//MessageBox.Show("You have not registered for this image.");
						//errorMsg.SetError(inkPictPass, "You have not registered for this image.");
						//errorMsg.SetIconAlignment(inkPictPass, ErrorIconAlignment.TopRight);
						lblStatus.Text = "You have not registered for this image.";
						errorMsg.SetError(lblStatus, lblStatus.Text);
						mode = Mode.Verify;
						ChangeUI();
					}
					else
					{
						inkPictPass.Ink.DeleteStrokes();
						inkPictPass.Refresh();
					
						if (PictPass.Verify(targetPass, verifyPass)>90)
						{
							//MessageBox.Show("Access Granted");
							Graphics g = inkPictPass.CreateGraphics();
							g.DrawString("Access Granted", new Font("Arial", 30), new SolidBrush(Color.Green), 
								inkPictPass.Width/4, inkPictPass.Height/2);
							g.Dispose();

						}
						else
						{
							Graphics g = inkPictPass.CreateGraphics();
							g.DrawString("Access Denied", new Font("Arial", 30), new SolidBrush(Color.Red), 
								inkPictPass.Width/4, inkPictPass.Height/2);
							g.Dispose();
						}
					}
				}
					break;
				default:
					MessageBox.Show("Error! Not implemented!");
					break;
			}
		}

		
		public System.Drawing.Size RequiredSize
		{
			get
			{
				int Margin = 10;
				
				Size sizeUser = new Size();
				Size sizePass = new Size();

				sizeUser = inkPictUser.Size;
				sizePass = inkPictPass.Size;

				if (sizeUser.Width > sizePass.Width)
				{
					sizeUser.Width = sizePass.Width;
					inkPictUser.Size = sizeUser;
				}

				return new Size(
					// Width
					Margin + sizePass.Width 
					+ btnPrevPict.Size.Width + Margin,
					// Height
					Margin + lblHeader.Height + Margin + sizeUser.Height + Margin 
					+ sizePass.Height + Margin +
					btnLogin.Size.Height + Margin);
			}
		}

		private void PictorialLoginCtrl_Layout(object sender, System.Windows.Forms.LayoutEventArgs e)
		{
			int Margin = 10;

			lblHeader.Location = new Point(Margin, Margin);
			lblInstruction.Location = new Point(lblHeader.Right + 2, Margin);
			lblInstruction.Width = inkPictUser.Right - lblHeader.Right;
			
			inkPictUser.Location = new Point(Margin, lblHeader.Bottom+Margin);

			btnPrevUser.Location = new Point(inkPictUser.Right + 2,
				inkPictUser.Bottom - 2 * btnPrevUser.Height);
			btnNextUser.Location = new Point(inkPictUser.Right + 2,
				inkPictUser.Bottom - btnPrevUser.Height);
			btnClearUser.Location = new Point(inkPictUser.Right + 2,
				inkPictUser.Bottom - 3*btnPrevUser.Height - 6);

			inkPictPass.Location = new Point(inkPictUser.Left, 
				inkPictUser.Bottom + Margin);

			btnPrevPict.Location = new Point(inkPictPass.Right + 2,
				inkPictPass.Bottom - 2 * btnPrevPict.Height);
			btnNextPict.Location = new Point(inkPictPass.Right + 2,
				inkPictPass.Bottom - btnPrevPict.Height);
			btnClearPass.Location = new Point(inkPictPass.Right + 2,
				inkPictPass.Bottom - 3 * btnPrevPict.Height - 6);

            btnLogin.Location = new Point(inkPictPass.Left, 
				inkPictPass.Bottom + Margin);
			btnSave.Location = btnLogin.Location;
			btnRegister.Location = new Point(btnSave.Right, 
				inkPictPass.Bottom + Margin);

			lblStatus.Location = new Point(btnRegister.Right + 16, inkPictPass.Bottom + Margin);
			lblStatus.Width = inkPictPass.Right - btnRegister.Right;

			lblSwitch.Location = new Point(this.Size.Width -
				Margin - lblSwitch.Size.Width, 4);

		}

		private void btnClearUser_Click(object sender, System.EventArgs e)
		{
			lblStatus.Text = "";
			errorMsg.SetError(lblStatus, "");

			if (inkPictUser.InkEnabled)
			{
				inkPictUser.Ink.DeleteStrokes();
				inkPictUser.Refresh();
			}
		}

		private void btnClearPass_Click(object sender, System.EventArgs e)
		{
			lblStatus.Text = "";
			errorMsg.SetError(lblStatus, "");

			if (inkPictPass.InkEnabled)
			{
				inkPictPass.Ink.DeleteStrokes();
				inkPictPass.Refresh();
			}
		}

		private void inkPictPass_Stroke(object sender, Microsoft.Ink.InkCollectorStrokeEventArgs e)
		{
			if (!showInk)
			{
				e.Stroke.DrawingAttributes.Transparency = 255;
				inkPictPass.Refresh();
			}
			
		}
	}

	public enum Mode
	{
		Verify = 0,
		RegisterDraft = 1,
		RegisterConfirm = 2
	}
}

