///
///  This source code is freeware and is provided on an "as is" basis without warranties of any kind, 
///  whether express or implied, including without limitation warranties that the code is free of defect, 
///  fit for a particular purpose or non-infringing.  The entire risk as to the quality and performance of 
///  the code is with the end user.
///

using System;
using System.Text.RegularExpressions;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.ContentManagement.WebControls;
using Microsoft.ContentManagement.WebControls.Design;
using Microsoft.ContentManagement.Publishing.Extensions.Placeholders;
using Microsoft.ContentManagement.Publishing;

namespace StefanG.PlaceholderControls
{
	/// <summary>
	/// Summary description for Class1.
	/// </summary>
	[
	ToolboxData("<{0}:RandomImagePlaceholderControl runat=server></{0}:RandomImagePlaceholderControl>"), 
	SupportedPlaceholderDefinitionType(typeof(XmlPlaceholderDefinition))
	]
	public class RandomImagePlaceholderControl : BasePlaceholderControl
	{
		TextBox AuthoringTextBox = null;
		System.Web.UI.WebControls.PlaceHolder PresentationPlaceholder = null;

		public RandomImagePlaceholderControl()
		{
		}

		protected override void CreateAuthoringChildControls(BaseModeContainer authoringContainer)
		{
			// Authoring Mode controls
			Label Headline = new Label();
			Headline.Text = "Please enter Resource Gallery Path that holds the Images<br>";
			authoringContainer.Controls.Add(Headline);

			AuthoringTextBox = new TextBox();
			AuthoringTextBox.EnableViewState = false;
			AuthoringTextBox.ID = "AuthoringTextBox";
			AuthoringTextBox.Width = 300;
			AuthoringTextBox.TextMode = TextBoxMode.SingleLine;
			AuthoringTextBox.AutoPostBack = false;
			authoringContainer.Controls.Add(AuthoringTextBox);
		}

		protected override void CreatePresentationChildControls(BaseModeContainer presentationContainer)
		{
			// Presentation Mode controls
			PresentationPlaceholder = new System.Web.UI.WebControls.PlaceHolder();
			PresentationPlaceholder.ID = "PresentationPlaceholder";
			presentationContainer.Controls.Add(PresentationPlaceholder);
		}

		private string StripTags(string source)
		{
			string strRegExp = "<(.|\n)+?>";
			Regex r = new Regex( strRegExp, RegexOptions.IgnoreCase | RegexOptions.Compiled );
			string strNoTags = r.Replace( source, "" );    
			return System.Web.HttpUtility.HtmlDecode( strNoTags );
		}

		protected override void LoadPlaceholderContentForAuthoring(PlaceholderControlEventArgs e)
		{
			//Make sure the child controls are created
			EnsureChildControls();
			
			//Get data from the CMS database
			string textboxText = StripTags(((XmlPlaceholder)BoundPlaceholder).XmlAsString);

			//use data to set the authoring controls to their previously saved values
			AuthoringTextBox.Text = textboxText;
		}

		protected override void LoadPlaceholderContentForPresentation(PlaceholderControlEventArgs e)
		{
			// Make sure the child controls are created
			EnsureChildControls();
			            
			// Get data from the CMS database
			string resourceGalleryPath = StripTags(((XmlPlaceholder)BoundPlaceholder).XmlAsString);

			ResourceGallery rsg = CmsHttpContext.Current.Searches.GetByPath(resourceGalleryPath) as ResourceGallery;
			if (rsg != null)
			{
				// Configured ResourceGallery exists
				ResourceCollection rc = rsg.Resources;

				// ensure that only images are used for the random display. Other resources will be ignored
				rc.FilterByMimeType("image");

				// use a random image generated to choose the image
				int resourceNumber = new System.Random().Next(rc.Count);
				Resource rs = rc[resourceNumber];
				Image img = new Image();
				img.ImageUrl = rs.Url;

				// Add random image to Presentation Container
				PresentationPlaceholder.Controls.Add(img);
			}
			else
			{
				// Configured ResourceGallery does not exist
				Label lbl = new Label();
				lbl.Text = "<p><b><font color=\"red\">Error: resource gallery '"+resourceGalleryPath+"' does not exist or insufficient permissions for current user!</font></b></p>";

				// Add error message to Presentation Container
				PresentationPlaceholder.Controls.Add(lbl);
			}
		}

		protected override void SavePlaceholderContent(PlaceholderControlSaveEventArgs e)
		{
			EnsureChildControls();

			//Save the Resource Gallery Path to the CMS database
			((XmlPlaceholder)BoundPlaceholder).XmlAsString = "<resourceGallery>"+AuthoringTextBox.Text+"</resourceGallery>";
		}

	}
}
