using System;
using System.Net;
using Rebex.Net;

namespace Examples
{
	/// <summary>
	/// This sample retrieves the list of files from a FTP server.
	/// It demonstrates the usage of FtpList class.
	/// </summary>
	class FileList
	{
		[STAThread]
		static void Main(string[] args)
		{
			if (args.Length!=1)
			{
				// display syntax if wrong number of parameters or unsupported operation
				Console.WriteLine ("FileList - retrieves file list from a FTP server");
				Console.WriteLine ("Syntax: FileList [username:[password]@]hostname/remotepath");
				Console.WriteLine ("Example: FileList ftp.microsoft.com/developr/");
				return;
			}

			// get username and password from URI
			Uri uri = new Uri ("ftp://" + args[0]);
			string username;
			string password;
			if (uri.UserInfo.Length == 0)
			{
				Console.Write ("Username: ");
				username = Console.ReadLine();
				Console.Write ("Password: ");
				password = Console.ReadLine();
				if (password.Length == 0)
					password = null;
			}
			else
			{
				string[] userInfo = uri.UserInfo.Split(':');
				username = userInfo[0];
				if (userInfo.Length > 1)
					password = userInfo[1];
				else
				{
					Console.Write ("Password: ");
					password = Console.ReadLine();
				}
			}

			// create Ftp object and connect to the server
			Ftp ftp = new Ftp();
			ftp.Connect (uri.Host, uri.Port);

			// login with username and password
			ftp.Login (username, password);

			// set transfer type to binary
			ftp.SetTransferType (FtpTransferType.Binary);

			ftp.ChangeDirectory (uri.AbsolutePath);
			FtpList list = ftp.GetList ();

			for (int i=0; i<list.Count; i++)
			{
				FtpItem item = list[i];
				if (item.IsSymlink)
					Console.Write ("s ");
				else if (item.IsDirectory)
					Console.Write ("d ");
				else
					Console.Write ("- ");

				Console.Write (item.Modified.ToString("u").Substring(0,16));
				Console.Write (item.Size.ToString().PadLeft(10,' '));
				Console.Write (" {0}", item.Name);
				if (item.IsSymlink)
					Console.Write (" -> " + item.SymlinkPath);
				Console.WriteLine ();
			}

			// disconnect from the server
			ftp.Disconnect();
		}
	}
}
