using System;
using System.IO;
using System.Net;
using Rebex.Net;

namespace Examples
{
	/// <summary>
	/// This sample demonstrates using FtpWebRequest class to download
	/// file from a FTP server.
	/// </summary>
	class FtpRequest
	{
		[STAThread]
		static void Main(string[] args)
		{
			if (args.Length != 2)
			{
				// display syntax if wrong number of parameters
				Console.WriteLine ("FtpWebRequest - download file from a Uri.");
				Console.WriteLine ("Syntax: FtpWebRequest uri localpath");
				Console.WriteLine ("Example: FtpWebRequest ftp://ftp.microsoft.com/developr/readme.txt readme.txt");
				return;
			}

			// register the component for the FTP prefix
			WebRequest.RegisterPrefix ("ftp://", FtpWebRequest.Creator);

			// create web request for the given URI
			WebRequest request = WebRequest.Create (args[0]);
			
			// get and read web response
			WebResponse response = request.GetResponse();
			Stream stream = response.GetResponseStream();

			Stream local = File.Create (args[1]);

			byte[] buffer = new byte[1024];
			int n;
			do
			{
				n = stream.Read (buffer, 0, buffer.Length);
				local.Write (buffer, 0, n);
			} while (n > 0);

			// close both streams
			stream.Close();
			local.Close();
		}
	}
}
