Imports System
Imports System.IO
Imports System.Net
Imports Rebex.Net

Module FtpRequest

    ' This sample demonstrates using FtpWebRequest class to download
    ' file from a FTP server.
    Sub Main()
        Dim args() As String = Environment.GetCommandLineArgs()
        If args.Length <> 3 Then
            ' display syntax if wrong number of parameters
            Console.WriteLine("FtpWebRequest - download file from a Uri.")
            Console.WriteLine("Syntax: FtpWebRequest uri localpath")
            Console.WriteLine("Example: FtpWebRequest ftp://ftp.microsoft.com/developr/readme.txt readme.txt")
            Return
        End If

        ' register the component for the FTP prefix
        WebRequest.RegisterPrefix("ftp://", Rebex.Net.FtpWebRequest.Creator)

        ' create web request for the given URI
        Dim request As WebRequest = WebRequest.Create(args(1))

        ' get and read web response
        Dim response As WebResponse = request.GetResponse()
        Dim stream As Stream = response.GetResponseStream()

        Dim local As Stream = File.Create(args(2))

        Dim buffer(1023) As Byte
        Dim n As Integer
        Do
            n = stream.Read(buffer, 0, buffer.Length)
            local.Write(buffer, 0, n)
        Loop While n > 0

        ' close both streams
        stream.Close()
        local.Close()
    End Sub

End Module
