using System;
using System.IO;
using Rebex.Net;

namespace Examples
{
	/// <summary>
	/// This sample is a simple utility to upload/download a file to/from
	/// a FTP server using the Ftp class.
	/// </summary>
	class GetPut
	{
		[STAThread]
		static void Main(string[] args)
		{
			string method = null;

			if (args.Length == 4)
			{
				switch (args[0].ToLower())
				{
					case "get": method = "get"; break;
					case "put": method = "put"; break;
				}
			}

			if (method == null)
			{
				// display syntax if wrong number of parameters or unsupported operation
				Console.WriteLine ("GetPut - uploads or downloads a file from a FTP server");
				Console.WriteLine ("Syntax: GetPut get|put hostname remotepath localpath");
				Console.WriteLine ("Example: GetPut get ftp.microsoft.com /developr/readme.txt readme.txt");
				return;
			}

			string hostname = args[1];
			string remotePath = args[2];
			string localPath = args[3];

			// create Ftp object and connect to the server
			Ftp ftp = new Ftp();
			ftp.Connect (hostname);

			// ask for username and password and login
			Console.Write ("Username: ");
			string username = Console.ReadLine();
			Console.Write ("Password: ");
			string password = Console.ReadLine();
			ftp.Login (username, password);

			// set transfer type to binary
			ftp.SetTransferType (FtpTransferType.Binary);

			// transfer the file
			long bytes;
			if (method == "get")
				bytes = ftp.GetFile (remotePath, localPath);
			else
				bytes = ftp.PutFile (localPath, remotePath);

			Console.WriteLine ("Transfered {0} bytes.", bytes);

			// disconnect from the server
			ftp.Disconnect();
		}
	}
}
