Imports System
Imports System.IO
Imports Rebex.Net

Module GetPut

    ' This sample is a simple utility to upload/download a file to/from
    ' a FTP server using the Ftp class.
    Sub Main()
        Dim args() As String = Environment.GetCommandLineArgs()

        Dim method As String = Nothing
        If args.Length = 5 Then
            Select Case args(1).ToLower()
                Case "get"
                    method = "get"
                Case "put"
                    method = "put"
            End Select
        End If

        If method Is Nothing Then
            ' display syntax if wrong number of parameters or unsupported operation
            Console.WriteLine("GetPut - uploads or downloads a file from a FTP server")
            Console.WriteLine("Syntax: GetPut get|put hostname remotepath localpath")
            Console.WriteLine("Example: GetPut get ftp.microsoft.com /developr/readme.txt readme.txt")
            Return
        End If

        Dim hostname As String = args(2)
        Dim remotePath As String = args(3)
        Dim localPath As String = args(4)

        ' create Ftp object and connect to the server
        Dim ftp As New Ftp()
        ftp.Connect(hostname)

        ' ask for username and password and login
        Console.Write("Username: ")
        Dim username As String = Console.ReadLine()
        Console.Write("Password: ")
        Dim password As String = Console.ReadLine()
        ftp.Login(username, password)

        ' set transfer type to binary
        ftp.SetTransferType(FtpTransferType.Binary)

        ' transfer the file
        Dim bytes As Long
        If method = "get" Then
            bytes = ftp.GetFile(remotePath, localPath)
        Else
            bytes = ftp.PutFile(localPath, remotePath)
        End If
        Console.WriteLine("Transfered {0} bytes.", bytes)

        ' disconnect from the server
        ftp.Disconnect()
    End Sub

End Module
