using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Rebex.Net;

namespace WinFormClient
{
	/// <summary>
	/// connection dialog
	/// </summary>
	public class Connection : System.Windows.Forms.Form
	{		
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.CheckBox cbPassive;
		private System.Windows.Forms.TextBox tbPassword;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.TextBox tbLogin;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox tbPort;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TextBox tbHost;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.ComboBox cbProxyType;
		private System.Windows.Forms.TextBox tbProxyPort;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.CheckBox cbProxy;
		private System.Windows.Forms.TextBox tbProxy;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Button btnConnect;
		private System.Windows.Forms.TextBox tbProxyLogin;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.TextBox tbProxyPassword;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.Label label10;
		private System.Windows.Forms.StatusBar sbMessage;
		
		public bool m_bOK=false;	// form was confirmed

		public bool OK
		{
			get {return m_bOK;}
		}

		// host name

		public string Host
		{
			get {return tbHost.Text;}
			set {tbHost.Text=value;}
		}

		// port of the host

		public int Port
		{
			get 
			{
				int temp;

				try
				{
					temp=Int32.Parse(tbPort.Text);
				}

				catch
				{
					return 0;	// def. value if error occures
				}

				return temp;
			}
			set {tbPort.Text=value.ToString();}
		}

		// proxy server

		public string Proxy
		{
			set {tbProxy.Text=value;}
			get {return tbProxy.Text;}
		}

		// proxy login name

		public string ProxyLogin
		{
			set {tbProxyLogin.Text=value;}
			get {return tbProxyLogin.Text;}
		}

		// proxy password

		public string ProxyPassword
		{
			set {tbProxyPassword.Text=value;}
			get {return tbProxyPassword.Text;}
		}

		// is proxy enabled?

		public bool ProxyEnabled
		{
			set 
			{
				if (value)
				{
					tbProxy.Enabled=true;
					tbProxyPort.Enabled=true;
					cbProxy.Checked=true;
					cbProxyType.Enabled=true;
					tbProxyLogin.Enabled=true;
					tbProxyPassword.Enabled=true;
				}
				else
				{
					tbProxy.Enabled=false;
					tbProxyPort.Enabled=false;
					cbProxy.Checked=false;
					cbProxyType.Enabled=false;
					tbProxyLogin.Enabled=false;
					tbProxyPassword.Enabled=false;
				}
			}

			get {return cbProxy.Checked;}
		}
		
		// proxy port

		public int ProxyPort
		{
			set {tbProxyPort.Text=value.ToString();}
			get 
			{
				int temp;

				try
				{
					temp=Int32.Parse(tbProxyPort.Text);
				}

				catch
				{
					return 0;	// def. value if error occures
				}

				return temp;
			}
		}
		
		// login name

		public string Login
		{
			get {return tbLogin.Text;}
			set {tbLogin.Text=value;}
		}

		// password

		public string Password
		{
			get {return tbPassword.Text;}
			set {tbPassword.Text=value;}
		}

		// passive mode

		public bool Passive
		{
			get {return cbPassive.Checked;}
			set {cbPassive.Checked=value;}
		}

		public int ProxyType
		{
			get {return cbProxyType.SelectedIndex+1;}	// +1 because 'none' type is missing
			set {cbProxyType.SelectedIndex=value-1;}	// -1 because 'none' type is missing
		}

		// -------------------------------------------------------------------------				
		public bool ValidateForm()
		{
			// ftp host
			
			if (tbHost.Text==null || tbHost.Text.Length<=0)
			{
				sbMessage.Text="ftp host is a required field";
				return false;
			}

			// ftp port

			if (tbPort.Text==null || tbPort.Text.Length<=0)
			{
				sbMessage.Text="ftp port is a required field";
				return false;
			}

			// ftp port [decimal]

			bool badFtpPort=false;

			try
			{
				uint n=UInt32.Parse(tbPort.Text);
				if (n==0) badFtpPort=true;
			}

			catch
			{
				badFtpPort=true;
			}

			if (badFtpPort) 
			{
				sbMessage.Text="ftp port must be > 0";
				return false;
			}

			// ----------------
			// proxy check-outs
			// ----------------

			if (cbProxy.Checked)			
			{
				// proxy host

				if (tbProxy.Text==null || tbProxy.Text.Length<=0)
				{
					sbMessage.Text="proxy host is a required field when proxy is enabled";
					return false;
				}

				// proxy port

				if (tbProxyPort.Text==null || tbProxyPort.Text.Length<=0)
				{
					sbMessage.Text="proxy port is a required field when proxy is enabled";
					return false;
				}

				// proxy port [decimal]

				bool badProxyPort=false;

				try
				{
					uint n=UInt32.Parse(tbProxyPort.Text);
					if (n==0) badProxyPort=true;
				}

				catch
				{
					badProxyPort=true;
				}

				if (badProxyPort) 
				{
					sbMessage.Text="proxy port must be > 0";
					return false;
				}			
			}

			return true;
		}

		// -------------------------------------------------------------------------				
		public Connection()
		{
			InitializeComponent();						
		}

		// -------------------------------------------------------------------------
		/// <summary>
		/// clean up any resources being used
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if (disposing)
			{
				if (components!=null)
				{
					components.Dispose();
				}
			}

			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.cbPassive = new System.Windows.Forms.CheckBox();
			this.tbPassword = new System.Windows.Forms.TextBox();
			this.label4 = new System.Windows.Forms.Label();
			this.tbLogin = new System.Windows.Forms.TextBox();
			this.label3 = new System.Windows.Forms.Label();
			this.tbPort = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.tbHost = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.label10 = new System.Windows.Forms.Label();
			this.tbProxyPassword = new System.Windows.Forms.TextBox();
			this.label9 = new System.Windows.Forms.Label();
			this.tbProxyLogin = new System.Windows.Forms.TextBox();
			this.label8 = new System.Windows.Forms.Label();
			this.label7 = new System.Windows.Forms.Label();
			this.cbProxyType = new System.Windows.Forms.ComboBox();
			this.tbProxyPort = new System.Windows.Forms.TextBox();
			this.label6 = new System.Windows.Forms.Label();
			this.cbProxy = new System.Windows.Forms.CheckBox();
			this.tbProxy = new System.Windows.Forms.TextBox();
			this.label5 = new System.Windows.Forms.Label();
			this.btnConnect = new System.Windows.Forms.Button();
			this.sbMessage = new System.Windows.Forms.StatusBar();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.SuspendLayout();
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.cbPassive,
																					this.tbPassword,
																					this.label4,
																					this.tbLogin,
																					this.label3,
																					this.tbPort,
																					this.label2,
																					this.tbHost,
																					this.label1});
			this.groupBox1.Location = new System.Drawing.Point(8, 8);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(400, 128);
			this.groupBox1.TabIndex = 18;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "ftp settings";
			// 
			// cbPassive
			// 
			this.cbPassive.Checked = true;
			this.cbPassive.CheckState = System.Windows.Forms.CheckState.Checked;
			this.cbPassive.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.cbPassive.Location = new System.Drawing.Point(296, 56);
			this.cbPassive.Name = "cbPassive";
			this.cbPassive.Size = new System.Drawing.Size(96, 24);
			this.cbPassive.TabIndex = 18;
			this.cbPassive.Text = "passive mode";
			// 
			// tbPassword
			// 
			this.tbPassword.Location = new System.Drawing.Point(112, 88);
			this.tbPassword.Name = "tbPassword";
			this.tbPassword.PasswordChar = '*';
			this.tbPassword.TabIndex = 17;
			this.tbPassword.Text = "";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(8, 88);
			this.label4.Name = "label4";
			this.label4.TabIndex = 16;
			this.label4.Text = "password:";
			// 
			// tbLogin
			// 
			this.tbLogin.Location = new System.Drawing.Point(112, 56);
			this.tbLogin.Name = "tbLogin";
			this.tbLogin.TabIndex = 15;
			this.tbLogin.Text = "";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(8, 56);
			this.label3.Name = "label3";
			this.label3.TabIndex = 14;
			this.label3.Text = "login name:";
			// 
			// tbPort
			// 
			this.tbPort.Location = new System.Drawing.Point(296, 24);
			this.tbPort.Name = "tbPort";
			this.tbPort.Size = new System.Drawing.Size(64, 20);
			this.tbPort.TabIndex = 13;
			this.tbPort.Text = "21";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(224, 24);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(56, 23);
			this.label2.TabIndex = 12;
			this.label2.Text = "port:";
			// 
			// tbHost
			// 
			this.tbHost.Location = new System.Drawing.Point(112, 24);
			this.tbHost.Name = "tbHost";
			this.tbHost.TabIndex = 11;
			this.tbHost.Text = "";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 24);
			this.label1.Name = "label1";
			this.label1.TabIndex = 10;
			this.label1.Text = "host name:";
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.label10,
																					this.tbProxyPassword,
																					this.label9,
																					this.tbProxyLogin,
																					this.label8,
																					this.label7,
																					this.cbProxyType,
																					this.tbProxyPort,
																					this.label6,
																					this.cbProxy,
																					this.tbProxy,
																					this.label5});
			this.groupBox2.Location = new System.Drawing.Point(8, 144);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(400, 160);
			this.groupBox2.TabIndex = 19;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "proxy settings";
			// 
			// label10
			// 
			this.label10.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label10.ForeColor = System.Drawing.SystemColors.ControlDarkDark;
			this.label10.Location = new System.Drawing.Point(248, 96);
			this.label10.Name = "label10";
			this.label10.Size = new System.Drawing.Size(144, 48);
			this.label10.TabIndex = 30;
			this.label10.Text = "if login/password is not needed leave these boxes empty";
			// 
			// tbProxyPassword
			// 
			this.tbProxyPassword.Location = new System.Drawing.Point(112, 128);
			this.tbProxyPassword.Name = "tbProxyPassword";
			this.tbProxyPassword.PasswordChar = '*';
			this.tbProxyPassword.TabIndex = 29;
			this.tbProxyPassword.Text = "";
			// 
			// label9
			// 
			this.label9.Location = new System.Drawing.Point(16, 128);
			this.label9.Name = "label9";
			this.label9.TabIndex = 28;
			this.label9.Text = "password:";
			// 
			// tbProxyLogin
			// 
			this.tbProxyLogin.Location = new System.Drawing.Point(112, 96);
			this.tbProxyLogin.Name = "tbProxyLogin";
			this.tbProxyLogin.TabIndex = 27;
			this.tbProxyLogin.Text = "";
			// 
			// label8
			// 
			this.label8.Location = new System.Drawing.Point(16, 96);
			this.label8.Name = "label8";
			this.label8.TabIndex = 26;
			this.label8.Text = "login name:";
			// 
			// label7
			// 
			this.label7.Location = new System.Drawing.Point(16, 60);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(88, 23);
			this.label7.TabIndex = 25;
			this.label7.Text = "proxy type:";
			// 
			// cbProxyType
			// 
			this.cbProxyType.Items.AddRange(new object[] {
															 "Socks4",
															 "Socks4a",
															 "Socks5",
															 "HttpConnect",
															 "FtpSite",
															 "FtpUser",
															 "FtpOpen"});
			this.cbProxyType.Location = new System.Drawing.Point(112, 60);
			this.cbProxyType.Name = "cbProxyType";
			this.cbProxyType.Size = new System.Drawing.Size(104, 21);
			this.cbProxyType.TabIndex = 24;
			// 
			// tbProxyPort
			// 
			this.tbProxyPort.Location = new System.Drawing.Point(296, 28);
			this.tbProxyPort.Name = "tbProxyPort";
			this.tbProxyPort.Size = new System.Drawing.Size(64, 20);
			this.tbProxyPort.TabIndex = 23;
			this.tbProxyPort.Text = "21";
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(224, 28);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(56, 23);
			this.label6.TabIndex = 22;
			this.label6.Text = "port:";
			// 
			// cbProxy
			// 
			this.cbProxy.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.cbProxy.Location = new System.Drawing.Point(296, 56);
			this.cbProxy.Name = "cbProxy";
			this.cbProxy.Size = new System.Drawing.Size(88, 24);
			this.cbProxy.TabIndex = 21;
			this.cbProxy.Text = "enabled";
			this.cbProxy.Click += new System.EventHandler(this.cbProxy_Click);
			// 
			// tbProxy
			// 
			this.tbProxy.Location = new System.Drawing.Point(112, 28);
			this.tbProxy.Name = "tbProxy";
			this.tbProxy.TabIndex = 20;
			this.tbProxy.Text = "";
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(16, 28);
			this.label5.Name = "label5";
			this.label5.TabIndex = 19;
			this.label5.Text = "proxy:";
			// 
			// btnConnect
			// 
			this.btnConnect.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnConnect.Location = new System.Drawing.Point(320, 312);
			this.btnConnect.Name = "btnConnect";
			this.btnConnect.Size = new System.Drawing.Size(88, 23);
			this.btnConnect.TabIndex = 20;
			this.btnConnect.Text = "Connect";
			this.btnConnect.Click += new System.EventHandler(this.btnConnect_Click);
			// 
			// sbMessage
			// 
			this.sbMessage.Location = new System.Drawing.Point(0, 346);
			this.sbMessage.Name = "sbMessage";
			this.sbMessage.Size = new System.Drawing.Size(418, 22);
			this.sbMessage.TabIndex = 21;
			// 
			// Connection
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(418, 368);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.sbMessage,
																		  this.btnConnect,
																		  this.groupBox2,
																		  this.groupBox1});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
			this.KeyPreview = true;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "Connection";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Connection";
			this.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.Connection_KeyPress);
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		// -------------------------------------------------------------------------
		/// <summary>
		/// form confirmation by clicking 'ok' button
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnConnect_Click(object sender, System.EventArgs e)
		{
			if (ValidateForm())
			{
				m_bOK=true;
				this.Close();
			}			
		}

		// -------------------------------------------------------------------------
		/// <summary>
		/// proxy enable/disable click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbProxy_Click(object sender, System.EventArgs e)
		{
			System.Windows.Forms.CheckBox cb=(System.Windows.Forms.CheckBox)sender;	

			if (cb.Checked) 
			{
				tbProxy.Enabled=true;
				tbProxyPort.Enabled=true;
				cbProxy.Checked=true;
				cbProxyType.Enabled=true;
				tbProxyLogin.Enabled=true;
				tbProxyPassword.Enabled=true;
			}
			else
			{
				tbProxy.Enabled=false;
				tbProxyPort.Enabled=false;
				cbProxy.Checked=false;
				cbProxyType.Enabled=false;
				tbProxyLogin.Enabled=false;
				tbProxyPassword.Enabled=false;
			}
		}

		// -------------------------------------------------------------------------
		/// <summary>
		/// global key handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Connection_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			// when 'enter' is pressed the form is closed

			if (e.KeyChar=='\r')
			{
				if (ValidateForm())
				{
					m_bOK=true;
					this.Close();
				}								
			}

			// when 'esc' is pressed the form is closed

			if ((int)(e.KeyChar)==Convert.ToChar(Keys.Escape))				
			{
				this.Close();
			}
		}		
	}
}