using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace WinFormClient
{
	/// <summary>
	/// remove dir dialog
	/// </summary>
	public class RemoveDir : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label lblMsg;
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.Button btnCancel;		
		private System.ComponentModel.Container components = null;
		
		private string m_strDirectory=null;	// directory name
		private bool m_bOK=false;			// true=form confirmed false=cancelled

		public string Directory
		{
			set 
			{
				m_strDirectory=value;
				if (m_strDirectory!=null) lblMsg.Text="remove directory \""+m_strDirectory+"\" ?";
			}
			get {return m_strDirectory;}
		}

		public bool OK
		{
			get {return m_bOK;}
		}

		// -------------------------------------------------------------------------
		public RemoveDir()
		{			
			InitializeComponent();			
		}

		// -------------------------------------------------------------------------
		/// <summary>
		/// clean up any resources being used
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if (disposing)
			{
				if (components!=null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.lblMsg = new System.Windows.Forms.Label();
			this.btnOK = new System.Windows.Forms.Button();
			this.btnCancel = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// lblMsg
			// 
			this.lblMsg.Location = new System.Drawing.Point(16, 8);
			this.lblMsg.Name = "lblMsg";
			this.lblMsg.Size = new System.Drawing.Size(320, 23);
			this.lblMsg.TabIndex = 0;
			// 
			// btnOK
			// 
			this.btnOK.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnOK.Location = new System.Drawing.Point(184, 40);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 1;
			this.btnOK.Text = "OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnCancel.Location = new System.Drawing.Point(264, 40);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// RemoveDir
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(346, 72);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.btnCancel,
																		  this.btnOK,
																		  this.lblMsg});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
			this.KeyPreview = true;
			this.Name = "RemoveDir";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Remove directory";
			this.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.RemoveDir_KeyPress);
			this.ResumeLayout(false);

		}
		#endregion

		// -------------------------------------------------------------------------
		/// <summary>
		/// form confirmation by clicking 'ok' button
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			m_bOK=true;
			this.Close();
		}

		// -------------------------------------------------------------------------
		/// <summary>
		/// form cancellation
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			m_bOK=false;
			this.Close();
		}

		// -------------------------------------------------------------------------
		/// <summary>
		/// global key handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void RemoveDir_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			// when 'enter' is pressed the form is closed

			if (e.KeyChar=='\r')
			{
				m_bOK=true;
				this.Close();
			}

			// when 'esc' is pressed the form is closed

			if ((int)(e.KeyChar)==Convert.ToChar(Keys.Escape))				
			{
				this.Close();
			}
		}
		
	}
}
