using System;
using System.IO;
using System.Configuration;
using Rebex.Net;
using NUnit.Framework;

namespace Rebex.Tests.FtpTest
{
	/// <summary>
	/// Tests FTP upload and download streams.	
	/// </summary>
	abstract public class FtpStreamTest
	{
		public Site Site = null;

		[Test]
		public void TestStreamUploadDownload()
		{
			Console.WriteLine ("-- TestStreamUploadDownload --------------------------");

			//Utils.ConsoleWrite ("Connect...");
			//ftp.Connect (Site.Host,Site.Port);
			
			//Utils.ConsoleWrite ("Login...");
			//ftp.Login (Site.Login,Site.Password);
			Ftp ftp = null;

			try
			{
				ftp = Utils.ConnectFtp (Site);
				
			
				ftp.ChangeDirectory (Site.UploadDir);
				ftp.SetTransferType (FtpTransferType.Binary);
			
				string uniqueName = Utils.GetUniqueName(ftp, "stream", ".bin");

				Utils.ConsoleWriteLine("Opening upload stream...");
				Stream s0 = ftp.GetUploadStream (uniqueName);
				Utils.ConsoleWriteLine("Uploading...");
				Random rand = new Random();
				int total,n;
				byte[] source = new byte[250000];
				for (int i=0; i<250000; i++)
					source[i] = (byte)rand.Next(255);

				total = 0;
				while (total<250000)
				{
					n = rand.Next(5);
					if (total+n > 250000)
						n = 250000 - total;
					s0.Write (source, total, n);
					total += n;

					n = rand.Next(2000)+5000;
					if (total+n > 250000)
						n = 250000 - total;
					s0.Write (source, total, n);
					total += n;

					Utils.ConsoleFlush();
				}
				Utils.ConsoleWriteLine ("Closing...");
				s0.Close();
				Utils.ConsoleWriteLine ("Closed.");

				Assertion.AssertEquals ("Unexpected state.", FtpState.Ready, ftp.State);


				Utils.ConsoleWriteLine("Downloading...");
				Stream s1 = ftp.GetDownloadStream (uniqueName);
				byte[] buffer = new byte[90000];
				total = 0;
				int m;
				while (total<90000)
				{
					n = rand.Next(5);
					if (total+n > 90000)
						n = 90000 - total;
					m = s1.Read (buffer, total, n);
					if (m==0 && n!=0) Assertion.Fail("Unexpected response.");
					total += m;

					n = rand.Next(2000)+5000;
					if (total+n > 90000)
						n = 90000 - total;
					m = s1.Read (buffer, total, n);
					if (m==0) Assertion.Fail("Unexpected response.");
					total += m;

					Utils.ConsoleFlush();
				}
				Utils.ConsoleWriteLine ("Closing...");
				s1.Close();
				Utils.ConsoleWriteLine ("Closed.");

				Assertion.AssertEquals ("Unexpected state.", FtpState.Ready, ftp.State);

				for (int i=0; i<90000; i++)
					Assertion.AssertEquals ("Downloaded data does not correspond do uploaded data.", source[i], buffer[i]);

				string current = ftp.GetCurrentDirectory();
				Assertion.AssertEquals ("Invalid current directory.", Site.UploadDir, current);

				ftp.DeleteFile (uniqueName);
				ftp.Disconnect();
			}
			finally
			{
				Utils.CloseFtp (ftp);
			}
		}

		
	}
}

