using System;
using System.IO;
using System.Configuration;
using System.Net;
using Rebex.Net;
using NUnit.Framework;

namespace Rebex.Tests.FtpTest
{
 	
	/// <summary>
	/// FtpBasicTest tests basic public methods
	/// supported by RbxFtp class	
	/// </summary>
	abstract public class FtpInternalTest
	{
		public Site Site = null;

		
		/*** TEST TEMPLATE ***/

		/* Test_Name
		 - Test_Description
		Test
		public void Test_Name()
		{
			Console.WriteLine ("---------------- Test_Name ----------------");			
			Ftp ftp = null;
			try
			{
				ftp = Utils.ConnectFtp (Site);
				string uniqName = Utils.GetUniqueName(ftp, "", "");			
			//TEST HERE	
			}
			finally
			{
				Utils.CloseFtp (ftp);
			}	
		}*/

		/// <summary>
		/// TestConnectBadPort
		/// test connection on port where "probably" nobody listening 
		/// </summary>
		
		[Test]
		public void TestConnectBadPort()
		{
			Console.WriteLine ("---------------- TestConnectBadPort ----------------");
			
			Ftp ftp = null;
			try
			{
				ftp = Utils.CreateFtp (Site);
				ftp.Connect (Site.Host, 63403);
				Assertion.Fail ("Succesfully connected on port which probably not exists.");
			}
			catch //(FtpException e)
			{	
				//if (e.Response.Code.ToString().Length <= 0) Console.Write("ok");
			}
			finally
			{
				Utils.CloseFtp (ftp);
			}
		}

		/// <summary>
		/// TestConnectHttpPort - test Connect to "probably" bad port
		/// with correct parameters
		/// </summary>
	
		[Test]
		[Ignore ("last too long")]
		public void TestConnectHttpPort()
		{
			Console.WriteLine ("---------------- TestConnectHttpPort ----------------");

			Ftp ftp = null;
			try
			{
				ftp = Utils.CreateFtp (Site);
				// shouldn't pass
				ftp.Connect (Site.Host,80);				
				Assertion.Fail("Succesfully connected on port where probably runs HTTP");
			}
			finally
			{
				Utils.CloseFtp (ftp);
			}
		}

		// TEST NOT USED, WE'VE FOUND JUST ONE FTP SERVER,
		//  WHERE IT WORKS PROPERLY (ACCORDING TO RFC STANDARD :-<)

				// - putunique
				// TestPutUnique		
				// putunique 5 times
				[Test]
				[Ignore ("reality goes on its own routes")]
				public void TestPutUnique()
				{
					Console.WriteLine ("---------------- TestPutUnique ----------------");			
			
					Ftp ftp = null;
					try
					{
						ftp = Utils.ConnectFtp (Site);
						ftp.ChangeDirectory(Site.UploadDir);
						//stream
						string text = "1234567890";
						byte[] data = System.Text.Encoding.ASCII.GetBytes(text);
						System.IO.MemoryStream oInput = new System.IO.MemoryStream(data);
						ftp.GetCurrentDirectory();
						string remPath;
						//stream
						for (int i=0; i<5;i++)
						{
							oInput.Position = 0;
							remPath = ftp.PutUniqueFile(oInput);
							Console.WriteLine("Path: " + remPath);
							Assertion.AssertEquals("PutUnique method not works properly, uploade file length differ !!!", 10 ,ftp.GetFileLength(remPath));
						}
			
						//file
					}
					finally
					{
						Utils.CloseFtp (ftp);
					}
				}
				

	}
	
}
