using System;
using System.Net;
using Rebex.Net;
using NUnit.Framework;

/*
 * This file defines classes that represent FTP sites.
 * Customize it to suit your needs:
 * - add sites
 * - change settings
 * 
 */

namespace Rebex.Tests.FtpTest
{
	/// <summary>
	/// Base FTP site info class.
	/// </summary>
	public class Site
	{
		public string Host		= null;
		public int Port			= 21;
		public string Login		= "anonymous";
		public string Password  = "test@rebex.cz";

		public string UploadDir = null;
		public string NoModifyDir = "/usr";
		public int Timeout		= 10 * 1000;
		public bool Passive		= true;
		public FtpProxy Proxy	= null;

		protected Site()
		{
			//Proxy = new FtpProxy (FtpProxyType.FtpUser, "server01", 8022);
			//Proxy = new FtpProxy (FtpProxyType.Socks5, "server01", 1080, new NetworkCredential ("tester", "password"));
			//Proxy = new FtpProxy (FtpProxyType.HttpConnect, "server01", 8080);
			//Proxy = new FtpProxy (FtpProxyType.Socks4a, "server01", 1081);
		}
	}

	/// <summary>
	/// Settings of localhost site.
	/// </summary>
	public class SiteLocalhost : Site
	{
		public SiteLocalhost ()
		{
			Host      = "localhost";
			Port      = 21;
			Login     = "anonymous";
			Password  = "test";
			UploadDir = "/incoming";
			NoModifyDir = "/shared";
		}
	}

	/// <summary>
	/// Settings of an FTP site.
	/// </summary>
	public class SiteMaslo : Site
	{
		public SiteMaslo ()
		{
			Host      = "maslo";
			Port      = 21;
			Login     = "anonymous";
			Password  = "test";
			UploadDir = "/incoming";
			NoModifyDir = "/shared";
		}
	}

	/// <summary>
	/// Settings of an FTP site.
	/// </summary>
	public class SiteArthur : Site
	{
		public SiteArthur ()
		{
			Host      = "arthur";
			Port      = 21;
			Login     = "anonymous";
			Password  = "test";
			UploadDir = "/pub/incoming/";
			NoModifyDir = "/usr";
		}
	}
}




	
