using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Text.RegularExpressions;

namespace RegExDemos
{
	/// <summary>
	/// Summary description for frmDemo3.
	/// </summary>
	public class frmDemo3 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button btnRegEx;
		private System.Windows.Forms.ComboBox cboRegEx;
		private System.Windows.Forms.Button btnRun;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox txtText;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox txtRegEx;
		private System.Windows.Forms.CheckBox chkReplace;
		private System.Windows.Forms.TextBox txtHTML;
		private System.Windows.Forms.TextBox txtHTMLResult;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Label label4;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public frmDemo3()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.btnRegEx = new System.Windows.Forms.Button();
			this.cboRegEx = new System.Windows.Forms.ComboBox();
			this.btnRun = new System.Windows.Forms.Button();
			this.label3 = new System.Windows.Forms.Label();
			this.txtText = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.label1 = new System.Windows.Forms.Label();
			this.txtRegEx = new System.Windows.Forms.TextBox();
			this.chkReplace = new System.Windows.Forms.CheckBox();
			this.txtHTML = new System.Windows.Forms.TextBox();
			this.txtHTMLResult = new System.Windows.Forms.TextBox();
			this.button1 = new System.Windows.Forms.Button();
			this.label4 = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// btnRegEx
			// 
			this.btnRegEx.Location = new System.Drawing.Point(268, 88);
			this.btnRegEx.Name = "btnRegEx";
			this.btnRegEx.Size = new System.Drawing.Size(32, 16);
			this.btnRegEx.TabIndex = 23;
			this.btnRegEx.Text = "Use";
			this.btnRegEx.Click += new System.EventHandler(this.btnRegEx_Click);
			// 
			// cboRegEx
			// 
			this.cboRegEx.Location = new System.Drawing.Point(36, 88);
			this.cboRegEx.Name = "cboRegEx";
			this.cboRegEx.Size = new System.Drawing.Size(224, 21);
			this.cboRegEx.TabIndex = 22;
			// 
			// btnRun
			// 
			this.btnRun.Location = new System.Drawing.Point(236, 224);
			this.btnRun.Name = "btnRun";
			this.btnRun.TabIndex = 21;
			this.btnRun.Text = "Run RegEx";
			this.btnRun.Click += new System.EventHandler(this.btnRun_Click);
			// 
			// label3
			// 
			this.label3.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label3.Location = new System.Drawing.Point(36, 152);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(264, 23);
			this.label3.TabIndex = 20;
			this.label3.Text = "Enter a Text to Test";
			// 
			// txtText
			// 
			this.txtText.Location = new System.Drawing.Point(36, 184);
			this.txtText.Name = "txtText";
			this.txtText.Size = new System.Drawing.Size(272, 20);
			this.txtText.TabIndex = 19;
			this.txtText.Text = "SteVeN";
			// 
			// label2
			// 
			this.label2.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label2.Location = new System.Drawing.Point(36, 64);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(168, 23);
			this.label2.TabIndex = 18;
			this.label2.Text = "Enter a RegEx or choose one";
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(16, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(384, 23);
			this.label1.TabIndex = 17;
			this.label1.Text = "Demo 3: Working w/ Expressions";
			// 
			// txtRegEx
			// 
			this.txtRegEx.Location = new System.Drawing.Point(36, 120);
			this.txtRegEx.Name = "txtRegEx";
			this.txtRegEx.Size = new System.Drawing.Size(272, 20);
			this.txtRegEx.TabIndex = 16;
			this.txtRegEx.Text = "Steve";
			// 
			// chkReplace
			// 
			this.chkReplace.Location = new System.Drawing.Point(160, 224);
			this.chkReplace.Name = "chkReplace";
			this.chkReplace.Size = new System.Drawing.Size(72, 24);
			this.chkReplace.TabIndex = 24;
			this.chkReplace.Text = "Replace?";
			// 
			// txtHTML
			// 
			this.txtHTML.Location = new System.Drawing.Point(376, 72);
			this.txtHTML.Multiline = true;
			this.txtHTML.Name = "txtHTML";
			this.txtHTML.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.txtHTML.Size = new System.Drawing.Size(192, 96);
			this.txtHTML.TabIndex = 25;
			this.txtHTML.Text = "<font color=\"#A4A4FF\" face=\"Arial\" size=\"1\"><strong>RegEx Rocks, Baby</strong></f" +
				"ont>";
			// 
			// txtHTMLResult
			// 
			this.txtHTMLResult.Location = new System.Drawing.Point(376, 208);
			this.txtHTMLResult.Multiline = true;
			this.txtHTMLResult.Name = "txtHTMLResult";
			this.txtHTMLResult.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.txtHTMLResult.Size = new System.Drawing.Size(192, 96);
			this.txtHTMLResult.TabIndex = 26;
			this.txtHTMLResult.Text = "";
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(464, 176);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(96, 23);
			this.button1.TabIndex = 27;
			this.button1.Text = "Remove HTML!";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(376, 48);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(152, 16);
			this.label4.TabIndex = 28;
			this.label4.Text = "Enter HTML";
			// 
			// frmDemo3
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(608, 318);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.label4,
																		  this.button1,
																		  this.txtHTMLResult,
																		  this.txtHTML,
																		  this.chkReplace,
																		  this.btnRegEx,
																		  this.cboRegEx,
																		  this.btnRun,
																		  this.label3,
																		  this.txtText,
																		  this.label2,
																		  this.label1,
																		  this.txtRegEx});
			this.Name = "frmDemo3";
			this.Text = "RegEX Demo 3";
			this.Load += new System.EventHandler(this.frmDemo3_Load);
			this.ResumeLayout(false);

		}
		#endregion

		private void frmDemo3_Load(object sender, System.EventArgs e)
		{
			//fill the cbo with some popular regexes
			//ABC
			cboRegEx.Items.Add("ABC");
			//Stephen|Steve|Steven
			cboRegEx.Items.Add("Ste((v|ph)en|ve)");
			//email address, make sure you use C# verbatim-string-literal 
			cboRegEx.Items.Add(@"\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*");
			//US Phone Number, make sure you use C# verbatim-string-literal 
			cboRegEx.Items.Add(@"((\(\d{3}\) ?)|(\d{3}-))?\d{3}-\d{4}");
			//US SSN, make sure you use C# verbatim-string-literal 
			cboRegEx.Items.Add(@"\d{3}-\d{2}-\d{4}");
			//US Postal Code, make sure you use C# verbatim-string-literal 
			cboRegEx.Items.Add(@"\d{5}(-\d{4})?");
		}

		private void btnRegEx_Click(object sender, System.EventArgs e)
		{
			txtRegEx.Text=cboRegEx.Text.ToString();
		}

		private void btnRun_Click(object sender, System.EventArgs e)
		{
			//Use the RegEx object to determine if there is a match
			//here we use a single RegEx object
			//passing in the pattern and option to ignore case
			Regex rxMatch =  new Regex(txtRegEx.Text,RegexOptions.IgnoreCase);
			string strReplace;

			//see if we are going to do a replace
			if (chkReplace.Checked)
			{
				strReplace=rxMatch.Replace(txtText.Text,"X");
				txtText.Text=strReplace;
			}
			//we are not doing a replace, but a match
			else
			{
			
				//using the match object
				Match mtMatch;
				MatchCollection mtCol;

				//get 1 match object
				mtMatch= rxMatch.Match(txtText.Text);

				//also, but you don't have to, use a match collection object
				mtCol=rxMatch.Matches(txtText.Text);
				//use the match collection here
				MessageBox.Show("There are " + mtCol.Count + " matche(s) found.","RegEx Demos");
			
				//if there are more than 0 matches, show them
				if (mtCol.Count>0)
				{
					//use the Match object here							
					do 
					{
						//we want the match.value and position in the string
						MessageBox.Show("Result at position string " + mtMatch.Index.ToString() +": " + mtMatch.Value.ToString(),"RegEx Demos");
						mtMatch=mtMatch.NextMatch();
					} 
					while (mtMatch.Success);
				}
			}

		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			//remove the HTML using Replace and generic function
			CommonRegEx oHTML = new CommonRegEx();
			txtHTMLResult.Text=oHTML.RemoveHTML(txtHTML.Text);
		}


	}
}
