using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Text.RegularExpressions;

namespace RegExDemos
{
	/// <summary>
	/// Summary description for frmDemo4.
	/// </summary>
	public class frmDemo4 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.TextBox txtCapture;
		private System.Windows.Forms.Button btnCapture;
		private System.Windows.Forms.Button btnNonCapture;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Button btnBack;
		private System.Windows.Forms.TextBox txtBack;
		private System.Windows.Forms.TextBox txtRegEx;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public frmDemo4()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
			this.txtCapture = new System.Windows.Forms.TextBox();
			this.btnCapture = new System.Windows.Forms.Button();
			this.btnNonCapture = new System.Windows.Forms.Button();
			this.label2 = new System.Windows.Forms.Label();
			this.btnBack = new System.Windows.Forms.Button();
			this.txtBack = new System.Windows.Forms.TextBox();
			this.txtRegEx = new System.Windows.Forms.TextBox();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(8, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(384, 23);
			this.label1.TabIndex = 2;
			this.label1.Text = "Demo 4: Groups && Backreferences";
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(16, 160);
			this.label5.Name = "label5";
			this.label5.TabIndex = 6;
			this.label5.Text = "Backreferences  ";
			// 
			// txtCapture
			// 
			this.txtCapture.Location = new System.Drawing.Point(16, 72);
			this.txtCapture.Name = "txtCapture";
			this.txtCapture.Size = new System.Drawing.Size(264, 20);
			this.txtCapture.TabIndex = 7;
			this.txtCapture.Text = "Lets Go Mets";
			// 
			// btnCapture
			// 
			this.btnCapture.Location = new System.Drawing.Point(16, 96);
			this.btnCapture.Name = "btnCapture";
			this.btnCapture.Size = new System.Drawing.Size(96, 23);
			this.btnCapture.TabIndex = 8;
			this.btnCapture.Text = "Capturing: ()";
			this.btnCapture.Click += new System.EventHandler(this.btnCapture_Click);
			// 
			// btnNonCapture
			// 
			this.btnNonCapture.Location = new System.Drawing.Point(120, 96);
			this.btnNonCapture.Name = "btnNonCapture";
			this.btnNonCapture.Size = new System.Drawing.Size(160, 23);
			this.btnNonCapture.TabIndex = 9;
			this.btnNonCapture.Text = "Named Capture: (?<name>)";
			this.btnNonCapture.Click += new System.EventHandler(this.btnNamedCapture_Click);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 48);
			this.label2.Name = "label2";
			this.label2.TabIndex = 10;
			this.label2.Text = "Groups";
			// 
			// btnBack
			// 
			this.btnBack.Location = new System.Drawing.Point(136, 216);
			this.btnBack.Name = "btnBack";
			this.btnBack.Size = new System.Drawing.Size(96, 23);
			this.btnBack.TabIndex = 12;
			this.btnBack.Text = "Backreferences";
			this.btnBack.Click += new System.EventHandler(this.btnBack_Click);
			// 
			// txtBack
			// 
			this.txtBack.Location = new System.Drawing.Point(16, 184);
			this.txtBack.Name = "txtBack";
			this.txtBack.Size = new System.Drawing.Size(264, 20);
			this.txtBack.TabIndex = 11;
			this.txtBack.Text = "Lets Go Go Mets";
			// 
			// txtRegEx
			// 
			this.txtRegEx.Location = new System.Drawing.Point(16, 216);
			this.txtRegEx.Name = "txtRegEx";
			this.txtRegEx.Size = new System.Drawing.Size(112, 20);
			this.txtRegEx.TabIndex = 13;
			this.txtRegEx.Text = "(\\b[a-zA-Z]+\\b)\\s\\1";
			// 
			// frmDemo4
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(456, 270);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.txtRegEx,
																		  this.btnBack,
																		  this.txtBack,
																		  this.label2,
																		  this.btnNonCapture,
																		  this.btnCapture,
																		  this.txtCapture,
																		  this.label5,
																		  this.label1});
			this.Name = "frmDemo4";
			this.Text = "RegEx Demo 4";
			this.ResumeLayout(false);

		}
		#endregion

		private void btnCapture_Click(object sender, System.EventArgs e)
		{
		//a basic pattern that will capture any word w/ 4 characters
		string strRegExPattern="([A-Za-z]{4})";
		//load the regex, the constructor takes the pattern and options
		Regex rxGroups=  new Regex(strRegExPattern,RegexOptions.IgnoreCase);
		//Match Object->Using a group here
		Match mtGroup  = rxGroups.Match(txtCapture.Text);
		//get all of the groups that exist
		do
		{
			//show the match
			MessageBox.Show(mtGroup.Groups[1].Value, "RegEx Demos");
			//"move" to the next match
			mtGroup=mtGroup.NextMatch();
		}
		while (mtGroup.Success);
		
		}

		private void btnNamedCapture_Click(object sender, System.EventArgs e)
		{
			//a basic pattern that will capture any word w/ 4 characters
			//and the ability to use a name
			string strRegExPattern="(?<word>[A-Za-z]{4})";
			//load the regex, the constructor takes the pattern and options
			Regex rxGroups=  new Regex(strRegExPattern,RegexOptions.IgnoreCase);
			//Match Object->Using a group here
			Match mtGroup  = rxGroups.Match(txtCapture.Text);
			//get all of the groups that exist
			do
			{
				//show the match using the named reference "word"
				MessageBox.Show(mtGroup.Result("${word}"), "RegEx Demos");
				//"move" to the next match
				mtGroup=mtGroup.NextMatch();
			}
			while (mtGroup.Success);
		}

		private void btnBack_Click(object sender, System.EventArgs e)
		{
			//Use the RegEx object to determine if there is a 
			//duplicate word here using the (\b[a-zA-Z]+\b)\s\1 pattern
			Regex rxMatch =  new Regex(txtRegEx.Text,RegexOptions.IgnoreCase);
			//string to replace the text into
			//replace the repeated word /w nothing: $1
			string strReplace=rxMatch.Replace(txtBack.Text,"$1");
			//show the results
			MessageBox.Show(strReplace,"RegEx Demos");
			
		}

	}
}
