///
///  This source code is freeware and is provided on an "as is" basis without warranties of any kind, 
///  whether express or implied, including without limitation warranties that the code is free of defect, 
///  fit for a particular purpose or non-infringing.  The entire risk as to the quality and performance of 
///  the code is with the end user.
///

using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Microsoft.ContentManagement.Publishing;

namespace CmsResizeResourceImages
{
	/// <summary>
	/// Author: Stefan Goner (stefang@microsoft.com)
	/// 
	/// This Form can be used to resize images stored on the local file system of a webserver
	/// 
	/// Syntax: http://server/CmsResizeResourceImages/ResizeResourceImage.aspx?ResourcePath=/Resources/path/filename
	///                   [&width=...]
	///                   [&height=...]
	///                   [&max=...]
	/// </summary>
	public class ResizeResourceImage : System.Web.UI.Page
	{
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
			System.Drawing.Image orginalimg;
			String ResourcePath = Request.QueryString["ResourcePath"];
			int width, height;
			int UrlWidth = System.Convert.ToInt32(Request.QueryString["Width"]);
			int UrlHeight = System.Convert.ToInt32(Request.QueryString["Height"]);
			int UrlMax = System.Convert.ToInt32(Request.QueryString["Max"]);

			Resource rs = CmsHttpContext.Current.Searches.GetByPath(ResourcePath) as Resource;
			Stream ResourceStream = rs.OpenReadStream();
			orginalimg = System.Drawing.Image.FromStream(ResourceStream); // Fetch User Filename
			ResourceStream.Close();

			// Get width using QueryString.
			if (Request.QueryString["width"] == null)
			{
				if (Request.QueryString["height"] == null)
					width = orginalimg.Width; // Use Orginal Width. 
				else
				{
					width = (orginalimg.Width * UrlHeight / orginalimg.Height);
				}
			}
			else if (UrlWidth == 0)  // Assign default width of 100.
				width = 100;
			else
				width = UrlWidth; // Use User Specified width.

			// Get height using QueryString.
			if (Request.QueryString["height"] == null)
				if (Request.QueryString["width"] == null)
					height = orginalimg.Height; // Use Orginal Height.
				else
				{
					height = (orginalimg.Height * UrlWidth / orginalimg.Width);
				}
			else if (UrlHeight == 0) // Assign default height of 100.
				height = 100;
			else
				height = UrlHeight; // Use User Specified height.

			if (Request.QueryString["max"] != null)
			{
				if (orginalimg.Width > orginalimg.Height)
				{
					width = UrlMax;
					height = (orginalimg.Height * UrlMax / orginalimg.Width);
				}
				else
				{
					height = UrlMax;
					width = (orginalimg.Width * UrlMax / orginalimg.Height);
				}
			}

			System.Drawing.Image thumb = new Bitmap(orginalimg, width, height);

			// Sending Response JPEG type to the browser. 
			Response.ContentType = "image/jpeg";
			thumb.Save(Response.OutputStream, System.Drawing.Imaging.ImageFormat.Jpeg);

			// Disposing the objects.
			orginalimg.Dispose();
			thumb.Dispose();
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);
		}
		#endregion
	}
}
