Imports System.IO
Imports System.Drawing.Drawing2D

Public Class frmBrowser
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents DirectoryListbox1 As RyansImageEditor3.ApexCGI.WinForms.VB.CustomerControl.DirectoryListbox
    Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
    Friend WithEvents FileImages As System.Windows.Forms.ImageList
    Friend WithEvents lstImages As System.Windows.Forms.ListView
    Friend WithEvents picPreview As System.Windows.Forms.PictureBox
    Friend WithEvents MenuItem1 As System.Windows.Forms.MenuItem
    Friend WithEvents mnuExit As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem3 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem4 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem5 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem6 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem7 As System.Windows.Forms.MenuItem
    Friend WithEvents PanelDLB As System.Windows.Forms.Panel
    Friend WithEvents PanelListView As System.Windows.Forms.Panel
    Friend WithEvents MenuItem2 As System.Windows.Forms.MenuItem
    Friend WithEvents mnuAbout As System.Windows.Forms.MenuItem
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container()
        Me.DirectoryListbox1 = New RyansImageEditor3.ApexCGI.WinForms.VB.CustomerControl.DirectoryListbox()
        Me.MainMenu1 = New System.Windows.Forms.MainMenu()
        Me.MenuItem1 = New System.Windows.Forms.MenuItem()
        Me.mnuExit = New System.Windows.Forms.MenuItem()
        Me.MenuItem3 = New System.Windows.Forms.MenuItem()
        Me.MenuItem4 = New System.Windows.Forms.MenuItem()
        Me.MenuItem5 = New System.Windows.Forms.MenuItem()
        Me.MenuItem6 = New System.Windows.Forms.MenuItem()
        Me.MenuItem7 = New System.Windows.Forms.MenuItem()
        Me.FileImages = New System.Windows.Forms.ImageList(Me.components)
        Me.lstImages = New System.Windows.Forms.ListView()
        Me.picPreview = New System.Windows.Forms.PictureBox()
        Me.PanelDLB = New System.Windows.Forms.Panel()
        Me.PanelListView = New System.Windows.Forms.Panel()
        Me.MenuItem2 = New System.Windows.Forms.MenuItem()
        Me.mnuAbout = New System.Windows.Forms.MenuItem()
        Me.PanelDLB.SuspendLayout()
        Me.PanelListView.SuspendLayout()
        Me.SuspendLayout()
        '
        'DirectoryListbox1
        '
        Me.DirectoryListbox1.AllowDrop = True
        Me.DirectoryListbox1.Dock = System.Windows.Forms.DockStyle.Fill
        Me.DirectoryListbox1.Name = "DirectoryListbox1"
        Me.DirectoryListbox1.Size = New System.Drawing.Size(200, 680)
        Me.DirectoryListbox1.TabIndex = 0
        '
        'MainMenu1
        '
        Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem1, Me.MenuItem3, Me.MenuItem7, Me.MenuItem2})
        '
        'MenuItem1
        '
        Me.MenuItem1.Index = 0
        Me.MenuItem1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuExit})
        Me.MenuItem1.Text = "&File"
        '
        'mnuExit
        '
        Me.mnuExit.Index = 0
        Me.mnuExit.Text = "E&xit"
        '
        'MenuItem3
        '
        Me.MenuItem3.Index = 1
        Me.MenuItem3.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem4, Me.MenuItem5, Me.MenuItem6})
        Me.MenuItem3.Text = "&Edit"
        '
        'MenuItem4
        '
        Me.MenuItem4.Index = 0
        Me.MenuItem4.Text = "Cu&t"
        '
        'MenuItem5
        '
        Me.MenuItem5.Index = 1
        Me.MenuItem5.Text = "&Copy"
        '
        'MenuItem6
        '
        Me.MenuItem6.Index = 2
        Me.MenuItem6.Text = "&Paste"
        '
        'MenuItem7
        '
        Me.MenuItem7.Index = 2
        Me.MenuItem7.Text = "&Window"
        '
        'FileImages
        '
        Me.FileImages.ColorDepth = System.Windows.Forms.ColorDepth.Depth8Bit
        Me.FileImages.ImageSize = New System.Drawing.Size(110, 110)
        Me.FileImages.TransparentColor = System.Drawing.Color.Transparent
        '
        'lstImages
        '
        Me.lstImages.AllowDrop = True
        Me.lstImages.Dock = System.Windows.Forms.DockStyle.Fill
        Me.lstImages.LargeImageList = Me.FileImages
        Me.lstImages.Name = "lstImages"
        Me.lstImages.Size = New System.Drawing.Size(500, 680)
        Me.lstImages.TabIndex = 3
        '
        'picPreview
        '
        Me.picPreview.Location = New System.Drawing.Point(720, 0)
        Me.picPreview.Name = "picPreview"
        Me.picPreview.Size = New System.Drawing.Size(296, 232)
        Me.picPreview.TabIndex = 4
        Me.picPreview.TabStop = False
        '
        'PanelDLB
        '
        Me.PanelDLB.AllowDrop = True
        Me.PanelDLB.AutoScroll = True
        Me.PanelDLB.Controls.AddRange(New System.Windows.Forms.Control() {Me.DirectoryListbox1})
        Me.PanelDLB.Location = New System.Drawing.Point(8, 8)
        Me.PanelDLB.Name = "PanelDLB"
        Me.PanelDLB.Size = New System.Drawing.Size(200, 680)
        Me.PanelDLB.TabIndex = 5
        '
        'PanelListView
        '
        Me.PanelListView.AutoScroll = True
        Me.PanelListView.Controls.AddRange(New System.Windows.Forms.Control() {Me.lstImages})
        Me.PanelListView.Location = New System.Drawing.Point(216, 8)
        Me.PanelListView.Name = "PanelListView"
        Me.PanelListView.Size = New System.Drawing.Size(500, 680)
        Me.PanelListView.TabIndex = 6
        '
        'MenuItem2
        '
        Me.MenuItem2.Index = 3
        Me.MenuItem2.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuAbout})
        Me.MenuItem2.Text = "&Help"
        '
        'mnuAbout
        '
        Me.mnuAbout.Index = 0
        Me.mnuAbout.Text = "&About"
        '
        'frmBrowser
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(1016, 725)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.PanelListView, Me.PanelDLB, Me.picPreview})
        Me.Menu = Me.MainMenu1
        Me.Name = "frmBrowser"
        Me.Text = "Ryan's Image Editor"
        Me.PanelDLB.ResumeLayout(False)
        Me.PanelListView.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region


    Dim WorkingPath As String
    Dim CurrentFilePath As String
    'memory placeholder form the full view form
    Friend WithEvents ImageForm As frmFullView




    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Cursor.Current = Cursors.WaitCursor

        Try
            'load logical drives
            Me.DirectoryListbox1.Open()

            DirectoryListbox1.Select()                  'Set focus on the control for easier keyboard use.
        Catch ex As DirectoryNotFoundException
            MsgBox(ex.Message, MsgBoxStyle.Exclamation, "Error")
        Catch
            MsgBox(Err.Description, MsgBoxStyle.Critical, "Error")
        Finally
            Cursor.Current = Cursors.Default
        End Try


    End Sub

    Private Sub LoadImages(ByVal PathValue As String) Handles DirectoryListbox1.FolderSelected
        Try
            'Set the new Global path
            WorkingPath = PathValue


            Me.FileImages.Images.Clear()
            Me.lstImages.Clear()

            'directory information for new path
            Dim dirInfo As DirectoryInfo = New DirectoryInfo(PathValue)

            'Need code to find image in child directories

            Dim files As FileInfo() = dirInfo.GetFiles

            'load files in listview and set image
            Dim f As FileInfo
            Dim i As Integer
        

        For Each f In files

            If f.Extension = ".jpg" OrElse f.Extension = ".gif" OrElse _
            f.Extension = ".bmp" Then

                Dim NewItem As ListViewItem = New ListViewItem()

                'Set the name of the new item to the files name
                NewItem.Text = f.Name



                'Create image to add to collection
                Dim curImage As Bitmap = New Bitmap(f.FullName)

                'add file to image collection
                FileImages.Images.Add(curImage)
                'Set the image of the new listviewitem
                NewItem.ImageIndex = FileImages.Images.Count - 1

                'Add the new listviewitem to the image browser
                Me.lstImages.Items.Add(NewItem)

            End If
            i += 1

        Next 'File
        Catch
        End Try

    End Sub

    Private Sub lstImages_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lstImages.SelectedIndexChanged

        Try
            Me.picPreview.Image = Nothing

            CurrentFilePath = WorkingPath & "/" & Me.lstImages.SelectedItems(0).Text

            Me.picPreview.Image = Image.FromFile(WorkingPath & _
            "/" & Me.lstImages.SelectedItems(0).Text)

            'Get Thumb of image
            Me.picPreview.Image = Me.picPreview.Image.GetThumbnailImage( _
            Me.picPreview.Width, Me.picPreview.Height, Nothing, IntPtr.Zero)


        Catch exp As Exception


        End Try


    End Sub

    Private Sub lstImages_DoubleClick(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstImages.DoubleClick

        'opens a new frmfullview
        ImageForm = New frmFullView()


        ImageForm.Show()
        'sets the current image in the full view
        ImageForm.SetImage(CurrentFilePath)
    End Sub

    Private Sub mnuExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuExit.Click

        Application.Exit()

    End Sub


    'sets the next image in full screnn view
    Public Sub GetNextImage() Handles ImageForm.NextImage

        Try
            Dim i As Integer = Me.lstImages.SelectedItems(0).Index + 1
            Me.lstImages.SelectedItems.Clear()
            Me.lstImages.Items.Item(i).Selected = True
            ImageForm.SetImage(CurrentFilePath)

        Catch
            'if current image is last image set selected to last image
            Me.lstImages.Items.Item(Me.lstImages.Items.Count - 1).Selected = True

        End Try



    End Sub

    'sets the previous image in the full screen view
    Public Sub GetPreviousImage() Handles ImageForm.PreviousImage

        Try
            Dim i As Integer = Me.lstImages.SelectedItems(0).Index - 1
            Me.lstImages.SelectedItems.Clear()
            Me.lstImages.Items.Item(i).Selected = True
            ImageForm.SetImage(CurrentFilePath)

        Catch 'If the current image is the first image 
            Me.lstImages.Items.Item(0).Selected = True
            'set selected item to first image

        End Try

    End Sub

    Private Sub mnuAbout_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuAbout.Click

        MessageBox.Show("Written By Ryan Smith" & vbCrLf & "Ryans Image Editor" & _
        vbCrLf & "Version 1.3" & vbCrLf & _
        "Smith Solutions" & vbCrLf & _
        "any questions or comments feel free to contact:  " & vbCrLf & _
        "ryan_smith_2003@yahoo.com" & vbCrLf & vbCrLf & _
        "Directory Listbox User Control" & vbCrLf & _
        " Written in VB.NET by " & vbCrLf & _
        " Mike Stanley" & vbCrLf & _
        " Senior Applications Architect" & vbCrLf & _
        " mstanley@apexcgi.com" & vbCrLf & _
        " Apex Consulting Group, Inc." & vbCrLf & _
        " P.O. Box 636" & vbCrLf & _
        " Wilmington, MA 01887 " & vbCrLf & _
        " Tel: 617.489.9000   Fax: 781.944.1988 & vbcrlf" & _
        " www.apexcgi.com", "About")

    End Sub
End Class
