Imports System.IO

Public Class frmFullView
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents picImage As System.Windows.Forms.PictureBox
    Friend WithEvents ToolBar1 As System.Windows.Forms.ToolBar
    Friend WithEvents tbbSave As System.Windows.Forms.ToolBarButton
    Friend WithEvents tbbOpen As System.Windows.Forms.ToolBarButton
    Friend WithEvents tbbBrowse As System.Windows.Forms.ToolBarButton
    Friend WithEvents tbbHide As System.Windows.Forms.ToolBarButton
    Friend WithEvents Seperator1 As System.Windows.Forms.ToolBarButton
    Friend WithEvents tbbView As System.Windows.Forms.ToolBarButton
    Friend WithEvents cmView As System.Windows.Forms.ContextMenu
    Friend WithEvents mnuCenter As System.Windows.Forms.MenuItem
    Friend WithEvents mnuBestFit As System.Windows.Forms.MenuItem
    Friend WithEvents mnuStrech As System.Windows.Forms.MenuItem
    Friend WithEvents pnlImage As System.Windows.Forms.Panel
    Friend WithEvents mnuNormal As System.Windows.Forms.MenuItem
    Friend WithEvents tbbNext As System.Windows.Forms.ToolBarButton
    Friend WithEvents tbbPrevious As System.Windows.Forms.ToolBarButton
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.picImage = New System.Windows.Forms.PictureBox()
        Me.ToolBar1 = New System.Windows.Forms.ToolBar()
        Me.tbbBrowse = New System.Windows.Forms.ToolBarButton()
        Me.tbbOpen = New System.Windows.Forms.ToolBarButton()
        Me.tbbSave = New System.Windows.Forms.ToolBarButton()
        Me.Seperator1 = New System.Windows.Forms.ToolBarButton()
        Me.tbbView = New System.Windows.Forms.ToolBarButton()
        Me.cmView = New System.Windows.Forms.ContextMenu()
        Me.mnuCenter = New System.Windows.Forms.MenuItem()
        Me.mnuBestFit = New System.Windows.Forms.MenuItem()
        Me.mnuStrech = New System.Windows.Forms.MenuItem()
        Me.mnuNormal = New System.Windows.Forms.MenuItem()
        Me.tbbHide = New System.Windows.Forms.ToolBarButton()
        Me.tbbNext = New System.Windows.Forms.ToolBarButton()
        Me.pnlImage = New System.Windows.Forms.Panel()
        Me.tbbPrevious = New System.Windows.Forms.ToolBarButton()
        Me.pnlImage.SuspendLayout()
        Me.SuspendLayout()
        '
        'picImage
        '
        Me.picImage.Dock = System.Windows.Forms.DockStyle.Fill
        Me.picImage.Name = "picImage"
        Me.picImage.Size = New System.Drawing.Size(728, 383)
        Me.picImage.TabIndex = 0
        Me.picImage.TabStop = False
        '
        'ToolBar1
        '
        Me.ToolBar1.Buttons.AddRange(New System.Windows.Forms.ToolBarButton() {Me.tbbBrowse, Me.tbbOpen, Me.tbbSave, Me.Seperator1, Me.tbbView, Me.tbbHide, Me.tbbPrevious, Me.tbbNext})
        Me.ToolBar1.DropDownArrows = True
        Me.ToolBar1.Name = "ToolBar1"
        Me.ToolBar1.ShowToolTips = True
        Me.ToolBar1.Size = New System.Drawing.Size(728, 39)
        Me.ToolBar1.TabIndex = 1
        '
        'tbbBrowse
        '
        Me.tbbBrowse.Text = "Browse"
        '
        'tbbOpen
        '
        Me.tbbOpen.Text = "Open"
        '
        'tbbSave
        '
        Me.tbbSave.Text = "Save"
        '
        'Seperator1
        '
        Me.Seperator1.Style = System.Windows.Forms.ToolBarButtonStyle.Separator
        '
        'tbbView
        '
        Me.tbbView.DropDownMenu = Me.cmView
        Me.tbbView.Style = System.Windows.Forms.ToolBarButtonStyle.DropDownButton
        Me.tbbView.Text = "View"
        '
        'cmView
        '
        Me.cmView.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuCenter, Me.mnuBestFit, Me.mnuStrech, Me.mnuNormal})
        '
        'mnuCenter
        '
        Me.mnuCenter.Index = 0
        Me.mnuCenter.Text = "&Center"
        '
        'mnuBestFit
        '
        Me.mnuBestFit.Index = 1
        Me.mnuBestFit.Text = "Best &Fit"
        '
        'mnuStrech
        '
        Me.mnuStrech.Index = 2
        Me.mnuStrech.Text = "&Strech"
        '
        'mnuNormal
        '
        Me.mnuNormal.Index = 3
        Me.mnuNormal.Text = "&Normal"
        '
        'tbbHide
        '
        Me.tbbHide.Text = "Hide"
        Me.tbbHide.ToolTipText = "Hide Tool Bar"
        '
        'tbbNext
        '
        Me.tbbNext.Text = "Next"
        '
        'pnlImage
        '
        Me.pnlImage.AutoScroll = True
        Me.pnlImage.Controls.AddRange(New System.Windows.Forms.Control() {Me.picImage})
        Me.pnlImage.Dock = System.Windows.Forms.DockStyle.Fill
        Me.pnlImage.Location = New System.Drawing.Point(0, 39)
        Me.pnlImage.Name = "pnlImage"
        Me.pnlImage.Size = New System.Drawing.Size(728, 383)
        Me.pnlImage.TabIndex = 2
        '
        'tbbPrevious
        '
        Me.tbbPrevious.Text = "Previous"
        '
        'frmFullView
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(728, 422)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.pnlImage, Me.ToolBar1})
        Me.Name = "frmFullView"
        Me.Text = "frmFullView"
        Me.WindowState = System.Windows.Forms.FormWindowState.Maximized
        Me.pnlImage.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region
    'events for the main form to handle
    Public Event NextImage()
    Public Event PreviousImage()

    Dim CurrentPath As String

    'sets the picturebox image
    Public Sub SetImage(ByVal PathValue As String)
        Try

            Me.picImage.Image = Image.FromFile(PathValue)
            Me.Text = PathValue


            CurrentPath = PathValue


        Catch
            MessageBox.Show("Error loading image.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error)


        End Try

    End Sub

    Private Sub ToolBar1_ButtonClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ToolBarButtonClickEventArgs) Handles ToolBar1.ButtonClick

        Select Case ToolBar1.Buttons.IndexOf(e.Button)


            Case 1 'CaseOpen


            Case 0  'case Browse
                Me.Dispose()
            Case 6 'case previous
                RaiseEvent PreviousImage()
            Case 7 'case Next
                'Me.SetImage(CType(,frmBrowser).GetNextImage)
                RaiseEvent NextImage()

        End Select


    End Sub

    'works after normal view if you minimize then maximize
    Private Sub mnuCenter_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuCenter.Click
        Me.pnlImage.Dock = DockStyle.Fill
        Me.picImage.Dock = DockStyle.Fill

        Me.picImage.SizeMode = PictureBoxSizeMode.CenterImage
        Me.Refresh()



    End Sub

    Private Sub mnuBestFit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuBestFit.Click
        Me.picImage.Dock = DockStyle.Fill
        'need code

    End Sub

    'works after normal view if you minimize then maximize
    Private Sub mnuStrech_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuStrech.Click
        Me.picImage.Dock = DockStyle.Fill
        Me.picImage.SizeMode = PictureBoxSizeMode.StretchImage
        

    End Sub

    Private Sub mnuNormal_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuNormal.Click

        'Me.picImage.SizeMode = PictureBoxSizeMode.AutoSize
        Me.picImage.Dock = DockStyle.None
        Me.picImage.SizeMode = PictureBoxSizeMode.AutoSize
        Me.pnlImage.Invalidate()
        Me.picImage.Invalidate()

    End Sub


    Private Sub frmFullView_KeyDown(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles MyBase.KeyDown

        Select Case e.KeyCode

            Case Keys.PageDown
                RaiseEvent NextImage()

            Case Keys.PageUp
                RaiseEvent PreviousImage()

        End Select
    End Sub



    Protected Overrides Sub OnMouseWheel(ByVal e As System.Windows.Forms.MouseEventArgs)
        Select Case e.Delta
            Case Is > 0
                RaiseEvent PreviousImage()
            Case Is < 0

                RaiseEvent NextImage()
        End Select
    End Sub

    Private Sub frmFullView_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Me.picImage.SizeMode = PictureBoxSizeMode.CenterImage

    End Sub
End Class
